/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.nft;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.client.nft.NftInfoRequestParams;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NftInfoRequestParams", generator="Immutables")
@Immutable
public final class ImmutableNftInfoRequestParams
implements NftInfoRequestParams {
    private final NfTokenId nfTokenId;
    private final LedgerSpecifier ledgerSpecifier;

    private ImmutableNftInfoRequestParams(NfTokenId nfTokenId, LedgerSpecifier ledgerSpecifier) {
        this.nfTokenId = nfTokenId;
        this.ledgerSpecifier = ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="nft_id")
    public NfTokenId nfTokenId() {
        return this.nfTokenId;
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        return this.ledgerSpecifier;
    }

    public final ImmutableNftInfoRequestParams withNfTokenId(NfTokenId value) {
        if (this.nfTokenId == value) {
            return this;
        }
        NfTokenId newValue = Objects.requireNonNull(value, "nfTokenId");
        return new ImmutableNftInfoRequestParams(newValue, this.ledgerSpecifier);
    }

    public final ImmutableNftInfoRequestParams withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableNftInfoRequestParams(this.nfTokenId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNftInfoRequestParams && this.equalTo(0, (ImmutableNftInfoRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableNftInfoRequestParams another) {
        return this.nfTokenId.equals(another.nfTokenId) && this.ledgerSpecifier.equals(another.ledgerSpecifier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nfTokenId.hashCode();
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NftInfoRequestParams").omitNullValues().add("nfTokenId", (Object)this.nfTokenId).add("ledgerSpecifier", (Object)this.ledgerSpecifier).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNftInfoRequestParams fromJson(Json json) {
        Builder builder = ImmutableNftInfoRequestParams.builder();
        if (json.nfTokenId != null) {
            builder.nfTokenId(json.nfTokenId);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        return builder.build();
    }

    public static ImmutableNftInfoRequestParams copyOf(NftInfoRequestParams instance) {
        if (instance instanceof ImmutableNftInfoRequestParams) {
            return (ImmutableNftInfoRequestParams)instance;
        }
        return ImmutableNftInfoRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NftInfoRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NF_TOKEN_ID = 1L;
        private static final long INIT_BIT_LEDGER_SPECIFIER = 2L;
        private long initBits = 3L;
        @Nullable
        private NfTokenId nfTokenId;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NftInfoRequestParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.nfTokenId(instance.nfTokenId());
            this.ledgerSpecifier(instance.ledgerSpecifier());
            return this;
        }

        @JsonProperty(value="nft_id")
        @CanIgnoreReturnValue
        public final Builder nfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = Objects.requireNonNull(nfTokenId, "nfTokenId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableNftInfoRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNftInfoRequestParams(this.nfTokenId, this.ledgerSpecifier);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nfTokenId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ledgerSpecifier");
            }
            return "Cannot build NftInfoRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NftInfoRequestParams", generator="Immutables")
    static final class Json
    implements NftInfoRequestParams {
        @Nullable
        NfTokenId nfTokenId;
        @Nullable
        LedgerSpecifier ledgerSpecifier;

        Json() {
        }

        @JsonProperty(value="nft_id")
        public void setNfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = nfTokenId;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @Override
        public NfTokenId nfTokenId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }
    }
}

