/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.nft;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.nft.BuyOffer;
import org.xrpl.xrpl4j.model.client.nft.NftBuyOffersResult;
import org.xrpl.xrpl4j.model.transactions.Marker;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NftBuyOffersResult", generator="Immutables")
@Immutable
public final class ImmutableNftBuyOffersResult
implements NftBuyOffersResult {
    @Nullable
    private final String status;
    private final NfTokenId nfTokenId;
    private final ImmutableList<BuyOffer> offers;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;

    private ImmutableNftBuyOffersResult(@Nullable String status, NfTokenId nfTokenId, ImmutableList<BuyOffer> offers, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.status = status;
        this.nfTokenId = nfTokenId;
        this.offers = offers;
        this.limit = limit;
        this.marker = marker;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="nft_id")
    public NfTokenId nfTokenId() {
        return this.nfTokenId;
    }

    @JsonProperty(value="offers")
    public ImmutableList<BuyOffer> offers() {
        return this.offers;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableNftBuyOffersResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableNftBuyOffersResult(newValue, this.nfTokenId, this.offers, this.limit, this.marker);
    }

    public final ImmutableNftBuyOffersResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableNftBuyOffersResult(value, this.nfTokenId, this.offers, this.limit, this.marker);
    }

    public final ImmutableNftBuyOffersResult withNfTokenId(NfTokenId value) {
        if (this.nfTokenId == value) {
            return this;
        }
        NfTokenId newValue = Objects.requireNonNull(value, "nfTokenId");
        return new ImmutableNftBuyOffersResult(this.status, newValue, this.offers, this.limit, this.marker);
    }

    public final ImmutableNftBuyOffersResult withOffers(BuyOffer ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableNftBuyOffersResult(this.status, this.nfTokenId, (ImmutableList<BuyOffer>)newValue, this.limit, this.marker);
    }

    public final ImmutableNftBuyOffersResult withOffers(Iterable<? extends BuyOffer> elements) {
        if (this.offers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableNftBuyOffersResult(this.status, this.nfTokenId, (ImmutableList<BuyOffer>)newValue, this.limit, this.marker);
    }

    public final ImmutableNftBuyOffersResult withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableNftBuyOffersResult(this.status, this.nfTokenId, this.offers, newValue, this.marker);
    }

    public final ImmutableNftBuyOffersResult withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableNftBuyOffersResult(this.status, this.nfTokenId, this.offers, value, this.marker);
    }

    public final ImmutableNftBuyOffersResult withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableNftBuyOffersResult(this.status, this.nfTokenId, this.offers, this.limit, newValue);
    }

    public final ImmutableNftBuyOffersResult withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableNftBuyOffersResult(this.status, this.nfTokenId, this.offers, this.limit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNftBuyOffersResult && this.equalTo(0, (ImmutableNftBuyOffersResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableNftBuyOffersResult another) {
        return Objects.equals(this.status, another.status) && this.nfTokenId.equals(another.nfTokenId) && this.offers.equals(another.offers) && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.nfTokenId.hashCode();
        h += (h << 5) + this.offers.hashCode();
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NftBuyOffersResult").omitNullValues().add("status", (Object)this.status).add("nfTokenId", (Object)this.nfTokenId).add("offers", this.offers).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNftBuyOffersResult fromJson(Json json) {
        Builder builder = ImmutableNftBuyOffersResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.nfTokenId != null) {
            builder.nfTokenId(json.nfTokenId);
        }
        if (json.offers != null) {
            builder.addAllOffers(json.offers);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    public static ImmutableNftBuyOffersResult copyOf(NftBuyOffersResult instance) {
        if (instance instanceof ImmutableNftBuyOffersResult) {
            return (ImmutableNftBuyOffersResult)instance;
        }
        return ImmutableNftBuyOffersResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NftBuyOffersResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NF_TOKEN_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String status;
        @Nullable
        private NfTokenId nfTokenId;
        private ImmutableList.Builder<BuyOffer> offers = ImmutableList.builder();
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NftBuyOffersResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof NftBuyOffersResult) {
                instance = (NftBuyOffersResult)object;
                this.addAllOffers(instance.offers());
                Optional<UnsignedInteger> limitOptional = instance.limit();
                if (limitOptional.isPresent()) {
                    this.limit(limitOptional);
                }
                this.nfTokenId(instance.nfTokenId());
                Optional<Marker> markerOptional = instance.marker();
                if (markerOptional.isPresent()) {
                    this.marker(markerOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="nft_id")
        @CanIgnoreReturnValue
        public final Builder nfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = Objects.requireNonNull(nfTokenId, "nfTokenId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOffers(BuyOffer element) {
            this.offers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOffers(BuyOffer ... elements) {
            this.offers.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="offers")
        @CanIgnoreReturnValue
        public final Builder offers(Iterable<? extends BuyOffer> elements) {
            this.offers = ImmutableList.builder();
            return this.addAllOffers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllOffers(Iterable<? extends BuyOffer> elements) {
            this.offers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableNftBuyOffersResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNftBuyOffersResult(this.status, this.nfTokenId, this.offers.build(), this.limit, this.marker);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nfTokenId");
            }
            return "Cannot build NftBuyOffersResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NftBuyOffersResult", generator="Immutables")
    static final class Json
    implements NftBuyOffersResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        NfTokenId nfTokenId;
        @Nullable
        List<BuyOffer> offers = ImmutableList.of();
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="nft_id")
        public void setNfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = nfTokenId;
        }

        @JsonProperty(value="offers")
        public void setOffers(List<BuyOffer> offers) {
            this.offers = offers;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NfTokenId nfTokenId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<BuyOffer> offers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }
}

