/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.ledger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.client.ledger.AmmLedgerEntryParams;
import org.xrpl.xrpl4j.model.client.ledger.DepositPreAuthLedgerEntryParams;
import org.xrpl.xrpl4j.model.client.ledger.EscrowLedgerEntryParams;
import org.xrpl.xrpl4j.model.client.ledger.ImmutableLedgerEntryRequestParams;
import org.xrpl.xrpl4j.model.client.ledger.OfferLedgerEntryParams;
import org.xrpl.xrpl4j.model.client.ledger.RippleStateLedgerEntryParams;
import org.xrpl.xrpl4j.model.client.ledger.TicketLedgerEntryParams;
import org.xrpl.xrpl4j.model.ledger.AccountRootObject;
import org.xrpl.xrpl4j.model.ledger.AmmObject;
import org.xrpl.xrpl4j.model.ledger.BridgeObject;
import org.xrpl.xrpl4j.model.ledger.CheckObject;
import org.xrpl.xrpl4j.model.ledger.DepositPreAuthObject;
import org.xrpl.xrpl4j.model.ledger.DidObject;
import org.xrpl.xrpl4j.model.ledger.EscrowObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.NfTokenPageObject;
import org.xrpl.xrpl4j.model.ledger.OfferObject;
import org.xrpl.xrpl4j.model.ledger.PayChannelObject;
import org.xrpl.xrpl4j.model.ledger.RippleStateObject;
import org.xrpl.xrpl4j.model.ledger.TicketObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;

@JsonSerialize(as=ImmutableLedgerEntryRequestParams.class)
@JsonDeserialize(as=ImmutableLedgerEntryRequestParams.class)
@Value.Immutable
@Value.Style(builderVisibility=Value.Style.BuilderVisibility.PACKAGE)
public interface LedgerEntryRequestParams<T extends LedgerObject>
extends XrplRequestParams {
    public static <T extends LedgerObject> LedgerEntryRequestParams<T> index(Hash256 id, Class<T> ledgerObjectClass, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().index(id).ledgerObjectClass(ledgerObjectClass).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<LedgerObject> index(Hash256 id, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().index(id).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<AccountRootObject> accountRoot(Address address, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().accountRoot(address).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<AmmObject> amm(AmmLedgerEntryParams params, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().amm(params).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<OfferObject> offer(OfferLedgerEntryParams params, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().offer(params).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<RippleStateObject> rippleState(RippleStateLedgerEntryParams params, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().rippleState(params).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<CheckObject> check(Hash256 id, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().check(id).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<EscrowObject> escrow(EscrowLedgerEntryParams params, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().escrow(params).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<PayChannelObject> paymentChannel(Hash256 id, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().paymentChannel(id).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<DepositPreAuthObject> depositPreAuth(DepositPreAuthLedgerEntryParams params, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().depositPreAuth(params).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<TicketObject> ticket(TicketLedgerEntryParams params, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().ticket(params).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<NfTokenPageObject> nftPage(Hash256 id, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().nftPage(id).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<BridgeObject> bridge(Address bridgeAccount, XChainBridge bridge, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().bridgeAccount(bridgeAccount).bridge(bridge).ledgerSpecifier(ledgerSpecifier).build();
    }

    public static LedgerEntryRequestParams<DidObject> did(Address address, LedgerSpecifier ledgerSpecifier) {
        return ImmutableLedgerEntryRequestParams.builder().did(address).ledgerSpecifier(ledgerSpecifier).build();
    }

    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier();

    @Value.Derived
    default public boolean binary() {
        return false;
    }

    public Optional<Hash256> index();

    @JsonProperty(value="account_root")
    public Optional<Address> accountRoot();

    public Optional<AmmLedgerEntryParams> amm();

    public Optional<OfferLedgerEntryParams> offer();

    @JsonProperty(value="ripple_state")
    public Optional<RippleStateLedgerEntryParams> rippleState();

    public Optional<Hash256> check();

    public Optional<EscrowLedgerEntryParams> escrow();

    @JsonProperty(value="payment_channel")
    public Optional<Hash256> paymentChannel();

    @JsonProperty(value="nft_page")
    public Optional<Hash256> nftPage();

    @JsonProperty(value="deposit_preauth")
    public Optional<DepositPreAuthLedgerEntryParams> depositPreAuth();

    public Optional<TicketLedgerEntryParams> ticket();

    public Optional<Address> did();

    @JsonProperty(value="bridge_account")
    public Optional<Address> bridgeAccount();

    public Optional<XChainBridge> bridge();

    @JsonIgnore
    @Value.Default
    default public Class<T> ledgerObjectClass() {
        if (this.accountRoot().isPresent()) {
            return AccountRootObject.class;
        }
        if (this.amm().isPresent()) {
            return AmmObject.class;
        }
        if (this.offer().isPresent()) {
            return OfferObject.class;
        }
        if (this.rippleState().isPresent()) {
            return RippleStateObject.class;
        }
        if (this.check().isPresent()) {
            return CheckObject.class;
        }
        if (this.escrow().isPresent()) {
            return EscrowObject.class;
        }
        if (this.paymentChannel().isPresent()) {
            return PayChannelObject.class;
        }
        if (this.nftPage().isPresent()) {
            return NfTokenPageObject.class;
        }
        if (this.depositPreAuth().isPresent()) {
            return DepositPreAuthObject.class;
        }
        if (this.ticket().isPresent()) {
            return TicketObject.class;
        }
        if (this.bridgeAccount().isPresent() || this.bridge().isPresent()) {
            return BridgeObject.class;
        }
        if (this.did().isPresent()) {
            return DidObject.class;
        }
        return LedgerObject.class;
    }
}

