/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.ledger.TicketLedgerEntryParams;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TicketLedgerEntryParams", generator="Immutables")
@Immutable
public final class ImmutableTicketLedgerEntryParams
implements TicketLedgerEntryParams {
    private final Address account;
    private final UnsignedInteger ticketSeq;

    private ImmutableTicketLedgerEntryParams(Address account, UnsignedInteger ticketSeq) {
        this.account = account;
        this.ticketSeq = ticketSeq;
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="ticket_seq")
    public UnsignedInteger ticketSeq() {
        return this.ticketSeq;
    }

    public final ImmutableTicketLedgerEntryParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableTicketLedgerEntryParams(newValue, this.ticketSeq);
    }

    public final ImmutableTicketLedgerEntryParams withTicketSeq(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "ticketSeq");
        if (this.ticketSeq.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTicketLedgerEntryParams(this.account, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTicketLedgerEntryParams && this.equalTo(0, (ImmutableTicketLedgerEntryParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableTicketLedgerEntryParams another) {
        return this.account.equals(another.account) && this.ticketSeq.equals((Object)another.ticketSeq);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.ticketSeq.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TicketLedgerEntryParams").omitNullValues().add("account", (Object)this.account).add("ticketSeq", (Object)this.ticketSeq).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTicketLedgerEntryParams fromJson(Json json) {
        Builder builder = ImmutableTicketLedgerEntryParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.ticketSeq != null) {
            builder.ticketSeq(json.ticketSeq);
        }
        return builder.build();
    }

    public static ImmutableTicketLedgerEntryParams copyOf(TicketLedgerEntryParams instance) {
        if (instance instanceof ImmutableTicketLedgerEntryParams) {
            return (ImmutableTicketLedgerEntryParams)instance;
        }
        return ImmutableTicketLedgerEntryParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TicketLedgerEntryParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_TICKET_SEQ = 2L;
        private long initBits = 3L;
        @Nullable
        private Address account;
        @Nullable
        private UnsignedInteger ticketSeq;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TicketLedgerEntryParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.ticketSeq(instance.ticketSeq());
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ticket_seq")
        @CanIgnoreReturnValue
        public final Builder ticketSeq(UnsignedInteger ticketSeq) {
            this.ticketSeq = Objects.requireNonNull(ticketSeq, "ticketSeq");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTicketLedgerEntryParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTicketLedgerEntryParams(this.account, this.ticketSeq);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ticketSeq");
            }
            return "Cannot build TicketLedgerEntryParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TicketLedgerEntryParams", generator="Immutables")
    static final class Json
    implements TicketLedgerEntryParams {
        @Nullable
        Address account;
        @Nullable
        UnsignedInteger ticketSeq;

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="ticket_seq")
        public void setTicketSeq(UnsignedInteger ticketSeq) {
            this.ticketSeq = ticketSeq;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger ticketSeq() {
            throw new UnsupportedOperationException();
        }
    }
}

