/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.ledger.OfferLedgerEntryParams;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OfferLedgerEntryParams", generator="Immutables")
@Immutable
public final class ImmutableOfferLedgerEntryParams
implements OfferLedgerEntryParams {
    private final Address account;
    private final UnsignedInteger seq;

    private ImmutableOfferLedgerEntryParams(Address account, UnsignedInteger seq) {
        this.account = account;
        this.seq = seq;
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="seq")
    public UnsignedInteger seq() {
        return this.seq;
    }

    public final ImmutableOfferLedgerEntryParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableOfferLedgerEntryParams(newValue, this.seq);
    }

    public final ImmutableOfferLedgerEntryParams withSeq(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "seq");
        if (this.seq.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOfferLedgerEntryParams(this.account, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOfferLedgerEntryParams && this.equalTo(0, (ImmutableOfferLedgerEntryParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableOfferLedgerEntryParams another) {
        return this.account.equals(another.account) && this.seq.equals((Object)another.seq);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.seq.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OfferLedgerEntryParams").omitNullValues().add("account", (Object)this.account).add("seq", (Object)this.seq).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOfferLedgerEntryParams fromJson(Json json) {
        Builder builder = ImmutableOfferLedgerEntryParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.seq != null) {
            builder.seq(json.seq);
        }
        return builder.build();
    }

    public static ImmutableOfferLedgerEntryParams copyOf(OfferLedgerEntryParams instance) {
        if (instance instanceof ImmutableOfferLedgerEntryParams) {
            return (ImmutableOfferLedgerEntryParams)instance;
        }
        return ImmutableOfferLedgerEntryParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OfferLedgerEntryParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_SEQ = 2L;
        private long initBits = 3L;
        @Nullable
        private Address account;
        @Nullable
        private UnsignedInteger seq;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OfferLedgerEntryParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.seq(instance.seq());
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="seq")
        @CanIgnoreReturnValue
        public final Builder seq(UnsignedInteger seq) {
            this.seq = Objects.requireNonNull(seq, "seq");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableOfferLedgerEntryParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOfferLedgerEntryParams(this.account, this.seq);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("seq");
            }
            return "Cannot build OfferLedgerEntryParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OfferLedgerEntryParams", generator="Immutables")
    static final class Json
    implements OfferLedgerEntryParams {
        @Nullable
        Address account;
        @Nullable
        UnsignedInteger seq;

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="seq")
        public void setSeq(UnsignedInteger seq) {
            this.seq = seq;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger seq() {
            throw new UnsupportedOperationException();
        }
    }
}

