/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.ledger.LedgerEntryResult;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LedgerEntryResult", generator="Immutables")
@Immutable
public final class ImmutableLedgerEntryResult<T extends LedgerObject>
implements LedgerEntryResult<T> {
    @Nullable
    private final String status;
    private final T node;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final LedgerIndex ledgerCurrentIndex;
    private final boolean validated;
    private final Hash256 index;

    private ImmutableLedgerEntryResult(Builder<T> builder) {
        this.status = ((Builder)builder).status;
        this.node = ((Builder)builder).node;
        this.ledgerHash = ((Builder)builder).ledgerHash;
        this.ledgerIndex = ((Builder)builder).ledgerIndex;
        this.ledgerCurrentIndex = ((Builder)builder).ledgerCurrentIndex;
        this.index = ((Builder)builder).index;
        this.validated = ((Builder)builder).validatedIsSet() ? ((Builder)builder).validated : LedgerEntryResult.super.validated();
    }

    private ImmutableLedgerEntryResult(@Nullable String status, T node, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, @Nullable LedgerIndex ledgerCurrentIndex, boolean validated, Hash256 index) {
        this.status = status;
        this.node = node;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
        this.validated = validated;
        this.index = index;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="node")
    public T node() {
        return this.node;
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex() {
        return Optional.ofNullable(this.ledgerCurrentIndex);
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        return this.validated;
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableLedgerEntryResult<T> withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableLedgerEntryResult<T>(newValue, this.node, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.index);
    }

    public final ImmutableLedgerEntryResult<T> withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableLedgerEntryResult<T>(value, this.node, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.index);
    }

    public final ImmutableLedgerEntryResult<T> withNode(T value) {
        if (this.node == value) {
            return this;
        }
        LedgerObject newValue = (LedgerObject)Objects.requireNonNull(value, "node");
        return new ImmutableLedgerEntryResult<LedgerObject>(this.status, newValue, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.index);
    }

    public final ImmutableLedgerEntryResult<T> withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryResult<T>(this.status, this.node, newValue, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.index);
    }

    public final ImmutableLedgerEntryResult<T> withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableLedgerEntryResult<T>(this.status, this.node, value, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.index);
    }

    public final ImmutableLedgerEntryResult<T> withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryResult<T>(this.status, this.node, this.ledgerHash, newValue, this.ledgerCurrentIndex, this.validated, this.index);
    }

    public final ImmutableLedgerEntryResult<T> withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableLedgerEntryResult<T>(this.status, this.node, this.ledgerHash, value, this.ledgerCurrentIndex, this.validated, this.index);
    }

    public final ImmutableLedgerEntryResult<T> withLedgerCurrentIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        if (this.ledgerCurrentIndex == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryResult<T>(this.status, this.node, this.ledgerHash, this.ledgerIndex, newValue, this.validated, this.index);
    }

    public final ImmutableLedgerEntryResult<T> withLedgerCurrentIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        return new ImmutableLedgerEntryResult<T>(this.status, this.node, this.ledgerHash, this.ledgerIndex, value, this.validated, this.index);
    }

    public final ImmutableLedgerEntryResult<T> withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableLedgerEntryResult<T>(this.status, this.node, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, value, this.index);
    }

    public final ImmutableLedgerEntryResult<T> withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableLedgerEntryResult<T>(this.status, this.node, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLedgerEntryResult && this.equalTo(0, (ImmutableLedgerEntryResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableLedgerEntryResult<?> another) {
        return Objects.equals(this.status, another.status) && this.node.equals(another.node) && Objects.equals(this.ledgerHash, another.ledgerHash) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && Objects.equals(this.ledgerCurrentIndex, another.ledgerCurrentIndex) && this.validated == another.validated && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerCurrentIndex);
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LedgerEntryResult").omitNullValues().add("status", (Object)this.status).add("node", this.node).add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).add("validated", this.validated).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends LedgerObject> ImmutableLedgerEntryResult<T> fromJson(Json<T> json) {
        Builder builder = ImmutableLedgerEntryResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static <T extends LedgerObject> ImmutableLedgerEntryResult<T> copyOf(LedgerEntryResult<T> instance) {
        if (instance instanceof ImmutableLedgerEntryResult) {
            return (ImmutableLedgerEntryResult)instance;
        }
        return ImmutableLedgerEntryResult.builder().from(instance).build();
    }

    public static <T extends LedgerObject> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="LedgerEntryResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends LedgerObject> {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_INDEX = 2L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private T node;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;
        private boolean validated;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(LedgerEntryResult<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof LedgerEntryResult) {
                instance = (LedgerEntryResult)object;
                this.node(instance.node());
                Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
                if (ledgerHashOptional.isPresent()) {
                    this.ledgerHash(ledgerHashOptional);
                }
                this.validated(instance.validated());
                Optional<LedgerIndex> ledgerIndexOptional = instance.ledgerIndex();
                if (ledgerIndexOptional.isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                this.index(instance.index());
                Optional<LedgerIndex> ledgerCurrentIndexOptional = instance.ledgerCurrentIndex();
                if (ledgerCurrentIndexOptional.isPresent()) {
                    this.ledgerCurrentIndex(ledgerCurrentIndexOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder<T> status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="node")
        @CanIgnoreReturnValue
        public final Builder<T> node(T node) {
            this.node = (LedgerObject)Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder<T> ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder<T> ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder<T> ledgerCurrentIndex(Optional<? extends LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex.orElse(null);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder<T> validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder<T> index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLedgerEntryResult<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLedgerEntryResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build LedgerEntryResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LedgerEntryResult", generator="Immutables")
    static final class Json<T extends LedgerObject>
    implements LedgerEntryResult<T> {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        T node;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerCurrentIndex = Optional.empty();
        boolean validated;
        boolean validatedIsSet;
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="node")
        public void setNode(T node) {
            this.node = node;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(Optional<LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T node() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

