/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.client.ledger.AmmLedgerEntryParams;
import org.xrpl.xrpl4j.model.client.ledger.DepositPreAuthLedgerEntryParams;
import org.xrpl.xrpl4j.model.client.ledger.EscrowLedgerEntryParams;
import org.xrpl.xrpl4j.model.client.ledger.LedgerEntryRequestParams;
import org.xrpl.xrpl4j.model.client.ledger.OfferLedgerEntryParams;
import org.xrpl.xrpl4j.model.client.ledger.RippleStateLedgerEntryParams;
import org.xrpl.xrpl4j.model.client.ledger.TicketLedgerEntryParams;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LedgerEntryRequestParams", generator="Immutables")
@Immutable
public final class ImmutableLedgerEntryRequestParams<T extends LedgerObject>
implements LedgerEntryRequestParams<T> {
    private final LedgerSpecifier ledgerSpecifier;
    private final transient boolean binary;
    @Nullable
    private final Hash256 index;
    @Nullable
    private final Address accountRoot;
    @Nullable
    private final AmmLedgerEntryParams amm;
    @Nullable
    private final OfferLedgerEntryParams offer;
    @Nullable
    private final RippleStateLedgerEntryParams rippleState;
    @Nullable
    private final Hash256 check;
    @Nullable
    private final EscrowLedgerEntryParams escrow;
    @Nullable
    private final Hash256 paymentChannel;
    @Nullable
    private final Hash256 nftPage;
    @Nullable
    private final DepositPreAuthLedgerEntryParams depositPreAuth;
    @Nullable
    private final TicketLedgerEntryParams ticket;
    @Nullable
    private final Address did;
    @Nullable
    private final Address bridgeAccount;
    @Nullable
    private final XChainBridge bridge;
    private final Class<T> ledgerObjectClass;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLedgerEntryRequestParams(Builder<T> builder) {
        this.ledgerSpecifier = ((Builder)builder).ledgerSpecifier;
        this.index = ((Builder)builder).index;
        this.accountRoot = ((Builder)builder).accountRoot;
        this.amm = ((Builder)builder).amm;
        this.offer = ((Builder)builder).offer;
        this.rippleState = ((Builder)builder).rippleState;
        this.check = ((Builder)builder).check;
        this.escrow = ((Builder)builder).escrow;
        this.paymentChannel = ((Builder)builder).paymentChannel;
        this.nftPage = ((Builder)builder).nftPage;
        this.depositPreAuth = ((Builder)builder).depositPreAuth;
        this.ticket = ((Builder)builder).ticket;
        this.did = ((Builder)builder).did;
        this.bridgeAccount = ((Builder)builder).bridgeAccount;
        this.bridge = ((Builder)builder).bridge;
        if (((Builder)builder).ledgerObjectClass != null) {
            this.initShim.ledgerObjectClass(((Builder)builder).ledgerObjectClass);
        }
        this.binary = this.initShim.binary();
        this.ledgerObjectClass = this.initShim.ledgerObjectClass();
        this.initShim = null;
    }

    private ImmutableLedgerEntryRequestParams(LedgerSpecifier ledgerSpecifier, @Nullable Hash256 index, @Nullable Address accountRoot, @Nullable AmmLedgerEntryParams amm, @Nullable OfferLedgerEntryParams offer, @Nullable RippleStateLedgerEntryParams rippleState, @Nullable Hash256 check, @Nullable EscrowLedgerEntryParams escrow, @Nullable Hash256 paymentChannel, @Nullable Hash256 nftPage, @Nullable DepositPreAuthLedgerEntryParams depositPreAuth, @Nullable TicketLedgerEntryParams ticket, @Nullable Address did, @Nullable Address bridgeAccount, @Nullable XChainBridge bridge, Class<T> ledgerObjectClass) {
        this.ledgerSpecifier = ledgerSpecifier;
        this.index = index;
        this.accountRoot = accountRoot;
        this.amm = amm;
        this.offer = offer;
        this.rippleState = rippleState;
        this.check = check;
        this.escrow = escrow;
        this.paymentChannel = paymentChannel;
        this.nftPage = nftPage;
        this.depositPreAuth = depositPreAuth;
        this.ticket = ticket;
        this.did = did;
        this.bridgeAccount = bridgeAccount;
        this.bridge = bridge;
        this.initShim.ledgerObjectClass(ledgerObjectClass);
        this.binary = this.initShim.binary();
        this.ledgerObjectClass = this.initShim.ledgerObjectClass();
        this.initShim = null;
    }

    private boolean binaryInitialize() {
        return LedgerEntryRequestParams.super.binary();
    }

    private Class<T> ledgerObjectClassInitialize() {
        return LedgerEntryRequestParams.super.ledgerObjectClass();
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        return this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="binary")
    public boolean binary() {
        InitShim shim = this.initShim;
        return shim != null ? shim.binary() : this.binary;
    }

    @Override
    @JsonProperty(value="index")
    public Optional<Hash256> index() {
        return Optional.ofNullable(this.index);
    }

    @Override
    @JsonProperty(value="account_root")
    public Optional<Address> accountRoot() {
        return Optional.ofNullable(this.accountRoot);
    }

    @Override
    @JsonProperty(value="amm")
    public Optional<AmmLedgerEntryParams> amm() {
        return Optional.ofNullable(this.amm);
    }

    @Override
    @JsonProperty(value="offer")
    public Optional<OfferLedgerEntryParams> offer() {
        return Optional.ofNullable(this.offer);
    }

    @Override
    @JsonProperty(value="ripple_state")
    public Optional<RippleStateLedgerEntryParams> rippleState() {
        return Optional.ofNullable(this.rippleState);
    }

    @Override
    @JsonProperty(value="check")
    public Optional<Hash256> check() {
        return Optional.ofNullable(this.check);
    }

    @Override
    @JsonProperty(value="escrow")
    public Optional<EscrowLedgerEntryParams> escrow() {
        return Optional.ofNullable(this.escrow);
    }

    @Override
    @JsonProperty(value="payment_channel")
    public Optional<Hash256> paymentChannel() {
        return Optional.ofNullable(this.paymentChannel);
    }

    @Override
    @JsonProperty(value="nft_page")
    public Optional<Hash256> nftPage() {
        return Optional.ofNullable(this.nftPage);
    }

    @Override
    @JsonProperty(value="deposit_preauth")
    public Optional<DepositPreAuthLedgerEntryParams> depositPreAuth() {
        return Optional.ofNullable(this.depositPreAuth);
    }

    @Override
    @JsonProperty(value="ticket")
    public Optional<TicketLedgerEntryParams> ticket() {
        return Optional.ofNullable(this.ticket);
    }

    @Override
    @JsonProperty(value="did")
    public Optional<Address> did() {
        return Optional.ofNullable(this.did);
    }

    @Override
    @JsonProperty(value="bridge_account")
    public Optional<Address> bridgeAccount() {
        return Optional.ofNullable(this.bridgeAccount);
    }

    @Override
    @JsonProperty(value="bridge")
    public Optional<XChainBridge> bridge() {
        return Optional.ofNullable(this.bridge);
    }

    @Override
    @JsonProperty(value="ledgerObjectClass")
    @JsonIgnore
    public Class<T> ledgerObjectClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerObjectClass() : this.ledgerObjectClass;
    }

    public final ImmutableLedgerEntryRequestParams<T> withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableLedgerEntryRequestParams<T>(newValue, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withIndex(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "index");
        if (this.index == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, newValue, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withIndex(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.index == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, value, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withAccountRoot(Address value) {
        Address newValue = Objects.requireNonNull(value, "accountRoot");
        if (this.accountRoot == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, newValue, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withAccountRoot(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.accountRoot == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, value, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withAmm(AmmLedgerEntryParams value) {
        AmmLedgerEntryParams newValue = Objects.requireNonNull(value, "amm");
        if (this.amm == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, newValue, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withAmm(Optional<? extends AmmLedgerEntryParams> optional) {
        AmmLedgerEntryParams value = optional.orElse(null);
        if (this.amm == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, value, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withOffer(OfferLedgerEntryParams value) {
        OfferLedgerEntryParams newValue = Objects.requireNonNull(value, "offer");
        if (this.offer == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, newValue, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withOffer(Optional<? extends OfferLedgerEntryParams> optional) {
        OfferLedgerEntryParams value = optional.orElse(null);
        if (this.offer == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, value, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withRippleState(RippleStateLedgerEntryParams value) {
        RippleStateLedgerEntryParams newValue = Objects.requireNonNull(value, "rippleState");
        if (this.rippleState == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, newValue, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withRippleState(Optional<? extends RippleStateLedgerEntryParams> optional) {
        RippleStateLedgerEntryParams value = optional.orElse(null);
        if (this.rippleState == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, value, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withCheck(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "check");
        if (this.check == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, newValue, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withCheck(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.check == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, value, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withEscrow(EscrowLedgerEntryParams value) {
        EscrowLedgerEntryParams newValue = Objects.requireNonNull(value, "escrow");
        if (this.escrow == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, newValue, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withEscrow(Optional<? extends EscrowLedgerEntryParams> optional) {
        EscrowLedgerEntryParams value = optional.orElse(null);
        if (this.escrow == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, value, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withPaymentChannel(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "paymentChannel");
        if (this.paymentChannel == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, newValue, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withPaymentChannel(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.paymentChannel == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, value, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withNftPage(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "nftPage");
        if (this.nftPage == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, newValue, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withNftPage(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.nftPage == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, value, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withDepositPreAuth(DepositPreAuthLedgerEntryParams value) {
        DepositPreAuthLedgerEntryParams newValue = Objects.requireNonNull(value, "depositPreAuth");
        if (this.depositPreAuth == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, newValue, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withDepositPreAuth(Optional<? extends DepositPreAuthLedgerEntryParams> optional) {
        DepositPreAuthLedgerEntryParams value = optional.orElse(null);
        if (this.depositPreAuth == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, value, this.ticket, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withTicket(TicketLedgerEntryParams value) {
        TicketLedgerEntryParams newValue = Objects.requireNonNull(value, "ticket");
        if (this.ticket == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, newValue, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withTicket(Optional<? extends TicketLedgerEntryParams> optional) {
        TicketLedgerEntryParams value = optional.orElse(null);
        if (this.ticket == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, value, this.did, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withDid(Address value) {
        Address newValue = Objects.requireNonNull(value, "did");
        if (this.did == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, newValue, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withDid(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.did == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, value, this.bridgeAccount, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withBridgeAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "bridgeAccount");
        if (this.bridgeAccount == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, newValue, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withBridgeAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.bridgeAccount == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, value, this.bridge, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withBridge(XChainBridge value) {
        XChainBridge newValue = Objects.requireNonNull(value, "bridge");
        if (this.bridge == newValue) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, newValue, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withBridge(Optional<? extends XChainBridge> optional) {
        XChainBridge value = optional.orElse(null);
        if (this.bridge == value) {
            return this;
        }
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, value, this.ledgerObjectClass);
    }

    public final ImmutableLedgerEntryRequestParams<T> withLedgerObjectClass(Class<T> value) {
        if (this.ledgerObjectClass == value) {
            return this;
        }
        Class<T> newValue = Objects.requireNonNull(value, "ledgerObjectClass");
        return new ImmutableLedgerEntryRequestParams<T>(this.ledgerSpecifier, this.index, this.accountRoot, this.amm, this.offer, this.rippleState, this.check, this.escrow, this.paymentChannel, this.nftPage, this.depositPreAuth, this.ticket, this.did, this.bridgeAccount, this.bridge, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLedgerEntryRequestParams && this.equalTo(0, (ImmutableLedgerEntryRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableLedgerEntryRequestParams<?> another) {
        return this.ledgerSpecifier.equals(another.ledgerSpecifier) && this.binary == another.binary && Objects.equals(this.index, another.index) && Objects.equals(this.accountRoot, another.accountRoot) && Objects.equals(this.amm, another.amm) && Objects.equals(this.offer, another.offer) && Objects.equals(this.rippleState, another.rippleState) && Objects.equals(this.check, another.check) && Objects.equals(this.escrow, another.escrow) && Objects.equals(this.paymentChannel, another.paymentChannel) && Objects.equals(this.nftPage, another.nftPage) && Objects.equals(this.depositPreAuth, another.depositPreAuth) && Objects.equals(this.ticket, another.ticket) && Objects.equals(this.did, another.did) && Objects.equals(this.bridgeAccount, another.bridgeAccount) && Objects.equals(this.bridge, another.bridge) && this.ledgerObjectClass.equals(another.ledgerObjectClass);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.binary);
        h += (h << 5) + Objects.hashCode(this.index);
        h += (h << 5) + Objects.hashCode(this.accountRoot);
        h += (h << 5) + Objects.hashCode(this.amm);
        h += (h << 5) + Objects.hashCode(this.offer);
        h += (h << 5) + Objects.hashCode(this.rippleState);
        h += (h << 5) + Objects.hashCode(this.check);
        h += (h << 5) + Objects.hashCode(this.escrow);
        h += (h << 5) + Objects.hashCode(this.paymentChannel);
        h += (h << 5) + Objects.hashCode(this.nftPage);
        h += (h << 5) + Objects.hashCode(this.depositPreAuth);
        h += (h << 5) + Objects.hashCode(this.ticket);
        h += (h << 5) + Objects.hashCode(this.did);
        h += (h << 5) + Objects.hashCode(this.bridgeAccount);
        h += (h << 5) + Objects.hashCode(this.bridge);
        h += (h << 5) + this.ledgerObjectClass.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LedgerEntryRequestParams").omitNullValues().add("ledgerSpecifier", (Object)this.ledgerSpecifier).add("binary", this.binary).add("index", (Object)this.index).add("accountRoot", (Object)this.accountRoot).add("amm", (Object)this.amm).add("offer", (Object)this.offer).add("rippleState", (Object)this.rippleState).add("check", (Object)this.check).add("escrow", (Object)this.escrow).add("paymentChannel", (Object)this.paymentChannel).add("nftPage", (Object)this.nftPage).add("depositPreAuth", (Object)this.depositPreAuth).add("ticket", (Object)this.ticket).add("did", (Object)this.did).add("bridgeAccount", (Object)this.bridgeAccount).add("bridge", (Object)this.bridge).add("ledgerObjectClass", this.ledgerObjectClass).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends LedgerObject> ImmutableLedgerEntryRequestParams<T> fromJson(Json<T> json) {
        Builder builder = ImmutableLedgerEntryRequestParams.builder();
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        if (json.accountRoot != null) {
            builder.accountRoot(json.accountRoot);
        }
        if (json.amm != null) {
            builder.amm(json.amm);
        }
        if (json.offer != null) {
            builder.offer(json.offer);
        }
        if (json.rippleState != null) {
            builder.rippleState(json.rippleState);
        }
        if (json.check != null) {
            builder.check(json.check);
        }
        if (json.escrow != null) {
            builder.escrow(json.escrow);
        }
        if (json.paymentChannel != null) {
            builder.paymentChannel(json.paymentChannel);
        }
        if (json.nftPage != null) {
            builder.nftPage(json.nftPage);
        }
        if (json.depositPreAuth != null) {
            builder.depositPreAuth(json.depositPreAuth);
        }
        if (json.ticket != null) {
            builder.ticket(json.ticket);
        }
        if (json.did != null) {
            builder.did(json.did);
        }
        if (json.bridgeAccount != null) {
            builder.bridgeAccount(json.bridgeAccount);
        }
        if (json.bridge != null) {
            builder.bridge(json.bridge);
        }
        if (json.ledgerObjectClass != null) {
            builder.ledgerObjectClass(json.ledgerObjectClass);
        }
        return builder.build();
    }

    public static <T extends LedgerObject> ImmutableLedgerEntryRequestParams<T> copyOf(LedgerEntryRequestParams<T> instance) {
        if (instance instanceof ImmutableLedgerEntryRequestParams) {
            return (ImmutableLedgerEntryRequestParams)instance;
        }
        return ImmutableLedgerEntryRequestParams.builder().from(instance).build();
    }

    public static <T extends LedgerObject> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="LedgerEntryRequestParams", generator="Immutables")
    @NotThreadSafe
    static final class Builder<T extends LedgerObject> {
        private static final long INIT_BIT_LEDGER_SPECIFIER = 1L;
        private long initBits = 1L;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;
        @Nullable
        private Hash256 index;
        @Nullable
        private Address accountRoot;
        @Nullable
        private AmmLedgerEntryParams amm;
        @Nullable
        private OfferLedgerEntryParams offer;
        @Nullable
        private RippleStateLedgerEntryParams rippleState;
        @Nullable
        private Hash256 check;
        @Nullable
        private EscrowLedgerEntryParams escrow;
        @Nullable
        private Hash256 paymentChannel;
        @Nullable
        private Hash256 nftPage;
        @Nullable
        private DepositPreAuthLedgerEntryParams depositPreAuth;
        @Nullable
        private TicketLedgerEntryParams ticket;
        @Nullable
        private Address did;
        @Nullable
        private Address bridgeAccount;
        @Nullable
        private XChainBridge bridge;
        @Nullable
        private Class<T> ledgerObjectClass;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(LedgerEntryRequestParams<T> instance) {
            Optional<XChainBridge> bridgeOptional;
            Optional<Address> bridgeAccountOptional;
            Optional<Address> didOptional;
            Optional<TicketLedgerEntryParams> ticketOptional;
            Optional<DepositPreAuthLedgerEntryParams> depositPreAuthOptional;
            Optional<Hash256> nftPageOptional;
            Optional<Hash256> paymentChannelOptional;
            Optional<EscrowLedgerEntryParams> escrowOptional;
            Optional<Hash256> checkOptional;
            Optional<RippleStateLedgerEntryParams> rippleStateOptional;
            Optional<OfferLedgerEntryParams> offerOptional;
            Optional<AmmLedgerEntryParams> ammOptional;
            Optional<Address> accountRootOptional;
            Objects.requireNonNull(instance, "instance");
            this.ledgerSpecifier(instance.ledgerSpecifier());
            Optional<Hash256> indexOptional = instance.index();
            if (indexOptional.isPresent()) {
                this.index(indexOptional);
            }
            if ((accountRootOptional = instance.accountRoot()).isPresent()) {
                this.accountRoot(accountRootOptional);
            }
            if ((ammOptional = instance.amm()).isPresent()) {
                this.amm(ammOptional);
            }
            if ((offerOptional = instance.offer()).isPresent()) {
                this.offer(offerOptional);
            }
            if ((rippleStateOptional = instance.rippleState()).isPresent()) {
                this.rippleState(rippleStateOptional);
            }
            if ((checkOptional = instance.check()).isPresent()) {
                this.check(checkOptional);
            }
            if ((escrowOptional = instance.escrow()).isPresent()) {
                this.escrow(escrowOptional);
            }
            if ((paymentChannelOptional = instance.paymentChannel()).isPresent()) {
                this.paymentChannel(paymentChannelOptional);
            }
            if ((nftPageOptional = instance.nftPage()).isPresent()) {
                this.nftPage(nftPageOptional);
            }
            if ((depositPreAuthOptional = instance.depositPreAuth()).isPresent()) {
                this.depositPreAuth(depositPreAuthOptional);
            }
            if ((ticketOptional = instance.ticket()).isPresent()) {
                this.ticket(ticketOptional);
            }
            if ((didOptional = instance.did()).isPresent()) {
                this.did(didOptional);
            }
            if ((bridgeAccountOptional = instance.bridgeAccount()).isPresent()) {
                this.bridgeAccount(bridgeAccountOptional);
            }
            if ((bridgeOptional = instance.bridge()).isPresent()) {
                this.bridge(bridgeOptional);
            }
            this.ledgerObjectClass(instance.ledgerObjectClass());
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder<T> ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder<T> index(Optional<? extends Hash256> index) {
            this.index = index.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> accountRoot(Address accountRoot) {
            this.accountRoot = Objects.requireNonNull(accountRoot, "accountRoot");
            return this;
        }

        @JsonProperty(value="account_root")
        @CanIgnoreReturnValue
        public final Builder<T> accountRoot(Optional<? extends Address> accountRoot) {
            this.accountRoot = accountRoot.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> amm(AmmLedgerEntryParams amm) {
            this.amm = Objects.requireNonNull(amm, "amm");
            return this;
        }

        @JsonProperty(value="amm")
        @CanIgnoreReturnValue
        public final Builder<T> amm(Optional<? extends AmmLedgerEntryParams> amm) {
            this.amm = amm.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> offer(OfferLedgerEntryParams offer) {
            this.offer = Objects.requireNonNull(offer, "offer");
            return this;
        }

        @JsonProperty(value="offer")
        @CanIgnoreReturnValue
        public final Builder<T> offer(Optional<? extends OfferLedgerEntryParams> offer) {
            this.offer = offer.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> rippleState(RippleStateLedgerEntryParams rippleState) {
            this.rippleState = Objects.requireNonNull(rippleState, "rippleState");
            return this;
        }

        @JsonProperty(value="ripple_state")
        @CanIgnoreReturnValue
        public final Builder<T> rippleState(Optional<? extends RippleStateLedgerEntryParams> rippleState) {
            this.rippleState = rippleState.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> check(Hash256 check) {
            this.check = Objects.requireNonNull(check, "check");
            return this;
        }

        @JsonProperty(value="check")
        @CanIgnoreReturnValue
        public final Builder<T> check(Optional<? extends Hash256> check) {
            this.check = check.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> escrow(EscrowLedgerEntryParams escrow) {
            this.escrow = Objects.requireNonNull(escrow, "escrow");
            return this;
        }

        @JsonProperty(value="escrow")
        @CanIgnoreReturnValue
        public final Builder<T> escrow(Optional<? extends EscrowLedgerEntryParams> escrow) {
            this.escrow = escrow.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> paymentChannel(Hash256 paymentChannel) {
            this.paymentChannel = Objects.requireNonNull(paymentChannel, "paymentChannel");
            return this;
        }

        @JsonProperty(value="payment_channel")
        @CanIgnoreReturnValue
        public final Builder<T> paymentChannel(Optional<? extends Hash256> paymentChannel) {
            this.paymentChannel = paymentChannel.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> nftPage(Hash256 nftPage) {
            this.nftPage = Objects.requireNonNull(nftPage, "nftPage");
            return this;
        }

        @JsonProperty(value="nft_page")
        @CanIgnoreReturnValue
        public final Builder<T> nftPage(Optional<? extends Hash256> nftPage) {
            this.nftPage = nftPage.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> depositPreAuth(DepositPreAuthLedgerEntryParams depositPreAuth) {
            this.depositPreAuth = Objects.requireNonNull(depositPreAuth, "depositPreAuth");
            return this;
        }

        @JsonProperty(value="deposit_preauth")
        @CanIgnoreReturnValue
        public final Builder<T> depositPreAuth(Optional<? extends DepositPreAuthLedgerEntryParams> depositPreAuth) {
            this.depositPreAuth = depositPreAuth.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> ticket(TicketLedgerEntryParams ticket) {
            this.ticket = Objects.requireNonNull(ticket, "ticket");
            return this;
        }

        @JsonProperty(value="ticket")
        @CanIgnoreReturnValue
        public final Builder<T> ticket(Optional<? extends TicketLedgerEntryParams> ticket) {
            this.ticket = ticket.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> did(Address did) {
            this.did = Objects.requireNonNull(did, "did");
            return this;
        }

        @JsonProperty(value="did")
        @CanIgnoreReturnValue
        public final Builder<T> did(Optional<? extends Address> did) {
            this.did = did.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> bridgeAccount(Address bridgeAccount) {
            this.bridgeAccount = Objects.requireNonNull(bridgeAccount, "bridgeAccount");
            return this;
        }

        @JsonProperty(value="bridge_account")
        @CanIgnoreReturnValue
        public final Builder<T> bridgeAccount(Optional<? extends Address> bridgeAccount) {
            this.bridgeAccount = bridgeAccount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> bridge(XChainBridge bridge) {
            this.bridge = Objects.requireNonNull(bridge, "bridge");
            return this;
        }

        @JsonProperty(value="bridge")
        @CanIgnoreReturnValue
        public final Builder<T> bridge(Optional<? extends XChainBridge> bridge) {
            this.bridge = bridge.orElse(null);
            return this;
        }

        @JsonProperty(value="ledgerObjectClass")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder<T> ledgerObjectClass(Class<T> ledgerObjectClass) {
            this.ledgerObjectClass = Objects.requireNonNull(ledgerObjectClass, "ledgerObjectClass");
            return this;
        }

        public ImmutableLedgerEntryRequestParams<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLedgerEntryRequestParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ledgerSpecifier");
            }
            return "Cannot build LedgerEntryRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="LedgerEntryRequestParams", generator="Immutables")
    private final class InitShim {
        private byte binaryBuildStage = 0;
        private boolean binary;
        private byte ledgerObjectClassBuildStage = 0;
        private Class<T> ledgerObjectClass;

        private InitShim() {
        }

        boolean binary() {
            if (this.binaryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.binaryBuildStage == 0) {
                this.binaryBuildStage = (byte)-1;
                this.binary = ImmutableLedgerEntryRequestParams.this.binaryInitialize();
                this.binaryBuildStage = 1;
            }
            return this.binary;
        }

        Class<T> ledgerObjectClass() {
            if (this.ledgerObjectClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerObjectClassBuildStage == 0) {
                this.ledgerObjectClassBuildStage = (byte)-1;
                this.ledgerObjectClass = Objects.requireNonNull(ImmutableLedgerEntryRequestParams.this.ledgerObjectClassInitialize(), "ledgerObjectClass");
                this.ledgerObjectClassBuildStage = 1;
            }
            return this.ledgerObjectClass;
        }

        void ledgerObjectClass(Class<T> ledgerObjectClass) {
            this.ledgerObjectClass = ledgerObjectClass;
            this.ledgerObjectClassBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.binaryBuildStage == -1) {
                attributes.add("binary");
            }
            if (this.ledgerObjectClassBuildStage == -1) {
                attributes.add("ledgerObjectClass");
            }
            return "Cannot build LedgerEntryRequestParams, attribute initializers form cycle " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LedgerEntryRequestParams", generator="Immutables")
    static final class Json<T extends LedgerObject>
    implements LedgerEntryRequestParams<T> {
        @Nullable
        LedgerSpecifier ledgerSpecifier;
        @Nullable
        Optional<Hash256> index = Optional.empty();
        @Nullable
        Optional<Address> accountRoot = Optional.empty();
        @Nullable
        Optional<AmmLedgerEntryParams> amm = Optional.empty();
        @Nullable
        Optional<OfferLedgerEntryParams> offer = Optional.empty();
        @Nullable
        Optional<RippleStateLedgerEntryParams> rippleState = Optional.empty();
        @Nullable
        Optional<Hash256> check = Optional.empty();
        @Nullable
        Optional<EscrowLedgerEntryParams> escrow = Optional.empty();
        @Nullable
        Optional<Hash256> paymentChannel = Optional.empty();
        @Nullable
        Optional<Hash256> nftPage = Optional.empty();
        @Nullable
        Optional<DepositPreAuthLedgerEntryParams> depositPreAuth = Optional.empty();
        @Nullable
        Optional<TicketLedgerEntryParams> ticket = Optional.empty();
        @Nullable
        Optional<Address> did = Optional.empty();
        @Nullable
        Optional<Address> bridgeAccount = Optional.empty();
        @Nullable
        Optional<XChainBridge> bridge = Optional.empty();
        @Nullable
        Class<T> ledgerObjectClass;

        Json() {
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @JsonProperty(value="index")
        public void setIndex(Optional<Hash256> index) {
            this.index = index;
        }

        @JsonProperty(value="account_root")
        public void setAccountRoot(Optional<Address> accountRoot) {
            this.accountRoot = accountRoot;
        }

        @JsonProperty(value="amm")
        public void setAmm(Optional<AmmLedgerEntryParams> amm) {
            this.amm = amm;
        }

        @JsonProperty(value="offer")
        public void setOffer(Optional<OfferLedgerEntryParams> offer) {
            this.offer = offer;
        }

        @JsonProperty(value="ripple_state")
        public void setRippleState(Optional<RippleStateLedgerEntryParams> rippleState) {
            this.rippleState = rippleState;
        }

        @JsonProperty(value="check")
        public void setCheck(Optional<Hash256> check) {
            this.check = check;
        }

        @JsonProperty(value="escrow")
        public void setEscrow(Optional<EscrowLedgerEntryParams> escrow) {
            this.escrow = escrow;
        }

        @JsonProperty(value="payment_channel")
        public void setPaymentChannel(Optional<Hash256> paymentChannel) {
            this.paymentChannel = paymentChannel;
        }

        @JsonProperty(value="nft_page")
        public void setNftPage(Optional<Hash256> nftPage) {
            this.nftPage = nftPage;
        }

        @JsonProperty(value="deposit_preauth")
        public void setDepositPreAuth(Optional<DepositPreAuthLedgerEntryParams> depositPreAuth) {
            this.depositPreAuth = depositPreAuth;
        }

        @JsonProperty(value="ticket")
        public void setTicket(Optional<TicketLedgerEntryParams> ticket) {
            this.ticket = ticket;
        }

        @JsonProperty(value="did")
        public void setDid(Optional<Address> did) {
            this.did = did;
        }

        @JsonProperty(value="bridge_account")
        public void setBridgeAccount(Optional<Address> bridgeAccount) {
            this.bridgeAccount = bridgeAccount;
        }

        @JsonProperty(value="bridge")
        public void setBridge(Optional<XChainBridge> bridge) {
            this.bridge = bridge;
        }

        @JsonProperty(value="ledgerObjectClass")
        @JsonIgnore
        public void setLedgerObjectClass(Class<T> ledgerObjectClass) {
            this.ledgerObjectClass = ledgerObjectClass;
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean binary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> index() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> accountRoot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<AmmLedgerEntryParams> amm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<OfferLedgerEntryParams> offer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<RippleStateLedgerEntryParams> rippleState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> check() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<EscrowLedgerEntryParams> escrow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> paymentChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> nftPage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DepositPreAuthLedgerEntryParams> depositPreAuth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TicketLedgerEntryParams> ticket() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> did() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> bridgeAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XChainBridge> bridge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<T> ledgerObjectClass() {
            throw new UnsupportedOperationException();
        }
    }
}

