/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.ledger.EscrowLedgerEntryParams;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EscrowLedgerEntryParams", generator="Immutables")
@Immutable
public final class ImmutableEscrowLedgerEntryParams
implements EscrowLedgerEntryParams {
    private final Address owner;
    private final UnsignedInteger seq;

    private ImmutableEscrowLedgerEntryParams(Address owner, UnsignedInteger seq) {
        this.owner = owner;
        this.seq = seq;
    }

    @Override
    @JsonProperty(value="owner")
    public Address owner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="seq")
    public UnsignedInteger seq() {
        return this.seq;
    }

    public final ImmutableEscrowLedgerEntryParams withOwner(Address value) {
        if (this.owner == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "owner");
        return new ImmutableEscrowLedgerEntryParams(newValue, this.seq);
    }

    public final ImmutableEscrowLedgerEntryParams withSeq(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "seq");
        if (this.seq.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEscrowLedgerEntryParams(this.owner, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEscrowLedgerEntryParams && this.equalTo(0, (ImmutableEscrowLedgerEntryParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableEscrowLedgerEntryParams another) {
        return this.owner.equals(another.owner) && this.seq.equals((Object)another.seq);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.owner.hashCode();
        h += (h << 5) + this.seq.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EscrowLedgerEntryParams").omitNullValues().add("owner", (Object)this.owner).add("seq", (Object)this.seq).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEscrowLedgerEntryParams fromJson(Json json) {
        Builder builder = ImmutableEscrowLedgerEntryParams.builder();
        if (json.owner != null) {
            builder.owner(json.owner);
        }
        if (json.seq != null) {
            builder.seq(json.seq);
        }
        return builder.build();
    }

    public static ImmutableEscrowLedgerEntryParams copyOf(EscrowLedgerEntryParams instance) {
        if (instance instanceof ImmutableEscrowLedgerEntryParams) {
            return (ImmutableEscrowLedgerEntryParams)instance;
        }
        return ImmutableEscrowLedgerEntryParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EscrowLedgerEntryParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OWNER = 1L;
        private static final long INIT_BIT_SEQ = 2L;
        private long initBits = 3L;
        @Nullable
        private Address owner;
        @Nullable
        private UnsignedInteger seq;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EscrowLedgerEntryParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.owner(instance.owner());
            this.seq(instance.seq());
            return this;
        }

        @JsonProperty(value="owner")
        @CanIgnoreReturnValue
        public final Builder owner(Address owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="seq")
        @CanIgnoreReturnValue
        public final Builder seq(UnsignedInteger seq) {
            this.seq = Objects.requireNonNull(seq, "seq");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEscrowLedgerEntryParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEscrowLedgerEntryParams(this.owner, this.seq);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("owner");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("seq");
            }
            return "Cannot build EscrowLedgerEntryParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EscrowLedgerEntryParams", generator="Immutables")
    static final class Json
    implements EscrowLedgerEntryParams {
        @Nullable
        Address owner;
        @Nullable
        UnsignedInteger seq;

        Json() {
        }

        @JsonProperty(value="owner")
        public void setOwner(Address owner) {
            this.owner = owner;
        }

        @JsonProperty(value="seq")
        public void setSeq(UnsignedInteger seq) {
            this.seq = seq;
        }

        @Override
        public Address owner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger seq() {
            throw new UnsupportedOperationException();
        }
    }
}

