/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.ledger.DepositPreAuthLedgerEntryParams;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DepositPreAuthLedgerEntryParams", generator="Immutables")
@Immutable
public final class ImmutableDepositPreAuthLedgerEntryParams
implements DepositPreAuthLedgerEntryParams {
    private final Address owner;
    private final Address authorized;

    private ImmutableDepositPreAuthLedgerEntryParams(Address owner, Address authorized) {
        this.owner = owner;
        this.authorized = authorized;
    }

    @Override
    @JsonProperty(value="owner")
    public Address owner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="authorized")
    public Address authorized() {
        return this.authorized;
    }

    public final ImmutableDepositPreAuthLedgerEntryParams withOwner(Address value) {
        if (this.owner == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "owner");
        return new ImmutableDepositPreAuthLedgerEntryParams(newValue, this.authorized);
    }

    public final ImmutableDepositPreAuthLedgerEntryParams withAuthorized(Address value) {
        if (this.authorized == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "authorized");
        return new ImmutableDepositPreAuthLedgerEntryParams(this.owner, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDepositPreAuthLedgerEntryParams && this.equalTo(0, (ImmutableDepositPreAuthLedgerEntryParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableDepositPreAuthLedgerEntryParams another) {
        return this.owner.equals(another.owner) && this.authorized.equals(another.authorized);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.owner.hashCode();
        h += (h << 5) + this.authorized.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DepositPreAuthLedgerEntryParams").omitNullValues().add("owner", (Object)this.owner).add("authorized", (Object)this.authorized).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDepositPreAuthLedgerEntryParams fromJson(Json json) {
        Builder builder = ImmutableDepositPreAuthLedgerEntryParams.builder();
        if (json.owner != null) {
            builder.owner(json.owner);
        }
        if (json.authorized != null) {
            builder.authorized(json.authorized);
        }
        return builder.build();
    }

    public static ImmutableDepositPreAuthLedgerEntryParams copyOf(DepositPreAuthLedgerEntryParams instance) {
        if (instance instanceof ImmutableDepositPreAuthLedgerEntryParams) {
            return (ImmutableDepositPreAuthLedgerEntryParams)instance;
        }
        return ImmutableDepositPreAuthLedgerEntryParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DepositPreAuthLedgerEntryParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OWNER = 1L;
        private static final long INIT_BIT_AUTHORIZED = 2L;
        private long initBits = 3L;
        @Nullable
        private Address owner;
        @Nullable
        private Address authorized;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DepositPreAuthLedgerEntryParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.owner(instance.owner());
            this.authorized(instance.authorized());
            return this;
        }

        @JsonProperty(value="owner")
        @CanIgnoreReturnValue
        public final Builder owner(Address owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="authorized")
        @CanIgnoreReturnValue
        public final Builder authorized(Address authorized) {
            this.authorized = Objects.requireNonNull(authorized, "authorized");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDepositPreAuthLedgerEntryParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDepositPreAuthLedgerEntryParams(this.owner, this.authorized);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("owner");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("authorized");
            }
            return "Cannot build DepositPreAuthLedgerEntryParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DepositPreAuthLedgerEntryParams", generator="Immutables")
    static final class Json
    implements DepositPreAuthLedgerEntryParams {
        @Nullable
        Address owner;
        @Nullable
        Address authorized;

        Json() {
        }

        @JsonProperty(value="owner")
        public void setOwner(Address owner) {
            this.owner = owner;
        }

        @JsonProperty(value="authorized")
        public void setAuthorized(Address authorized) {
            this.authorized = authorized;
        }

        @Override
        public Address owner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address authorized() {
            throw new UnsupportedOperationException();
        }
    }
}

