/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.fees;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.fees.FeeLevels;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeeLevels", generator="Immutables")
@Immutable
public final class ImmutableFeeLevels
implements FeeLevels {
    private final XrpCurrencyAmount medianLevel;
    private final XrpCurrencyAmount minimumLevel;
    private final XrpCurrencyAmount openLedgerLevel;
    private final XrpCurrencyAmount referenceLevel;

    private ImmutableFeeLevels(XrpCurrencyAmount medianLevel, XrpCurrencyAmount minimumLevel, XrpCurrencyAmount openLedgerLevel, XrpCurrencyAmount referenceLevel) {
        this.medianLevel = medianLevel;
        this.minimumLevel = minimumLevel;
        this.openLedgerLevel = openLedgerLevel;
        this.referenceLevel = referenceLevel;
    }

    @Override
    @JsonProperty(value="median_level")
    public XrpCurrencyAmount medianLevel() {
        return this.medianLevel;
    }

    @Override
    @JsonProperty(value="minimum_level")
    public XrpCurrencyAmount minimumLevel() {
        return this.minimumLevel;
    }

    @Override
    @JsonProperty(value="open_ledger_level")
    public XrpCurrencyAmount openLedgerLevel() {
        return this.openLedgerLevel;
    }

    @Override
    @JsonProperty(value="reference_level")
    public XrpCurrencyAmount referenceLevel() {
        return this.referenceLevel;
    }

    public final ImmutableFeeLevels withMedianLevel(XrpCurrencyAmount value) {
        if (this.medianLevel == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "medianLevel");
        return new ImmutableFeeLevels(newValue, this.minimumLevel, this.openLedgerLevel, this.referenceLevel);
    }

    public final ImmutableFeeLevels withMinimumLevel(XrpCurrencyAmount value) {
        if (this.minimumLevel == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "minimumLevel");
        return new ImmutableFeeLevels(this.medianLevel, newValue, this.openLedgerLevel, this.referenceLevel);
    }

    public final ImmutableFeeLevels withOpenLedgerLevel(XrpCurrencyAmount value) {
        if (this.openLedgerLevel == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "openLedgerLevel");
        return new ImmutableFeeLevels(this.medianLevel, this.minimumLevel, newValue, this.referenceLevel);
    }

    public final ImmutableFeeLevels withReferenceLevel(XrpCurrencyAmount value) {
        if (this.referenceLevel == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "referenceLevel");
        return new ImmutableFeeLevels(this.medianLevel, this.minimumLevel, this.openLedgerLevel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeeLevels && this.equalTo(0, (ImmutableFeeLevels)another);
    }

    private boolean equalTo(int synthetic, ImmutableFeeLevels another) {
        return this.medianLevel.equals(another.medianLevel) && this.minimumLevel.equals(another.minimumLevel) && this.openLedgerLevel.equals(another.openLedgerLevel) && this.referenceLevel.equals(another.referenceLevel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.medianLevel.hashCode();
        h += (h << 5) + this.minimumLevel.hashCode();
        h += (h << 5) + this.openLedgerLevel.hashCode();
        h += (h << 5) + this.referenceLevel.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FeeLevels").omitNullValues().add("medianLevel", (Object)this.medianLevel).add("minimumLevel", (Object)this.minimumLevel).add("openLedgerLevel", (Object)this.openLedgerLevel).add("referenceLevel", (Object)this.referenceLevel).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFeeLevels fromJson(Json json) {
        Builder builder = ImmutableFeeLevels.builder();
        if (json.medianLevel != null) {
            builder.medianLevel(json.medianLevel);
        }
        if (json.minimumLevel != null) {
            builder.minimumLevel(json.minimumLevel);
        }
        if (json.openLedgerLevel != null) {
            builder.openLedgerLevel(json.openLedgerLevel);
        }
        if (json.referenceLevel != null) {
            builder.referenceLevel(json.referenceLevel);
        }
        return builder.build();
    }

    public static ImmutableFeeLevels copyOf(FeeLevels instance) {
        if (instance instanceof ImmutableFeeLevels) {
            return (ImmutableFeeLevels)instance;
        }
        return ImmutableFeeLevels.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeeLevels", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MEDIAN_LEVEL = 1L;
        private static final long INIT_BIT_MINIMUM_LEVEL = 2L;
        private static final long INIT_BIT_OPEN_LEDGER_LEVEL = 4L;
        private static final long INIT_BIT_REFERENCE_LEVEL = 8L;
        private long initBits = 15L;
        @Nullable
        private XrpCurrencyAmount medianLevel;
        @Nullable
        private XrpCurrencyAmount minimumLevel;
        @Nullable
        private XrpCurrencyAmount openLedgerLevel;
        @Nullable
        private XrpCurrencyAmount referenceLevel;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeeLevels instance) {
            Objects.requireNonNull(instance, "instance");
            this.medianLevel(instance.medianLevel());
            this.minimumLevel(instance.minimumLevel());
            this.openLedgerLevel(instance.openLedgerLevel());
            this.referenceLevel(instance.referenceLevel());
            return this;
        }

        @JsonProperty(value="median_level")
        @CanIgnoreReturnValue
        public final Builder medianLevel(XrpCurrencyAmount medianLevel) {
            this.medianLevel = Objects.requireNonNull(medianLevel, "medianLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="minimum_level")
        @CanIgnoreReturnValue
        public final Builder minimumLevel(XrpCurrencyAmount minimumLevel) {
            this.minimumLevel = Objects.requireNonNull(minimumLevel, "minimumLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="open_ledger_level")
        @CanIgnoreReturnValue
        public final Builder openLedgerLevel(XrpCurrencyAmount openLedgerLevel) {
            this.openLedgerLevel = Objects.requireNonNull(openLedgerLevel, "openLedgerLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="reference_level")
        @CanIgnoreReturnValue
        public final Builder referenceLevel(XrpCurrencyAmount referenceLevel) {
            this.referenceLevel = Objects.requireNonNull(referenceLevel, "referenceLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableFeeLevels build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeeLevels(this.medianLevel, this.minimumLevel, this.openLedgerLevel, this.referenceLevel);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("medianLevel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minimumLevel");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("openLedgerLevel");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("referenceLevel");
            }
            return "Cannot build FeeLevels, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FeeLevels", generator="Immutables")
    static final class Json
    implements FeeLevels {
        @Nullable
        XrpCurrencyAmount medianLevel;
        @Nullable
        XrpCurrencyAmount minimumLevel;
        @Nullable
        XrpCurrencyAmount openLedgerLevel;
        @Nullable
        XrpCurrencyAmount referenceLevel;

        Json() {
        }

        @JsonProperty(value="median_level")
        public void setMedianLevel(XrpCurrencyAmount medianLevel) {
            this.medianLevel = medianLevel;
        }

        @JsonProperty(value="minimum_level")
        public void setMinimumLevel(XrpCurrencyAmount minimumLevel) {
            this.minimumLevel = minimumLevel;
        }

        @JsonProperty(value="open_ledger_level")
        public void setOpenLedgerLevel(XrpCurrencyAmount openLedgerLevel) {
            this.openLedgerLevel = openLedgerLevel;
        }

        @JsonProperty(value="reference_level")
        public void setReferenceLevel(XrpCurrencyAmount referenceLevel) {
            this.referenceLevel = referenceLevel;
        }

        @Override
        public XrpCurrencyAmount medianLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount minimumLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount openLedgerLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount referenceLevel() {
            throw new UnsupportedOperationException();
        }
    }
}

