/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.fees;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.fees.FeeUtils;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeeUtils.DecomposedFees", generator="Immutables")
@Immutable
public final class ImmutableDecomposedFees
implements FeeUtils.DecomposedFees {
    private final BigInteger adjustedMinimumFeeDrops;
    private final transient BigDecimal adjustedMinimumFeeDropsAsBigDecimal;
    private final BigInteger medianFeeDrops;
    private final transient BigDecimal medianFeeDropsAsBigDecimal;
    private final BigInteger openLedgerFeeDrops;
    private final transient BigDecimal openLedgerFeeDropsAsBigDecimal;
    private final BigDecimal queuePercentage;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDecomposedFees(BigInteger adjustedMinimumFeeDrops, BigInteger medianFeeDrops, BigInteger openLedgerFeeDrops, BigDecimal queuePercentage) {
        this.adjustedMinimumFeeDrops = adjustedMinimumFeeDrops;
        this.medianFeeDrops = medianFeeDrops;
        this.openLedgerFeeDrops = openLedgerFeeDrops;
        this.queuePercentage = queuePercentage;
        this.adjustedMinimumFeeDropsAsBigDecimal = this.initShim.adjustedMinimumFeeDropsAsBigDecimal();
        this.medianFeeDropsAsBigDecimal = this.initShim.medianFeeDropsAsBigDecimal();
        this.openLedgerFeeDropsAsBigDecimal = this.initShim.openLedgerFeeDropsAsBigDecimal();
        this.initShim = null;
    }

    private BigDecimal adjustedMinimumFeeDropsAsBigDecimalInitialize() {
        return FeeUtils.DecomposedFees.super.adjustedMinimumFeeDropsAsBigDecimal();
    }

    private BigDecimal medianFeeDropsAsBigDecimalInitialize() {
        return FeeUtils.DecomposedFees.super.medianFeeDropsAsBigDecimal();
    }

    private BigDecimal openLedgerFeeDropsAsBigDecimalInitialize() {
        return FeeUtils.DecomposedFees.super.openLedgerFeeDropsAsBigDecimal();
    }

    @Override
    public BigInteger adjustedMinimumFeeDrops() {
        return this.adjustedMinimumFeeDrops;
    }

    @Override
    public BigDecimal adjustedMinimumFeeDropsAsBigDecimal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.adjustedMinimumFeeDropsAsBigDecimal() : this.adjustedMinimumFeeDropsAsBigDecimal;
    }

    @Override
    public BigInteger medianFeeDrops() {
        return this.medianFeeDrops;
    }

    @Override
    public BigDecimal medianFeeDropsAsBigDecimal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.medianFeeDropsAsBigDecimal() : this.medianFeeDropsAsBigDecimal;
    }

    @Override
    public BigInteger openLedgerFeeDrops() {
        return this.openLedgerFeeDrops;
    }

    @Override
    public BigDecimal openLedgerFeeDropsAsBigDecimal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.openLedgerFeeDropsAsBigDecimal() : this.openLedgerFeeDropsAsBigDecimal;
    }

    @Override
    public BigDecimal queuePercentage() {
        return this.queuePercentage;
    }

    public final ImmutableDecomposedFees withAdjustedMinimumFeeDrops(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "adjustedMinimumFeeDrops");
        if (this.adjustedMinimumFeeDrops.equals(newValue)) {
            return this;
        }
        return new ImmutableDecomposedFees(newValue, this.medianFeeDrops, this.openLedgerFeeDrops, this.queuePercentage);
    }

    public final ImmutableDecomposedFees withMedianFeeDrops(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "medianFeeDrops");
        if (this.medianFeeDrops.equals(newValue)) {
            return this;
        }
        return new ImmutableDecomposedFees(this.adjustedMinimumFeeDrops, newValue, this.openLedgerFeeDrops, this.queuePercentage);
    }

    public final ImmutableDecomposedFees withOpenLedgerFeeDrops(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "openLedgerFeeDrops");
        if (this.openLedgerFeeDrops.equals(newValue)) {
            return this;
        }
        return new ImmutableDecomposedFees(this.adjustedMinimumFeeDrops, this.medianFeeDrops, newValue, this.queuePercentage);
    }

    public final ImmutableDecomposedFees withQueuePercentage(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "queuePercentage");
        if (this.queuePercentage.equals(newValue)) {
            return this;
        }
        return new ImmutableDecomposedFees(this.adjustedMinimumFeeDrops, this.medianFeeDrops, this.openLedgerFeeDrops, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDecomposedFees && this.equalTo(0, (ImmutableDecomposedFees)another);
    }

    private boolean equalTo(int synthetic, ImmutableDecomposedFees another) {
        return this.adjustedMinimumFeeDrops.equals(another.adjustedMinimumFeeDrops) && this.adjustedMinimumFeeDropsAsBigDecimal.equals(another.adjustedMinimumFeeDropsAsBigDecimal) && this.medianFeeDrops.equals(another.medianFeeDrops) && this.medianFeeDropsAsBigDecimal.equals(another.medianFeeDropsAsBigDecimal) && this.openLedgerFeeDrops.equals(another.openLedgerFeeDrops) && this.openLedgerFeeDropsAsBigDecimal.equals(another.openLedgerFeeDropsAsBigDecimal) && this.queuePercentage.equals(another.queuePercentage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.adjustedMinimumFeeDrops.hashCode();
        h += (h << 5) + this.adjustedMinimumFeeDropsAsBigDecimal.hashCode();
        h += (h << 5) + this.medianFeeDrops.hashCode();
        h += (h << 5) + this.medianFeeDropsAsBigDecimal.hashCode();
        h += (h << 5) + this.openLedgerFeeDrops.hashCode();
        h += (h << 5) + this.openLedgerFeeDropsAsBigDecimal.hashCode();
        h += (h << 5) + this.queuePercentage.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DecomposedFees").omitNullValues().add("adjustedMinimumFeeDrops", (Object)this.adjustedMinimumFeeDrops).add("adjustedMinimumFeeDropsAsBigDecimal", (Object)this.adjustedMinimumFeeDropsAsBigDecimal).add("medianFeeDrops", (Object)this.medianFeeDrops).add("medianFeeDropsAsBigDecimal", (Object)this.medianFeeDropsAsBigDecimal).add("openLedgerFeeDrops", (Object)this.openLedgerFeeDrops).add("openLedgerFeeDropsAsBigDecimal", (Object)this.openLedgerFeeDropsAsBigDecimal).add("queuePercentage", (Object)this.queuePercentage).toString();
    }

    public static ImmutableDecomposedFees copyOf(FeeUtils.DecomposedFees instance) {
        if (instance instanceof ImmutableDecomposedFees) {
            return (ImmutableDecomposedFees)instance;
        }
        return ImmutableDecomposedFees.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeeUtils.DecomposedFees", generator="Immutables")
    private final class InitShim {
        private byte adjustedMinimumFeeDropsAsBigDecimalBuildStage = 0;
        private BigDecimal adjustedMinimumFeeDropsAsBigDecimal;
        private byte medianFeeDropsAsBigDecimalBuildStage = 0;
        private BigDecimal medianFeeDropsAsBigDecimal;
        private byte openLedgerFeeDropsAsBigDecimalBuildStage = 0;
        private BigDecimal openLedgerFeeDropsAsBigDecimal;

        private InitShim() {
        }

        BigDecimal adjustedMinimumFeeDropsAsBigDecimal() {
            if (this.adjustedMinimumFeeDropsAsBigDecimalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.adjustedMinimumFeeDropsAsBigDecimalBuildStage == 0) {
                this.adjustedMinimumFeeDropsAsBigDecimalBuildStage = (byte)-1;
                this.adjustedMinimumFeeDropsAsBigDecimal = Objects.requireNonNull(ImmutableDecomposedFees.this.adjustedMinimumFeeDropsAsBigDecimalInitialize(), "adjustedMinimumFeeDropsAsBigDecimal");
                this.adjustedMinimumFeeDropsAsBigDecimalBuildStage = 1;
            }
            return this.adjustedMinimumFeeDropsAsBigDecimal;
        }

        BigDecimal medianFeeDropsAsBigDecimal() {
            if (this.medianFeeDropsAsBigDecimalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.medianFeeDropsAsBigDecimalBuildStage == 0) {
                this.medianFeeDropsAsBigDecimalBuildStage = (byte)-1;
                this.medianFeeDropsAsBigDecimal = Objects.requireNonNull(ImmutableDecomposedFees.this.medianFeeDropsAsBigDecimalInitialize(), "medianFeeDropsAsBigDecimal");
                this.medianFeeDropsAsBigDecimalBuildStage = 1;
            }
            return this.medianFeeDropsAsBigDecimal;
        }

        BigDecimal openLedgerFeeDropsAsBigDecimal() {
            if (this.openLedgerFeeDropsAsBigDecimalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.openLedgerFeeDropsAsBigDecimalBuildStage == 0) {
                this.openLedgerFeeDropsAsBigDecimalBuildStage = (byte)-1;
                this.openLedgerFeeDropsAsBigDecimal = Objects.requireNonNull(ImmutableDecomposedFees.this.openLedgerFeeDropsAsBigDecimalInitialize(), "openLedgerFeeDropsAsBigDecimal");
                this.openLedgerFeeDropsAsBigDecimalBuildStage = 1;
            }
            return this.openLedgerFeeDropsAsBigDecimal;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.adjustedMinimumFeeDropsAsBigDecimalBuildStage == -1) {
                attributes.add("adjustedMinimumFeeDropsAsBigDecimal");
            }
            if (this.medianFeeDropsAsBigDecimalBuildStage == -1) {
                attributes.add("medianFeeDropsAsBigDecimal");
            }
            if (this.openLedgerFeeDropsAsBigDecimalBuildStage == -1) {
                attributes.add("openLedgerFeeDropsAsBigDecimal");
            }
            return "Cannot build DecomposedFees, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="FeeUtils.DecomposedFees", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ADJUSTED_MINIMUM_FEE_DROPS = 1L;
        private static final long INIT_BIT_MEDIAN_FEE_DROPS = 2L;
        private static final long INIT_BIT_OPEN_LEDGER_FEE_DROPS = 4L;
        private static final long INIT_BIT_QUEUE_PERCENTAGE = 8L;
        private long initBits = 15L;
        @Nullable
        private BigInteger adjustedMinimumFeeDrops;
        @Nullable
        private BigInteger medianFeeDrops;
        @Nullable
        private BigInteger openLedgerFeeDrops;
        @Nullable
        private BigDecimal queuePercentage;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeeUtils.DecomposedFees instance) {
            Objects.requireNonNull(instance, "instance");
            this.adjustedMinimumFeeDrops(instance.adjustedMinimumFeeDrops());
            this.medianFeeDrops(instance.medianFeeDrops());
            this.openLedgerFeeDrops(instance.openLedgerFeeDrops());
            this.queuePercentage(instance.queuePercentage());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder adjustedMinimumFeeDrops(BigInteger adjustedMinimumFeeDrops) {
            this.adjustedMinimumFeeDrops = Objects.requireNonNull(adjustedMinimumFeeDrops, "adjustedMinimumFeeDrops");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder medianFeeDrops(BigInteger medianFeeDrops) {
            this.medianFeeDrops = Objects.requireNonNull(medianFeeDrops, "medianFeeDrops");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder openLedgerFeeDrops(BigInteger openLedgerFeeDrops) {
            this.openLedgerFeeDrops = Objects.requireNonNull(openLedgerFeeDrops, "openLedgerFeeDrops");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queuePercentage(BigDecimal queuePercentage) {
            this.queuePercentage = Objects.requireNonNull(queuePercentage, "queuePercentage");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableDecomposedFees build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDecomposedFees(this.adjustedMinimumFeeDrops, this.medianFeeDrops, this.openLedgerFeeDrops, this.queuePercentage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("adjustedMinimumFeeDrops");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("medianFeeDrops");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("openLedgerFeeDrops");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("queuePercentage");
            }
            return "Cannot build DecomposedFees, some of required attributes are not set " + attributes;
        }
    }
}

