/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.fees;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.fees.ComputedNetworkFees;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ComputedNetworkFees", generator="Immutables")
@Immutable
public final class ImmutableComputedNetworkFees
implements ComputedNetworkFees {
    private final XrpCurrencyAmount feeLow;
    private final XrpCurrencyAmount feeMedium;
    private final XrpCurrencyAmount feeHigh;
    private final BigDecimal queuePercentage;
    private final transient XrpCurrencyAmount recommendedFee;
    private final transient boolean isTranactionQueueFull;
    private final transient boolean isTransactionQueueEmpty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableComputedNetworkFees(XrpCurrencyAmount feeLow, XrpCurrencyAmount feeMedium, XrpCurrencyAmount feeHigh, BigDecimal queuePercentage) {
        this.feeLow = feeLow;
        this.feeMedium = feeMedium;
        this.feeHigh = feeHigh;
        this.queuePercentage = queuePercentage;
        this.recommendedFee = this.initShim.recommendedFee();
        this.isTranactionQueueFull = this.initShim.isTranactionQueueFull();
        this.isTransactionQueueEmpty = this.initShim.isTransactionQueueEmpty();
        this.initShim = null;
    }

    private XrpCurrencyAmount recommendedFeeInitialize() {
        return ComputedNetworkFees.super.recommendedFee();
    }

    private boolean isTranactionQueueFullInitialize() {
        return ComputedNetworkFees.super.isTranactionQueueFull();
    }

    private boolean isTransactionQueueEmptyInitialize() {
        return ComputedNetworkFees.super.isTransactionQueueEmpty();
    }

    @Override
    public XrpCurrencyAmount feeLow() {
        return this.feeLow;
    }

    @Override
    public XrpCurrencyAmount feeMedium() {
        return this.feeMedium;
    }

    @Override
    public XrpCurrencyAmount feeHigh() {
        return this.feeHigh;
    }

    @Override
    public BigDecimal queuePercentage() {
        return this.queuePercentage;
    }

    @Override
    public XrpCurrencyAmount recommendedFee() {
        InitShim shim = this.initShim;
        return shim != null ? shim.recommendedFee() : this.recommendedFee;
    }

    @Override
    public boolean isTranactionQueueFull() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isTranactionQueueFull() : this.isTranactionQueueFull;
    }

    @Override
    public boolean isTransactionQueueEmpty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isTransactionQueueEmpty() : this.isTransactionQueueEmpty;
    }

    public final ImmutableComputedNetworkFees withFeeLow(XrpCurrencyAmount value) {
        if (this.feeLow == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "feeLow");
        return new ImmutableComputedNetworkFees(newValue, this.feeMedium, this.feeHigh, this.queuePercentage);
    }

    public final ImmutableComputedNetworkFees withFeeMedium(XrpCurrencyAmount value) {
        if (this.feeMedium == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "feeMedium");
        return new ImmutableComputedNetworkFees(this.feeLow, newValue, this.feeHigh, this.queuePercentage);
    }

    public final ImmutableComputedNetworkFees withFeeHigh(XrpCurrencyAmount value) {
        if (this.feeHigh == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "feeHigh");
        return new ImmutableComputedNetworkFees(this.feeLow, this.feeMedium, newValue, this.queuePercentage);
    }

    public final ImmutableComputedNetworkFees withQueuePercentage(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "queuePercentage");
        if (this.queuePercentage.equals(newValue)) {
            return this;
        }
        return new ImmutableComputedNetworkFees(this.feeLow, this.feeMedium, this.feeHigh, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComputedNetworkFees && this.equalTo(0, (ImmutableComputedNetworkFees)another);
    }

    private boolean equalTo(int synthetic, ImmutableComputedNetworkFees another) {
        return this.feeLow.equals(another.feeLow) && this.feeMedium.equals(another.feeMedium) && this.feeHigh.equals(another.feeHigh) && this.queuePercentage.equals(another.queuePercentage) && this.recommendedFee.equals(another.recommendedFee) && this.isTranactionQueueFull == another.isTranactionQueueFull && this.isTransactionQueueEmpty == another.isTransactionQueueEmpty;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.feeLow.hashCode();
        h += (h << 5) + this.feeMedium.hashCode();
        h += (h << 5) + this.feeHigh.hashCode();
        h += (h << 5) + this.queuePercentage.hashCode();
        h += (h << 5) + this.recommendedFee.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isTranactionQueueFull);
        h += (h << 5) + Booleans.hashCode((boolean)this.isTransactionQueueEmpty);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ComputedNetworkFees").omitNullValues().add("feeLow", (Object)this.feeLow).add("feeMedium", (Object)this.feeMedium).add("feeHigh", (Object)this.feeHigh).add("queuePercentage", (Object)this.queuePercentage).add("recommendedFee", (Object)this.recommendedFee).add("isTranactionQueueFull", this.isTranactionQueueFull).add("isTransactionQueueEmpty", this.isTransactionQueueEmpty).toString();
    }

    public static ImmutableComputedNetworkFees copyOf(ComputedNetworkFees instance) {
        if (instance instanceof ImmutableComputedNetworkFees) {
            return (ImmutableComputedNetworkFees)instance;
        }
        return ImmutableComputedNetworkFees.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ComputedNetworkFees", generator="Immutables")
    private final class InitShim {
        private byte recommendedFeeBuildStage = 0;
        private XrpCurrencyAmount recommendedFee;
        private byte isTranactionQueueFullBuildStage = 0;
        private boolean isTranactionQueueFull;
        private byte isTransactionQueueEmptyBuildStage = 0;
        private boolean isTransactionQueueEmpty;

        private InitShim() {
        }

        XrpCurrencyAmount recommendedFee() {
            if (this.recommendedFeeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.recommendedFeeBuildStage == 0) {
                this.recommendedFeeBuildStage = (byte)-1;
                this.recommendedFee = Objects.requireNonNull(ImmutableComputedNetworkFees.this.recommendedFeeInitialize(), "recommendedFee");
                this.recommendedFeeBuildStage = 1;
            }
            return this.recommendedFee;
        }

        boolean isTranactionQueueFull() {
            if (this.isTranactionQueueFullBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isTranactionQueueFullBuildStage == 0) {
                this.isTranactionQueueFullBuildStage = (byte)-1;
                this.isTranactionQueueFull = ImmutableComputedNetworkFees.this.isTranactionQueueFullInitialize();
                this.isTranactionQueueFullBuildStage = 1;
            }
            return this.isTranactionQueueFull;
        }

        boolean isTransactionQueueEmpty() {
            if (this.isTransactionQueueEmptyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isTransactionQueueEmptyBuildStage == 0) {
                this.isTransactionQueueEmptyBuildStage = (byte)-1;
                this.isTransactionQueueEmpty = ImmutableComputedNetworkFees.this.isTransactionQueueEmptyInitialize();
                this.isTransactionQueueEmptyBuildStage = 1;
            }
            return this.isTransactionQueueEmpty;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.recommendedFeeBuildStage == -1) {
                attributes.add("recommendedFee");
            }
            if (this.isTranactionQueueFullBuildStage == -1) {
                attributes.add("isTranactionQueueFull");
            }
            if (this.isTransactionQueueEmptyBuildStage == -1) {
                attributes.add("isTransactionQueueEmpty");
            }
            return "Cannot build ComputedNetworkFees, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="ComputedNetworkFees", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FEE_LOW = 1L;
        private static final long INIT_BIT_FEE_MEDIUM = 2L;
        private static final long INIT_BIT_FEE_HIGH = 4L;
        private static final long INIT_BIT_QUEUE_PERCENTAGE = 8L;
        private long initBits = 15L;
        @Nullable
        private XrpCurrencyAmount feeLow;
        @Nullable
        private XrpCurrencyAmount feeMedium;
        @Nullable
        private XrpCurrencyAmount feeHigh;
        @Nullable
        private BigDecimal queuePercentage;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ComputedNetworkFees instance) {
            Objects.requireNonNull(instance, "instance");
            this.feeLow(instance.feeLow());
            this.feeMedium(instance.feeMedium());
            this.feeHigh(instance.feeHigh());
            this.queuePercentage(instance.queuePercentage());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder feeLow(XrpCurrencyAmount feeLow) {
            this.feeLow = Objects.requireNonNull(feeLow, "feeLow");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder feeMedium(XrpCurrencyAmount feeMedium) {
            this.feeMedium = Objects.requireNonNull(feeMedium, "feeMedium");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder feeHigh(XrpCurrencyAmount feeHigh) {
            this.feeHigh = Objects.requireNonNull(feeHigh, "feeHigh");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queuePercentage(BigDecimal queuePercentage) {
            this.queuePercentage = Objects.requireNonNull(queuePercentage, "queuePercentage");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableComputedNetworkFees build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableComputedNetworkFees(this.feeLow, this.feeMedium, this.feeHigh, this.queuePercentage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("feeLow");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("feeMedium");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("feeHigh");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("queuePercentage");
            }
            return "Cannot build ComputedNetworkFees, some of required attributes are not set " + attributes;
        }
    }
}

