/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.fees;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.fees.ComputedNetworkFees;
import org.xrpl.xrpl4j.model.client.fees.FeeDrops;
import org.xrpl.xrpl4j.model.client.fees.FeeResult;
import org.xrpl.xrpl4j.model.client.fees.ImmutableDecomposedFees;
import org.xrpl.xrpl4j.model.immutables.FluentCompareTo;
import org.xrpl.xrpl4j.model.ledger.SignerListObject;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

public class FeeUtils {
    private static final BigInteger MAX_UNSIGNED_LONG = UnsignedLong.MAX_VALUE.bigIntegerValue();
    private static final BigDecimal ONE_POINT_ONE = new BigDecimal("1.1");
    private static final BigDecimal ZERO_POINT_ONE = new BigDecimal("0.1");
    private static final BigInteger FIVE_HUNDRED = BigInteger.valueOf(500L);
    private static final BigDecimal TWO = new BigDecimal(2);
    private static final BigDecimal THREE = new BigDecimal(3);
    private static final BigInteger FIFTEEN = BigInteger.valueOf(15L);
    private static final BigInteger TEN_THOUSAND = BigInteger.valueOf(10000L);
    private static final BigInteger ONE_THOUSAND = BigInteger.valueOf(1000L);

    public static ComputedNetworkFees computeMultisigNetworkFees(FeeResult feeResult, SignerListObject signerList) {
        Objects.requireNonNull(feeResult);
        Objects.requireNonNull(signerList);
        ComputedNetworkFees computedNetworkFees = FeeUtils.computeNetworkFees(feeResult);
        XrpCurrencyAmount numberOfSignersAsAmount = XrpCurrencyAmount.of(UnsignedLong.valueOf((long)(signerList.signerEntries().size() + 1)));
        return ComputedNetworkFees.builder().feeLow(computedNetworkFees.feeLow().times(numberOfSignersAsAmount)).feeMedium(computedNetworkFees.feeMedium().times(numberOfSignersAsAmount)).feeHigh(computedNetworkFees.feeHigh().times(numberOfSignersAsAmount)).queuePercentage(computedNetworkFees.queuePercentage()).build();
    }

    public static ComputedNetworkFees computeNetworkFees(FeeResult feeResult) {
        Objects.requireNonNull(feeResult);
        DecomposedFees decomposedFees = DecomposedFees.builder(feeResult);
        XrpCurrencyAmount feeLow = FeeUtils.computeFeeLow(decomposedFees);
        return ComputedNetworkFees.builder().feeLow(feeLow).feeMedium(FeeUtils.computeFeeMedium(decomposedFees, feeLow)).feeHigh(FeeUtils.computeFeeHigh(decomposedFees)).queuePercentage(decomposedFees.queuePercentage()).build();
    }

    private static XrpCurrencyAmount computeFeeLow(DecomposedFees decomposedFees) {
        Objects.requireNonNull(decomposedFees);
        BigInteger adjustedMinimumFeeDrops = decomposedFees.adjustedMinimumFeeDrops();
        BigInteger medianFee = decomposedFees.medianFeeDrops();
        BigInteger openLedgerFee = decomposedFees.openLedgerFeeDrops();
        return XrpCurrencyAmount.ofDrops(FeeUtils.toUnsignedLongSafe(FeeUtils.min(FeeUtils.max(adjustedMinimumFeeDrops, FeeUtils.divideToBigInteger(FeeUtils.max(medianFee, openLedgerFee), FIVE_HUNDRED)), ONE_THOUSAND)));
    }

    private static XrpCurrencyAmount computeFeeMedium(DecomposedFees decomposedFees, XrpCurrencyAmount feeLow) {
        Objects.requireNonNull(decomposedFees);
        Objects.requireNonNull(feeLow);
        BigInteger minimumFee = decomposedFees.adjustedMinimumFeeDrops();
        BigDecimal minimumFeeBd = decomposedFees.adjustedMinimumFeeDropsAsBigDecimal();
        BigDecimal medianFeeBd = decomposedFees.medianFeeDropsAsBigDecimal();
        BigDecimal queuePercentage = decomposedFees.queuePercentage();
        BigInteger possibleFeeMedium = FluentCompareTo.is(queuePercentage).greaterThan(ZERO_POINT_ONE) ? minimumFeeBd.add(medianFeeBd).add(decomposedFees.openLedgerFeeDropsAsBigDecimal()).divide(THREE, 0, RoundingMode.HALF_UP).toBigIntegerExact() : FeeUtils.max(minimumFee.multiply(BigInteger.TEN), minimumFeeBd.add(medianFeeBd).divide(TWO, 0, RoundingMode.HALF_UP).toBigIntegerExact());
        BigInteger feeMedium = FeeUtils.min(possibleFeeMedium, feeLow.value().bigIntegerValue().multiply(FIFTEEN), TEN_THOUSAND);
        return XrpCurrencyAmount.ofDrops(FeeUtils.toUnsignedLongSafe(feeMedium));
    }

    private static XrpCurrencyAmount computeFeeHigh(DecomposedFees decomposedFees) {
        Objects.requireNonNull(decomposedFees);
        BigInteger minimumFee = decomposedFees.adjustedMinimumFeeDrops();
        BigInteger medianFee = decomposedFees.medianFeeDrops();
        BigInteger openLedgerFee = decomposedFees.openLedgerFeeDrops();
        BigInteger feeHigh = FeeUtils.min(FeeUtils.max(minimumFee.multiply(BigInteger.TEN), FeeUtils.multiplyToBigInteger(FeeUtils.max(medianFee, openLedgerFee), ONE_POINT_ONE)), TEN_THOUSAND);
        return XrpCurrencyAmount.ofDrops(FeeUtils.toUnsignedLongSafe(feeHigh));
    }

    @VisibleForTesting
    public static boolean queueIsEmpty(BigDecimal queuePercentage) {
        Objects.requireNonNull(queuePercentage);
        return FluentCompareTo.is(queuePercentage).lessThanOrEqualTo(BigDecimal.ZERO);
    }

    @VisibleForTesting
    public static boolean queueIsNotEmptyAndNotFull(BigDecimal queuePercentage) {
        Objects.requireNonNull(queuePercentage);
        return FluentCompareTo.is(queuePercentage).betweenExclusive(BigDecimal.ZERO, BigDecimal.ONE);
    }

    @VisibleForTesting
    static UnsignedLong toUnsignedLongSafe(BigInteger value) {
        Objects.requireNonNull(value);
        return UnsignedLong.valueOf((BigInteger)FeeUtils.min(value, MAX_UNSIGNED_LONG));
    }

    @VisibleForTesting
    static BigInteger min(BigInteger input1, BigInteger ... otherInputs) {
        Objects.requireNonNull(input1);
        Objects.requireNonNull(otherInputs);
        return Arrays.stream(otherInputs).min(BigInteger::compareTo).orElse(input1).min(input1);
    }

    @VisibleForTesting
    static BigInteger max(BigInteger input1, BigInteger ... otherInputs) {
        Objects.requireNonNull(input1);
        Objects.requireNonNull(otherInputs);
        return Arrays.stream(otherInputs).max(BigInteger::compareTo).orElse(input1).max(input1);
    }

    @VisibleForTesting
    static BigInteger divideToBigInteger(BigDecimal numerator, BigDecimal denominator) {
        Objects.requireNonNull(numerator);
        Objects.requireNonNull(denominator);
        Preconditions.checkArgument((boolean)FluentCompareTo.is(denominator).greaterThan(BigDecimal.ZERO));
        return numerator.divide(denominator, 0, RoundingMode.HALF_UP).toBigIntegerExact();
    }

    @VisibleForTesting
    static BigInteger divideToBigInteger(BigInteger numerator, BigInteger denominator) {
        return FeeUtils.divideToBigInteger(new BigDecimal(numerator), new BigDecimal(denominator));
    }

    @VisibleForTesting
    static BigInteger multiplyToBigInteger(BigInteger input1, BigDecimal input2) {
        Objects.requireNonNull(input1);
        Objects.requireNonNull(input2);
        return new BigDecimal(input1).multiply(input2).setScale(0, RoundingMode.HALF_UP).toBigIntegerExact();
    }

    @Value.Immutable
    public static interface DecomposedFees {
        public static final BigDecimal ONE_POINT_FIVE = new BigDecimal("1.5");
        public static final BigInteger MAX_XRP_IN_DROPS_BIG_INT = BigInteger.valueOf(100000000000000000L);

        public static DecomposedFees builder(FeeResult feeResult) {
            Objects.requireNonNull(feeResult);
            BigDecimal currentQueueSize = new BigDecimal(feeResult.currentQueueSize().bigIntegerValue());
            BigDecimal maxQueueSize = feeResult.maxQueueSize().map(UnsignedInteger::bigIntegerValue).map(BigDecimal::new).orElse(new BigDecimal(5000));
            BigDecimal queuePercentage = FluentCompareTo.is(currentQueueSize).equalTo(BigDecimal.ZERO) ? BigDecimal.ZERO : currentQueueSize.divide(maxQueueSize, MathContext.DECIMAL128);
            return DecomposedFees.builder(feeResult.drops(), queuePercentage);
        }

        public static DecomposedFees builder(FeeDrops feeDrops, BigDecimal queuePercentage) {
            Objects.requireNonNull(feeDrops);
            Objects.requireNonNull(queuePercentage);
            Preconditions.checkArgument((boolean)FluentCompareTo.is(queuePercentage).greaterThanEqualTo(BigDecimal.ZERO));
            Preconditions.checkArgument((boolean)FluentCompareTo.is(queuePercentage).lessThanOrEqualTo(BigDecimal.ONE));
            BigInteger adjustedMinimumFeeDrops = FeeUtils.min(MAX_XRP_IN_DROPS_BIG_INT, new BigDecimal(feeDrops.minimumFee().value().bigIntegerValue()).multiply(ONE_POINT_FIVE).setScale(0, RoundingMode.HALF_DOWN).toBigIntegerExact());
            return ImmutableDecomposedFees.builder().adjustedMinimumFeeDrops(adjustedMinimumFeeDrops).medianFeeDrops(feeDrops.medianFee().value().bigIntegerValue()).openLedgerFeeDrops(feeDrops.openLedgerFee().value().bigIntegerValue()).queuePercentage(queuePercentage).build();
        }

        public BigInteger adjustedMinimumFeeDrops();

        @Value.Derived
        default public BigDecimal adjustedMinimumFeeDropsAsBigDecimal() {
            return new BigDecimal(this.adjustedMinimumFeeDrops());
        }

        public BigInteger medianFeeDrops();

        @Value.Derived
        default public BigDecimal medianFeeDropsAsBigDecimal() {
            return new BigDecimal(this.medianFeeDrops());
        }

        public BigInteger openLedgerFeeDrops();

        @Value.Derived
        default public BigDecimal openLedgerFeeDropsAsBigDecimal() {
            return new BigDecimal(this.openLedgerFeeDrops());
        }

        public BigDecimal queuePercentage();
    }
}

