/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.fees;

import java.math.BigDecimal;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.fees.ImmutableComputedNetworkFees;
import org.xrpl.xrpl4j.model.immutables.FluentCompareTo;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@Value.Immutable
public interface ComputedNetworkFees {
    public static ImmutableComputedNetworkFees.Builder builder() {
        return ImmutableComputedNetworkFees.builder();
    }

    public XrpCurrencyAmount feeLow();

    public XrpCurrencyAmount feeMedium();

    public XrpCurrencyAmount feeHigh();

    public BigDecimal queuePercentage();

    @Value.Derived
    default public XrpCurrencyAmount recommendedFee() {
        if (this.isTransactionQueueEmpty()) {
            return this.feeLow();
        }
        if (this.isTranactionQueueFull()) {
            return this.feeHigh();
        }
        return this.feeMedium();
    }

    @Value.Derived
    default public boolean isTranactionQueueFull() {
        return FluentCompareTo.is(this.queuePercentage()).greaterThanEqualTo(BigDecimal.ONE);
    }

    @Value.Derived
    default public boolean isTransactionQueueEmpty() {
        return FluentCompareTo.is(this.queuePercentage()).lessThanOrEqualTo(BigDecimal.ZERO);
    }
}

