/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import java.io.Serializable;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerIndexBound;
import org.xrpl.xrpl4j.model.immutables.FluentCompareTo;
import org.xrpl.xrpl4j.model.immutables.Wrapped;
import org.xrpl.xrpl4j.model.immutables.Wrapper;
import org.xrpl.xrpl4j.model.jackson.modules.LedgerIndexBoundDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.LedgerIndexBoundSerializer;

public class Wrappers {

    @JsonSerialize(as=LedgerIndexBound.class, using=LedgerIndexBoundSerializer.class)
    @JsonDeserialize(as=LedgerIndexBound.class, using=LedgerIndexBoundDeserializer.class)
    @Value.Immutable
    @Wrapped
    static abstract class _LedgerIndexBound
    extends Wrapper<Long>
    implements Serializable {
        _LedgerIndexBound() {
        }

        public static LedgerIndexBound of(int ledgerIndexBound) {
            return LedgerIndexBound.of(Integer.valueOf(ledgerIndexBound).longValue());
        }

        public static LedgerIndexBound unbounded() {
            return LedgerIndexBound.of(-1);
        }

        @Override
        public String toString() {
            return ((Long)this.value()).toString();
        }

        public LedgerIndexBound plus(LedgerIndexBound other) {
            this.checkAdditionOverflow(other.value());
            return LedgerIndexBound.of((Long)this.value() + other.value());
        }

        public LedgerIndexBound plus(LedgerIndex ledgerIndex) {
            this.checkAdditionOverflow(ledgerIndex.unsignedIntegerValue().longValue());
            return LedgerIndexBound.of((Long)this.value() + ledgerIndex.unsignedIntegerValue().longValue());
        }

        public LedgerIndexBound plus(Long value) {
            this.checkAdditionOverflow(value);
            return LedgerIndexBound.of((Long)this.value() + value);
        }

        public LedgerIndexBound plus(Integer value) {
            return this.plus(value.longValue());
        }

        public LedgerIndexBound minus(LedgerIndexBound other) {
            this.checkSubtractionInBounds(other.value());
            return LedgerIndexBound.of((Long)this.value() - other.value());
        }

        public LedgerIndexBound minus(LedgerIndex ledgerIndex) {
            this.checkSubtractionInBounds(ledgerIndex.unsignedIntegerValue().longValue());
            return LedgerIndexBound.of((Long)this.value() - ledgerIndex.unsignedIntegerValue().longValue());
        }

        public LedgerIndexBound minus(Long value) {
            this.checkSubtractionInBounds(value);
            return LedgerIndexBound.of((Long)this.value() - value);
        }

        public LedgerIndexBound minus(Integer value) {
            return this.minus(value.longValue());
        }

        @Value.Check
        public void checkBounds() {
            Preconditions.checkArgument(((Long)this.value() >= -1L ? 1 : 0) != 0, (Object)"LedgerIndexBounds must be greater than or equal to -1.");
            Preconditions.checkArgument(((Long)this.value() <= UnsignedInteger.MAX_VALUE.longValue() ? 1 : 0) != 0, (Object)("LedgerIndexBounds cannot be larger than max unsigned integer value " + UnsignedInteger.MAX_VALUE.toString()));
        }

        @Value.Auxiliary
        private void checkAdditionOverflow(Long addedValue) {
            Preconditions.checkArgument((boolean)FluentCompareTo.is(Long.MAX_VALUE - addedValue).greaterThanEqualTo((Long)this.value()), (Object)String.format("Value too large. Adding %s would cause an overflow.", addedValue));
        }

        @Value.Auxiliary
        private void checkSubtractionInBounds(Long subtractedValue) {
            Preconditions.checkArgument((boolean)FluentCompareTo.is(subtractedValue).lessThanOrEqualTo((Long)this.value() - 1L), (Object)String.format("Value too large. Subtracting %s would result in a LedgerIndexBound below 1.", subtractedValue));
        }
    }
}

