/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.common.ImmutableLedgerSpecifier;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerIndexShortcut;
import org.xrpl.xrpl4j.model.jackson.modules.LedgerSpecifierDeserializer;
import org.xrpl.xrpl4j.model.jackson.modules.LedgerSpecifierSerializer;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableLedgerSpecifier.class, using=LedgerSpecifierSerializer.class)
@JsonDeserialize(as=ImmutableLedgerSpecifier.class, using=LedgerSpecifierDeserializer.class)
@Value.Immutable
public interface LedgerSpecifier {
    public static final LedgerSpecifier VALIDATED = ImmutableLedgerSpecifier.builder().ledgerIndexShortcut(LedgerIndexShortcut.VALIDATED).build();
    public static final LedgerSpecifier CURRENT = ImmutableLedgerSpecifier.builder().ledgerIndexShortcut(LedgerIndexShortcut.CURRENT).build();
    public static final LedgerSpecifier CLOSED = ImmutableLedgerSpecifier.builder().ledgerIndexShortcut(LedgerIndexShortcut.CLOSED).build();

    public static LedgerSpecifier of(Hash256 ledgerHash) {
        return ImmutableLedgerSpecifier.builder().ledgerHash(ledgerHash).build();
    }

    public static LedgerSpecifier of(LedgerIndex ledgerIndex) {
        return ImmutableLedgerSpecifier.builder().ledgerIndex(ledgerIndex).build();
    }

    public static LedgerSpecifier of(UnsignedInteger ledgerIndex) {
        return LedgerSpecifier.of(LedgerIndex.of(ledgerIndex));
    }

    public static LedgerSpecifier of(int ledgerIndex) {
        return LedgerSpecifier.of(UnsignedInteger.valueOf((long)ledgerIndex));
    }

    public Optional<Hash256> ledgerHash();

    public Optional<LedgerIndex> ledgerIndex();

    public Optional<LedgerIndexShortcut> ledgerIndexShortcut();

    @Value.Auxiliary
    default public void handle(Consumer<Hash256> ledgerHashHandler, Consumer<LedgerIndex> ledgerIndexHandler, Consumer<LedgerIndexShortcut> ledgerIndexShortcutHandler) {
        Objects.requireNonNull(ledgerHashHandler);
        Objects.requireNonNull(ledgerIndexHandler);
        Objects.requireNonNull(ledgerIndexShortcutHandler);
        this.ledgerHash().ifPresent(ledgerHashHandler);
        this.ledgerIndex().ifPresent(ledgerIndexHandler);
        this.ledgerIndexShortcut().ifPresent(ledgerIndexShortcutHandler);
    }

    @Value.Auxiliary
    default public <R> R map(Function<Hash256, R> ledgerHashMapper, Function<LedgerIndex, R> ledgerIndexMapper, Function<LedgerIndexShortcut, R> ledgerIndexShortcutMapper) {
        Objects.requireNonNull(ledgerHashMapper);
        Objects.requireNonNull(ledgerIndexMapper);
        Objects.requireNonNull(ledgerIndexShortcutMapper);
        if (this.ledgerHash().isPresent()) {
            return ledgerHashMapper.apply(this.ledgerHash().get());
        }
        if (this.ledgerIndex().isPresent()) {
            return ledgerIndexMapper.apply(this.ledgerIndex().get());
        }
        if (this.ledgerIndexShortcut().isPresent()) {
            return ledgerIndexShortcutMapper.apply(this.ledgerIndexShortcut().get());
        }
        throw new IllegalStateException("Unsupported field.");
    }

    @Value.Check
    default public void validateOnlyOneSpecified() {
        int numSpecified = 0;
        if (this.ledgerHash().isPresent()) {
            ++numSpecified;
        }
        if (this.ledgerIndex().isPresent()) {
            ++numSpecified;
        }
        if (this.ledgerIndexShortcut().isPresent()) {
            ++numSpecified;
        }
        Preconditions.checkArgument((numSpecified == 1 ? 1 : 0) != 0, (Object)String.format("Only one Ledger specifier may be specified using one of ledgerHash, ledgerIndex or ledgerIndexShortcut. %s were specified", numSpecified));
    }
}

