/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.common;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import java.util.Objects;
import org.xrpl.xrpl4j.model.immutables.FluentCompareTo;

public class LedgerIndex {
    private final UnsignedInteger value;

    private LedgerIndex(UnsignedInteger value) {
        this.value = value;
    }

    public static LedgerIndex of(UnsignedInteger value) {
        Objects.requireNonNull(value);
        return new LedgerIndex(value);
    }

    public UnsignedInteger unsignedIntegerValue() {
        return this.value;
    }

    public LedgerIndex plus(UnsignedInteger other) {
        this.checkAdditionOverflow(other);
        return LedgerIndex.of(this.unsignedIntegerValue().plus(other));
    }

    public LedgerIndex plus(LedgerIndex other) {
        return this.plus(other.unsignedIntegerValue());
    }

    public LedgerIndex minus(LedgerIndex other) {
        return this.minus(other.unsignedIntegerValue());
    }

    public LedgerIndex minus(UnsignedInteger value) {
        this.checkSubtractionOverflow(value);
        return LedgerIndex.of(this.unsignedIntegerValue().minus(value));
    }

    private void checkAdditionOverflow(UnsignedInteger addedValue) {
        Preconditions.checkArgument((boolean)FluentCompareTo.is(UnsignedInteger.MAX_VALUE.minus(addedValue)).greaterThanEqualTo(this.unsignedIntegerValue()), (Object)String.format("Value too large. Adding %s would cause an overflow.", addedValue));
    }

    private void checkSubtractionOverflow(UnsignedInteger subtractedValue) {
        Preconditions.checkArgument((boolean)FluentCompareTo.is(subtractedValue).lessThanOrEqualTo(this.unsignedIntegerValue()), (Object)String.format("Value too large. Subtracting %s would cause an overflow.", subtractedValue));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LedgerIndex)) {
            return false;
        }
        LedgerIndex that = (LedgerIndex)obj;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }
}

