/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerIndexShortcut;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LedgerSpecifier", generator="Immutables")
@Immutable
public final class ImmutableLedgerSpecifier
implements LedgerSpecifier {
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final LedgerIndexShortcut ledgerIndexShortcut;

    private ImmutableLedgerSpecifier(@Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, @Nullable LedgerIndexShortcut ledgerIndexShortcut) {
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.ledgerIndexShortcut = ledgerIndexShortcut;
    }

    @Override
    @JsonProperty(value="ledgerHash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledgerIndex")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="ledgerIndexShortcut")
    public Optional<LedgerIndexShortcut> ledgerIndexShortcut() {
        return Optional.ofNullable(this.ledgerIndexShortcut);
    }

    public final ImmutableLedgerSpecifier withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return ImmutableLedgerSpecifier.validate(new ImmutableLedgerSpecifier(newValue, this.ledgerIndex, this.ledgerIndexShortcut));
    }

    public final ImmutableLedgerSpecifier withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return ImmutableLedgerSpecifier.validate(new ImmutableLedgerSpecifier(value, this.ledgerIndex, this.ledgerIndexShortcut));
    }

    public final ImmutableLedgerSpecifier withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return ImmutableLedgerSpecifier.validate(new ImmutableLedgerSpecifier(this.ledgerHash, newValue, this.ledgerIndexShortcut));
    }

    public final ImmutableLedgerSpecifier withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return ImmutableLedgerSpecifier.validate(new ImmutableLedgerSpecifier(this.ledgerHash, value, this.ledgerIndexShortcut));
    }

    public final ImmutableLedgerSpecifier withLedgerIndexShortcut(LedgerIndexShortcut value) {
        LedgerIndexShortcut newValue = Objects.requireNonNull(value, "ledgerIndexShortcut");
        if (this.ledgerIndexShortcut == newValue) {
            return this;
        }
        return ImmutableLedgerSpecifier.validate(new ImmutableLedgerSpecifier(this.ledgerHash, this.ledgerIndex, newValue));
    }

    public final ImmutableLedgerSpecifier withLedgerIndexShortcut(Optional<? extends LedgerIndexShortcut> optional) {
        LedgerIndexShortcut value = optional.orElse(null);
        if (this.ledgerIndexShortcut == value) {
            return this;
        }
        return ImmutableLedgerSpecifier.validate(new ImmutableLedgerSpecifier(this.ledgerHash, this.ledgerIndex, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLedgerSpecifier && this.equalTo(0, (ImmutableLedgerSpecifier)another);
    }

    private boolean equalTo(int synthetic, ImmutableLedgerSpecifier another) {
        return Objects.equals(this.ledgerHash, another.ledgerHash) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && Objects.equals(this.ledgerIndexShortcut, another.ledgerIndexShortcut);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerIndexShortcut);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LedgerSpecifier").omitNullValues().add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerIndexShortcut", (Object)this.ledgerIndexShortcut).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLedgerSpecifier fromJson(Json json) {
        Builder builder = ImmutableLedgerSpecifier.builder();
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerIndexShortcut != null) {
            builder.ledgerIndexShortcut(json.ledgerIndexShortcut);
        }
        return builder.build();
    }

    private static ImmutableLedgerSpecifier validate(ImmutableLedgerSpecifier instance) {
        instance.validateOnlyOneSpecified();
        return instance;
    }

    public static ImmutableLedgerSpecifier copyOf(LedgerSpecifier instance) {
        if (instance instanceof ImmutableLedgerSpecifier) {
            return (ImmutableLedgerSpecifier)instance;
        }
        return ImmutableLedgerSpecifier.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LedgerSpecifier", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerIndexShortcut ledgerIndexShortcut;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LedgerSpecifier instance) {
            Optional<LedgerIndexShortcut> ledgerIndexShortcutOptional;
            Optional<LedgerIndex> ledgerIndexOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
            if (ledgerHashOptional.isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            if ((ledgerIndexOptional = instance.ledgerIndex()).isPresent()) {
                this.ledgerIndex(ledgerIndexOptional);
            }
            if ((ledgerIndexShortcutOptional = instance.ledgerIndexShortcut()).isPresent()) {
                this.ledgerIndexShortcut(ledgerIndexShortcutOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledgerHash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledgerIndex")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndexShortcut(LedgerIndexShortcut ledgerIndexShortcut) {
            this.ledgerIndexShortcut = Objects.requireNonNull(ledgerIndexShortcut, "ledgerIndexShortcut");
            return this;
        }

        @JsonProperty(value="ledgerIndexShortcut")
        @CanIgnoreReturnValue
        public final Builder ledgerIndexShortcut(Optional<? extends LedgerIndexShortcut> ledgerIndexShortcut) {
            this.ledgerIndexShortcut = ledgerIndexShortcut.orElse(null);
            return this;
        }

        public ImmutableLedgerSpecifier build() {
            return ImmutableLedgerSpecifier.validate(new ImmutableLedgerSpecifier(this.ledgerHash, this.ledgerIndex, this.ledgerIndexShortcut));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LedgerSpecifier", generator="Immutables")
    static final class Json
    implements LedgerSpecifier {
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<LedgerIndexShortcut> ledgerIndexShortcut = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ledgerHash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledgerIndex")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledgerIndexShortcut")
        public void setLedgerIndexShortcut(Optional<LedgerIndexShortcut> ledgerIndexShortcut) {
            this.ledgerIndexShortcut = ledgerIndexShortcut;
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndexShortcut> ledgerIndexShortcut() {
            throw new UnsupportedOperationException();
        }
    }
}

