/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.channels.UnsignedClaim;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UnsignedClaim", generator="Immutables")
@Immutable
public final class ImmutableUnsignedClaim
implements UnsignedClaim {
    private final Hash256 channel;
    private final XrpCurrencyAmount amount;

    private ImmutableUnsignedClaim(Hash256 channel, XrpCurrencyAmount amount) {
        this.channel = channel;
        this.amount = amount;
    }

    @Override
    @JsonProperty(value="Channel")
    public Hash256 channel() {
        return this.channel;
    }

    @Override
    @JsonProperty(value="Amount")
    public XrpCurrencyAmount amount() {
        return this.amount;
    }

    public final ImmutableUnsignedClaim withChannel(Hash256 value) {
        if (this.channel == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableUnsignedClaim(newValue, this.amount);
    }

    public final ImmutableUnsignedClaim withAmount(XrpCurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutableUnsignedClaim(this.channel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUnsignedClaim && this.equalTo(0, (ImmutableUnsignedClaim)another);
    }

    private boolean equalTo(int synthetic, ImmutableUnsignedClaim another) {
        return this.channel.equals(another.channel) && this.amount.equals(another.amount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.amount.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UnsignedClaim").omitNullValues().add("channel", (Object)this.channel).add("amount", (Object)this.amount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUnsignedClaim fromJson(Json json) {
        Builder builder = ImmutableUnsignedClaim.builder();
        if (json.channel != null) {
            builder.channel(json.channel);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        return builder.build();
    }

    public static ImmutableUnsignedClaim copyOf(UnsignedClaim instance) {
        if (instance instanceof ImmutableUnsignedClaim) {
            return (ImmutableUnsignedClaim)instance;
        }
        return ImmutableUnsignedClaim.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UnsignedClaim", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private static final long INIT_BIT_AMOUNT = 2L;
        private long initBits = 3L;
        @Nullable
        private Hash256 channel;
        @Nullable
        private XrpCurrencyAmount amount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UnsignedClaim instance) {
            Objects.requireNonNull(instance, "instance");
            this.channel(instance.channel());
            this.amount(instance.amount());
            return this;
        }

        @JsonProperty(value="Channel")
        @CanIgnoreReturnValue
        public final Builder channel(Hash256 channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(XrpCurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUnsignedClaim build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUnsignedClaim(this.channel, this.amount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("amount");
            }
            return "Cannot build UnsignedClaim, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UnsignedClaim", generator="Immutables")
    static final class Json
    implements UnsignedClaim {
        @Nullable
        Hash256 channel;
        @Nullable
        XrpCurrencyAmount amount;

        Json() {
        }

        @JsonProperty(value="Channel")
        public void setChannel(Hash256 channel) {
            this.channel = channel;
        }

        @JsonProperty(value="Amount")
        public void setAmount(XrpCurrencyAmount amount) {
            this.amount = amount;
        }

        @Override
        public Hash256 channel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }
    }
}

