/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.channels.ChannelVerifyResult;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ChannelVerifyResult", generator="Immutables")
@Immutable
public final class ImmutableChannelVerifyResult
implements ChannelVerifyResult {
    @Nullable
    private final String status;
    private final boolean signatureVerified;

    private ImmutableChannelVerifyResult(@Nullable String status, boolean signatureVerified) {
        this.status = status;
        this.signatureVerified = signatureVerified;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="signature_verified")
    public boolean signatureVerified() {
        return this.signatureVerified;
    }

    public final ImmutableChannelVerifyResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableChannelVerifyResult(newValue, this.signatureVerified);
    }

    public final ImmutableChannelVerifyResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableChannelVerifyResult(value, this.signatureVerified);
    }

    public final ImmutableChannelVerifyResult withSignatureVerified(boolean value) {
        if (this.signatureVerified == value) {
            return this;
        }
        return new ImmutableChannelVerifyResult(this.status, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelVerifyResult && this.equalTo(0, (ImmutableChannelVerifyResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelVerifyResult another) {
        return Objects.equals(this.status, another.status) && this.signatureVerified == another.signatureVerified;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Booleans.hashCode((boolean)this.signatureVerified);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ChannelVerifyResult").omitNullValues().add("status", (Object)this.status).add("signatureVerified", this.signatureVerified).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableChannelVerifyResult fromJson(Json json) {
        Builder builder = ImmutableChannelVerifyResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.signatureVerifiedIsSet) {
            builder.signatureVerified(json.signatureVerified);
        }
        return builder.build();
    }

    public static ImmutableChannelVerifyResult copyOf(ChannelVerifyResult instance) {
        if (instance instanceof ImmutableChannelVerifyResult) {
            return (ImmutableChannelVerifyResult)instance;
        }
        return ImmutableChannelVerifyResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChannelVerifyResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SIGNATURE_VERIFIED = 1L;
        private long initBits = 1L;
        @Nullable
        private String status;
        private boolean signatureVerified;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ChannelVerifyResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> statusOptional;
            XrplResult instance;
            long bits = 0L;
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelVerifyResult) {
                instance = (ChannelVerifyResult)object;
                if ((bits & 1L) == 0L) {
                    statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
                this.signatureVerified(instance.signatureVerified());
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="signature_verified")
        @CanIgnoreReturnValue
        public final Builder signatureVerified(boolean signatureVerified) {
            this.signatureVerified = signatureVerified;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableChannelVerifyResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelVerifyResult(this.status, this.signatureVerified);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("signatureVerified");
            }
            return "Cannot build ChannelVerifyResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChannelVerifyResult", generator="Immutables")
    static final class Json
    implements ChannelVerifyResult {
        @Nullable
        Optional<String> status = Optional.empty();
        boolean signatureVerified;
        boolean signatureVerifiedIsSet;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="signature_verified")
        public void setSignatureVerified(boolean signatureVerified) {
            this.signatureVerified = signatureVerified;
            this.signatureVerifiedIsSet = true;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean signatureVerified() {
            throw new UnsupportedOperationException();
        }
    }
}

