/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.channels.ChannelVerifyRequestParams;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ChannelVerifyRequestParams", generator="Immutables")
@Immutable
public final class ImmutableChannelVerifyRequestParams
implements ChannelVerifyRequestParams {
    private final XrpCurrencyAmount amount;
    private final Hash256 channelId;
    private final String publicKey;
    private final String signature;

    private ImmutableChannelVerifyRequestParams(XrpCurrencyAmount amount, Hash256 channelId, String publicKey, String signature) {
        this.amount = amount;
        this.channelId = channelId;
        this.publicKey = publicKey;
        this.signature = signature;
    }

    @Override
    @JsonProperty(value="amount")
    public XrpCurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="channel_id")
    public Hash256 channelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="public_key")
    public String publicKey() {
        return this.publicKey;
    }

    @Override
    @JsonProperty(value="signature")
    public String signature() {
        return this.signature;
    }

    public final ImmutableChannelVerifyRequestParams withAmount(XrpCurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutableChannelVerifyRequestParams(newValue, this.channelId, this.publicKey, this.signature);
    }

    public final ImmutableChannelVerifyRequestParams withChannelId(Hash256 value) {
        if (this.channelId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "channelId");
        return new ImmutableChannelVerifyRequestParams(this.amount, newValue, this.publicKey, this.signature);
    }

    public final ImmutableChannelVerifyRequestParams withPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "publicKey");
        if (this.publicKey.equals(newValue)) {
            return this;
        }
        return new ImmutableChannelVerifyRequestParams(this.amount, this.channelId, newValue, this.signature);
    }

    public final ImmutableChannelVerifyRequestParams withSignature(String value) {
        String newValue = Objects.requireNonNull(value, "signature");
        if (this.signature.equals(newValue)) {
            return this;
        }
        return new ImmutableChannelVerifyRequestParams(this.amount, this.channelId, this.publicKey, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelVerifyRequestParams && this.equalTo(0, (ImmutableChannelVerifyRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelVerifyRequestParams another) {
        return this.amount.equals(another.amount) && this.channelId.equals(another.channelId) && this.publicKey.equals(another.publicKey) && this.signature.equals(another.signature);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.publicKey.hashCode();
        h += (h << 5) + this.signature.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ChannelVerifyRequestParams").omitNullValues().add("amount", (Object)this.amount).add("channelId", (Object)this.channelId).add("publicKey", (Object)this.publicKey).add("signature", (Object)this.signature).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableChannelVerifyRequestParams fromJson(Json json) {
        Builder builder = ImmutableChannelVerifyRequestParams.builder();
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.publicKey != null) {
            builder.publicKey(json.publicKey);
        }
        if (json.signature != null) {
            builder.signature(json.signature);
        }
        return builder.build();
    }

    public static ImmutableChannelVerifyRequestParams copyOf(ChannelVerifyRequestParams instance) {
        if (instance instanceof ImmutableChannelVerifyRequestParams) {
            return (ImmutableChannelVerifyRequestParams)instance;
        }
        return ImmutableChannelVerifyRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChannelVerifyRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AMOUNT = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_PUBLIC_KEY = 4L;
        private static final long INIT_BIT_SIGNATURE = 8L;
        private long initBits = 15L;
        @Nullable
        private XrpCurrencyAmount amount;
        @Nullable
        private Hash256 channelId;
        @Nullable
        private String publicKey;
        @Nullable
        private String signature;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ChannelVerifyRequestParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.amount(instance.amount());
            this.channelId(instance.channelId());
            this.publicKey(instance.publicKey());
            this.signature(instance.signature());
            return this;
        }

        @JsonProperty(value="amount")
        @CanIgnoreReturnValue
        public final Builder amount(XrpCurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="channel_id")
        @CanIgnoreReturnValue
        public final Builder channelId(Hash256 channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="public_key")
        @CanIgnoreReturnValue
        public final Builder publicKey(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="signature")
        @CanIgnoreReturnValue
        public final Builder signature(String signature) {
            this.signature = Objects.requireNonNull(signature, "signature");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableChannelVerifyRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelVerifyRequestParams(this.amount, this.channelId, this.publicKey, this.signature);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("publicKey");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("signature");
            }
            return "Cannot build ChannelVerifyRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChannelVerifyRequestParams", generator="Immutables")
    static final class Json
    implements ChannelVerifyRequestParams {
        @Nullable
        XrpCurrencyAmount amount;
        @Nullable
        Hash256 channelId;
        @Nullable
        String publicKey;
        @Nullable
        String signature;

        Json() {
        }

        @JsonProperty(value="amount")
        public void setAmount(XrpCurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Hash256 channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="public_key")
        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @JsonProperty(value="signature")
        public void setSignature(String signature) {
            this.signature = signature;
        }

        @Override
        public XrpCurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String publicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String signature() {
            throw new UnsupportedOperationException();
        }
    }
}

