/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.amm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoVoteEntry;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.TradingFee;
import org.xrpl.xrpl4j.model.transactions.VoteWeight;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AmmInfoVoteEntry", generator="Immutables")
@Immutable
public final class ImmutableAmmInfoVoteEntry
implements AmmInfoVoteEntry {
    private final Address account;
    private final TradingFee tradingFee;
    private final VoteWeight voteWeight;

    private ImmutableAmmInfoVoteEntry(Address account, TradingFee tradingFee, VoteWeight voteWeight) {
        this.account = account;
        this.tradingFee = tradingFee;
        this.voteWeight = voteWeight;
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="trading_fee")
    public TradingFee tradingFee() {
        return this.tradingFee;
    }

    @Override
    @JsonProperty(value="vote_weight")
    public VoteWeight voteWeight() {
        return this.voteWeight;
    }

    public final ImmutableAmmInfoVoteEntry withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAmmInfoVoteEntry(newValue, this.tradingFee, this.voteWeight);
    }

    public final ImmutableAmmInfoVoteEntry withTradingFee(TradingFee value) {
        if (this.tradingFee == value) {
            return this;
        }
        TradingFee newValue = Objects.requireNonNull(value, "tradingFee");
        return new ImmutableAmmInfoVoteEntry(this.account, newValue, this.voteWeight);
    }

    public final ImmutableAmmInfoVoteEntry withVoteWeight(VoteWeight value) {
        if (this.voteWeight == value) {
            return this;
        }
        VoteWeight newValue = Objects.requireNonNull(value, "voteWeight");
        return new ImmutableAmmInfoVoteEntry(this.account, this.tradingFee, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAmmInfoVoteEntry && this.equalTo(0, (ImmutableAmmInfoVoteEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableAmmInfoVoteEntry another) {
        return this.account.equals(another.account) && this.tradingFee.equals(another.tradingFee) && this.voteWeight.equals(another.voteWeight);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.tradingFee.hashCode();
        h += (h << 5) + this.voteWeight.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AmmInfoVoteEntry").omitNullValues().add("account", (Object)this.account).add("tradingFee", (Object)this.tradingFee).add("voteWeight", (Object)this.voteWeight).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAmmInfoVoteEntry fromJson(Json json) {
        Builder builder = ImmutableAmmInfoVoteEntry.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.tradingFee != null) {
            builder.tradingFee(json.tradingFee);
        }
        if (json.voteWeight != null) {
            builder.voteWeight(json.voteWeight);
        }
        return builder.build();
    }

    public static ImmutableAmmInfoVoteEntry copyOf(AmmInfoVoteEntry instance) {
        if (instance instanceof ImmutableAmmInfoVoteEntry) {
            return (ImmutableAmmInfoVoteEntry)instance;
        }
        return ImmutableAmmInfoVoteEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AmmInfoVoteEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_TRADING_FEE = 2L;
        private static final long INIT_BIT_VOTE_WEIGHT = 4L;
        private long initBits = 7L;
        @Nullable
        private Address account;
        @Nullable
        private TradingFee tradingFee;
        @Nullable
        private VoteWeight voteWeight;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AmmInfoVoteEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.tradingFee(instance.tradingFee());
            this.voteWeight(instance.voteWeight());
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="trading_fee")
        @CanIgnoreReturnValue
        public final Builder tradingFee(TradingFee tradingFee) {
            this.tradingFee = Objects.requireNonNull(tradingFee, "tradingFee");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="vote_weight")
        @CanIgnoreReturnValue
        public final Builder voteWeight(VoteWeight voteWeight) {
            this.voteWeight = Objects.requireNonNull(voteWeight, "voteWeight");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAmmInfoVoteEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAmmInfoVoteEntry(this.account, this.tradingFee, this.voteWeight);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tradingFee");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("voteWeight");
            }
            return "Cannot build AmmInfoVoteEntry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AmmInfoVoteEntry", generator="Immutables")
    static final class Json
    implements AmmInfoVoteEntry {
        @Nullable
        Address account;
        @Nullable
        TradingFee tradingFee;
        @Nullable
        VoteWeight voteWeight;

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="trading_fee")
        public void setTradingFee(TradingFee tradingFee) {
            this.tradingFee = tradingFee;
        }

        @JsonProperty(value="vote_weight")
        public void setVoteWeight(VoteWeight voteWeight) {
            this.voteWeight = voteWeight;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TradingFee tradingFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public VoteWeight voteWeight() {
            throw new UnsupportedOperationException();
        }
    }
}

