/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.amm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.amm.AmmInfo;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AmmInfoResult", generator="Immutables")
@Immutable
public final class ImmutableAmmInfoResult
implements AmmInfoResult {
    @Nullable
    private final String status;
    private final AmmInfo amm;
    @Nullable
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final LedgerIndex ledgerCurrentIndex;
    private final boolean validated;
    @Nullable
    private final Hash256 ledgerHash;

    private ImmutableAmmInfoResult(Builder builder) {
        this.status = builder.status;
        this.amm = builder.amm;
        this.ledgerIndex = builder.ledgerIndex;
        this.ledgerCurrentIndex = builder.ledgerCurrentIndex;
        this.ledgerHash = builder.ledgerHash;
        this.validated = builder.validatedIsSet() ? builder.validated : AmmInfoResult.super.validated();
    }

    private ImmutableAmmInfoResult(@Nullable String status, AmmInfo amm, @Nullable LedgerIndex ledgerIndex, @Nullable LedgerIndex ledgerCurrentIndex, boolean validated, @Nullable Hash256 ledgerHash) {
        this.status = status;
        this.amm = amm;
        this.ledgerIndex = ledgerIndex;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
        this.validated = validated;
        this.ledgerHash = ledgerHash;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="amm")
    public AmmInfo amm() {
        return this.amm;
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex() {
        return Optional.ofNullable(this.ledgerCurrentIndex);
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        return this.validated;
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    public final ImmutableAmmInfoResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableAmmInfoResult(newValue, this.amm, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.ledgerHash);
    }

    public final ImmutableAmmInfoResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableAmmInfoResult(value, this.amm, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.ledgerHash);
    }

    public final ImmutableAmmInfoResult withAmm(AmmInfo value) {
        if (this.amm == value) {
            return this;
        }
        AmmInfo newValue = Objects.requireNonNull(value, "amm");
        return new ImmutableAmmInfoResult(this.status, newValue, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.ledgerHash);
    }

    public final ImmutableAmmInfoResult withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return new ImmutableAmmInfoResult(this.status, this.amm, newValue, this.ledgerCurrentIndex, this.validated, this.ledgerHash);
    }

    public final ImmutableAmmInfoResult withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableAmmInfoResult(this.status, this.amm, value, this.ledgerCurrentIndex, this.validated, this.ledgerHash);
    }

    public final ImmutableAmmInfoResult withLedgerCurrentIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        if (this.ledgerCurrentIndex == newValue) {
            return this;
        }
        return new ImmutableAmmInfoResult(this.status, this.amm, this.ledgerIndex, newValue, this.validated, this.ledgerHash);
    }

    public final ImmutableAmmInfoResult withLedgerCurrentIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        return new ImmutableAmmInfoResult(this.status, this.amm, this.ledgerIndex, value, this.validated, this.ledgerHash);
    }

    public final ImmutableAmmInfoResult withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableAmmInfoResult(this.status, this.amm, this.ledgerIndex, this.ledgerCurrentIndex, value, this.ledgerHash);
    }

    public final ImmutableAmmInfoResult withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableAmmInfoResult(this.status, this.amm, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, newValue);
    }

    public final ImmutableAmmInfoResult withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableAmmInfoResult(this.status, this.amm, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAmmInfoResult && this.equalTo(0, (ImmutableAmmInfoResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableAmmInfoResult another) {
        return Objects.equals(this.status, another.status) && this.amm.equals(another.amm) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && Objects.equals(this.ledgerCurrentIndex, another.ledgerCurrentIndex) && this.validated == another.validated && Objects.equals(this.ledgerHash, another.ledgerHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.amm.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerCurrentIndex);
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AmmInfoResult").omitNullValues().add("status", (Object)this.status).add("amm", (Object)this.amm).add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).add("validated", this.validated).add("ledgerHash", (Object)this.ledgerHash).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAmmInfoResult fromJson(Json json) {
        Builder builder = ImmutableAmmInfoResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.amm != null) {
            builder.amm(json.amm);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        return builder.build();
    }

    public static ImmutableAmmInfoResult copyOf(AmmInfoResult instance) {
        if (instance instanceof ImmutableAmmInfoResult) {
            return (ImmutableAmmInfoResult)instance;
        }
        return ImmutableAmmInfoResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AmmInfoResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AMM = 1L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private AmmInfo amm;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;
        private boolean validated;
        @Nullable
        private Hash256 ledgerHash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AmmInfoResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof AmmInfoResult) {
                Optional<LedgerIndex> ledgerCurrentIndexOptional;
                instance = (AmmInfoResult)object;
                this.amm(instance.amm());
                Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
                if (ledgerHashOptional.isPresent()) {
                    this.ledgerHash(ledgerHashOptional);
                }
                this.validated(instance.validated());
                Optional<LedgerIndex> ledgerIndexOptional = instance.ledgerIndex();
                if (ledgerIndexOptional.isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                if ((ledgerCurrentIndexOptional = instance.ledgerCurrentIndex()).isPresent()) {
                    this.ledgerCurrentIndex(ledgerCurrentIndexOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="amm")
        @CanIgnoreReturnValue
        public final Builder amm(AmmInfo amm) {
            this.amm = Objects.requireNonNull(amm, "amm");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(Optional<? extends LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex.orElse(null);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        public ImmutableAmmInfoResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAmmInfoResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("amm");
            }
            return "Cannot build AmmInfoResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AmmInfoResult", generator="Immutables")
    static final class Json
    implements AmmInfoResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        AmmInfo amm;
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerCurrentIndex = Optional.empty();
        boolean validated;
        boolean validatedIsSet;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="amm")
        public void setAmm(AmmInfo amm) {
            this.amm = amm;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(Optional<LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AmmInfo amm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }
    }
}

