/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.amm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoRequestParams;
import org.xrpl.xrpl4j.model.ledger.Issue;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AmmInfoRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAmmInfoRequestParams
implements AmmInfoRequestParams {
    @Nullable
    private final Address ammAccount;
    @Nullable
    private final Issue asset;
    @Nullable
    private final Issue asset2;

    private ImmutableAmmInfoRequestParams(@Nullable Address ammAccount, @Nullable Issue asset, @Nullable Issue asset2) {
        this.ammAccount = ammAccount;
        this.asset = asset;
        this.asset2 = asset2;
    }

    @Override
    @JsonProperty(value="amm_account")
    public Optional<Address> ammAccount() {
        return Optional.ofNullable(this.ammAccount);
    }

    @Override
    @JsonProperty(value="asset")
    public Optional<Issue> asset() {
        return Optional.ofNullable(this.asset);
    }

    @Override
    @JsonProperty(value="asset2")
    public Optional<Issue> asset2() {
        return Optional.ofNullable(this.asset2);
    }

    public final ImmutableAmmInfoRequestParams withAmmAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "ammAccount");
        if (this.ammAccount == newValue) {
            return this;
        }
        return new ImmutableAmmInfoRequestParams(newValue, this.asset, this.asset2);
    }

    public final ImmutableAmmInfoRequestParams withAmmAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.ammAccount == value) {
            return this;
        }
        return new ImmutableAmmInfoRequestParams(value, this.asset, this.asset2);
    }

    public final ImmutableAmmInfoRequestParams withAsset(Issue value) {
        Issue newValue = Objects.requireNonNull(value, "asset");
        if (this.asset == newValue) {
            return this;
        }
        return new ImmutableAmmInfoRequestParams(this.ammAccount, newValue, this.asset2);
    }

    public final ImmutableAmmInfoRequestParams withAsset(Optional<? extends Issue> optional) {
        Issue value = optional.orElse(null);
        if (this.asset == value) {
            return this;
        }
        return new ImmutableAmmInfoRequestParams(this.ammAccount, value, this.asset2);
    }

    public final ImmutableAmmInfoRequestParams withAsset2(Issue value) {
        Issue newValue = Objects.requireNonNull(value, "asset2");
        if (this.asset2 == newValue) {
            return this;
        }
        return new ImmutableAmmInfoRequestParams(this.ammAccount, this.asset, newValue);
    }

    public final ImmutableAmmInfoRequestParams withAsset2(Optional<? extends Issue> optional) {
        Issue value = optional.orElse(null);
        if (this.asset2 == value) {
            return this;
        }
        return new ImmutableAmmInfoRequestParams(this.ammAccount, this.asset, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAmmInfoRequestParams && this.equalTo(0, (ImmutableAmmInfoRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableAmmInfoRequestParams another) {
        return Objects.equals(this.ammAccount, another.ammAccount) && Objects.equals(this.asset, another.asset) && Objects.equals(this.asset2, another.asset2);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ammAccount);
        h += (h << 5) + Objects.hashCode(this.asset);
        h += (h << 5) + Objects.hashCode(this.asset2);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AmmInfoRequestParams").omitNullValues().add("ammAccount", (Object)this.ammAccount).add("asset", (Object)this.asset).add("asset2", (Object)this.asset2).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAmmInfoRequestParams fromJson(Json json) {
        Builder builder = ImmutableAmmInfoRequestParams.builder();
        if (json.ammAccount != null) {
            builder.ammAccount(json.ammAccount);
        }
        if (json.asset != null) {
            builder.asset(json.asset);
        }
        if (json.asset2 != null) {
            builder.asset2(json.asset2);
        }
        return builder.build();
    }

    public static ImmutableAmmInfoRequestParams copyOf(AmmInfoRequestParams instance) {
        if (instance instanceof ImmutableAmmInfoRequestParams) {
            return (ImmutableAmmInfoRequestParams)instance;
        }
        return ImmutableAmmInfoRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AmmInfoRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Address ammAccount;
        @Nullable
        private Issue asset;
        @Nullable
        private Issue asset2;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AmmInfoRequestParams instance) {
            Optional<Issue> asset2Optional;
            Optional<Issue> assetOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Address> ammAccountOptional = instance.ammAccount();
            if (ammAccountOptional.isPresent()) {
                this.ammAccount(ammAccountOptional);
            }
            if ((assetOptional = instance.asset()).isPresent()) {
                this.asset(assetOptional);
            }
            if ((asset2Optional = instance.asset2()).isPresent()) {
                this.asset2(asset2Optional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ammAccount(Address ammAccount) {
            this.ammAccount = Objects.requireNonNull(ammAccount, "ammAccount");
            return this;
        }

        @JsonProperty(value="amm_account")
        @CanIgnoreReturnValue
        public final Builder ammAccount(Optional<? extends Address> ammAccount) {
            this.ammAccount = ammAccount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder asset(Issue asset) {
            this.asset = Objects.requireNonNull(asset, "asset");
            return this;
        }

        @JsonProperty(value="asset")
        @CanIgnoreReturnValue
        public final Builder asset(Optional<? extends Issue> asset) {
            this.asset = asset.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder asset2(Issue asset2) {
            this.asset2 = Objects.requireNonNull(asset2, "asset2");
            return this;
        }

        @JsonProperty(value="asset2")
        @CanIgnoreReturnValue
        public final Builder asset2(Optional<? extends Issue> asset2) {
            this.asset2 = asset2.orElse(null);
            return this;
        }

        public ImmutableAmmInfoRequestParams build() {
            return new ImmutableAmmInfoRequestParams(this.ammAccount, this.asset, this.asset2);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AmmInfoRequestParams", generator="Immutables")
    static final class Json
    implements AmmInfoRequestParams {
        @Nullable
        Optional<Address> ammAccount = Optional.empty();
        @Nullable
        Optional<Issue> asset = Optional.empty();
        @Nullable
        Optional<Issue> asset2 = Optional.empty();

        Json() {
        }

        @JsonProperty(value="amm_account")
        public void setAmmAccount(Optional<Address> ammAccount) {
            this.ammAccount = ammAccount;
        }

        @JsonProperty(value="asset")
        public void setAsset(Optional<Issue> asset) {
            this.asset = asset;
        }

        @JsonProperty(value="asset2")
        public void setAsset2(Optional<Issue> asset2) {
            this.asset2 = asset2;
        }

        @Override
        public Optional<Address> ammAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Issue> asset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Issue> asset2() {
            throw new UnsupportedOperationException();
        }
    }
}

