/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.amm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoAuctionSlot;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoAuthAccount;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AmmInfoAuctionSlot", generator="Immutables")
@Immutable
public final class ImmutableAmmInfoAuctionSlot
implements AmmInfoAuctionSlot {
    private final Address account;
    private final ImmutableList<AmmInfoAuthAccount> authAccounts;
    private final TradingFee discountedFee;
    private final ZonedDateTime expiration;
    private final IssuedCurrencyAmount price;
    private final UnsignedInteger timeInterval;

    private ImmutableAmmInfoAuctionSlot(Address account, ImmutableList<AmmInfoAuthAccount> authAccounts, TradingFee discountedFee, ZonedDateTime expiration, IssuedCurrencyAmount price, UnsignedInteger timeInterval) {
        this.account = account;
        this.authAccounts = authAccounts;
        this.discountedFee = discountedFee;
        this.expiration = expiration;
        this.price = price;
        this.timeInterval = timeInterval;
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @JsonProperty(value="auth_accounts")
    public ImmutableList<AmmInfoAuthAccount> authAccounts() {
        return this.authAccounts;
    }

    @Override
    @JsonProperty(value="discounted_fee")
    public TradingFee discountedFee() {
        return this.discountedFee;
    }

    @Override
    @JsonProperty(value="expiration")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ssZ", locale="en_US")
    public ZonedDateTime expiration() {
        return this.expiration;
    }

    @Override
    @JsonProperty(value="price")
    public IssuedCurrencyAmount price() {
        return this.price;
    }

    @Override
    @JsonProperty(value="time_interval")
    public UnsignedInteger timeInterval() {
        return this.timeInterval;
    }

    public final ImmutableAmmInfoAuctionSlot withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAmmInfoAuctionSlot(newValue, this.authAccounts, this.discountedFee, this.expiration, this.price, this.timeInterval);
    }

    public final ImmutableAmmInfoAuctionSlot withAuthAccounts(AmmInfoAuthAccount ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAmmInfoAuctionSlot(this.account, (ImmutableList<AmmInfoAuthAccount>)newValue, this.discountedFee, this.expiration, this.price, this.timeInterval);
    }

    public final ImmutableAmmInfoAuctionSlot withAuthAccounts(Iterable<? extends AmmInfoAuthAccount> elements) {
        if (this.authAccounts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAmmInfoAuctionSlot(this.account, (ImmutableList<AmmInfoAuthAccount>)newValue, this.discountedFee, this.expiration, this.price, this.timeInterval);
    }

    public final ImmutableAmmInfoAuctionSlot withDiscountedFee(TradingFee value) {
        if (this.discountedFee == value) {
            return this;
        }
        TradingFee newValue = Objects.requireNonNull(value, "discountedFee");
        return new ImmutableAmmInfoAuctionSlot(this.account, this.authAccounts, newValue, this.expiration, this.price, this.timeInterval);
    }

    public final ImmutableAmmInfoAuctionSlot withExpiration(ZonedDateTime value) {
        if (this.expiration == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "expiration");
        return new ImmutableAmmInfoAuctionSlot(this.account, this.authAccounts, this.discountedFee, newValue, this.price, this.timeInterval);
    }

    public final ImmutableAmmInfoAuctionSlot withPrice(IssuedCurrencyAmount value) {
        if (this.price == value) {
            return this;
        }
        IssuedCurrencyAmount newValue = Objects.requireNonNull(value, "price");
        return new ImmutableAmmInfoAuctionSlot(this.account, this.authAccounts, this.discountedFee, this.expiration, newValue, this.timeInterval);
    }

    public final ImmutableAmmInfoAuctionSlot withTimeInterval(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "timeInterval");
        if (this.timeInterval.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAmmInfoAuctionSlot(this.account, this.authAccounts, this.discountedFee, this.expiration, this.price, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAmmInfoAuctionSlot && this.equalTo(0, (ImmutableAmmInfoAuctionSlot)another);
    }

    private boolean equalTo(int synthetic, ImmutableAmmInfoAuctionSlot another) {
        return this.account.equals(another.account) && this.authAccounts.equals(another.authAccounts) && this.discountedFee.equals(another.discountedFee) && this.expiration.equals(another.expiration) && this.price.equals(another.price) && this.timeInterval.equals((Object)another.timeInterval);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.authAccounts.hashCode();
        h += (h << 5) + this.discountedFee.hashCode();
        h += (h << 5) + this.expiration.hashCode();
        h += (h << 5) + this.price.hashCode();
        h += (h << 5) + this.timeInterval.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AmmInfoAuctionSlot").omitNullValues().add("account", (Object)this.account).add("authAccounts", this.authAccounts).add("discountedFee", (Object)this.discountedFee).add("expiration", (Object)this.expiration).add("price", (Object)this.price).add("timeInterval", (Object)this.timeInterval).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAmmInfoAuctionSlot fromJson(Json json) {
        Builder builder = ImmutableAmmInfoAuctionSlot.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.authAccounts != null) {
            builder.addAllAuthAccounts(json.authAccounts);
        }
        if (json.discountedFee != null) {
            builder.discountedFee(json.discountedFee);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        if (json.price != null) {
            builder.price(json.price);
        }
        if (json.timeInterval != null) {
            builder.timeInterval(json.timeInterval);
        }
        return builder.build();
    }

    public static ImmutableAmmInfoAuctionSlot copyOf(AmmInfoAuctionSlot instance) {
        if (instance instanceof ImmutableAmmInfoAuctionSlot) {
            return (ImmutableAmmInfoAuctionSlot)instance;
        }
        return ImmutableAmmInfoAuctionSlot.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AmmInfoAuctionSlot", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_DISCOUNTED_FEE = 2L;
        private static final long INIT_BIT_EXPIRATION = 4L;
        private static final long INIT_BIT_PRICE = 8L;
        private static final long INIT_BIT_TIME_INTERVAL = 16L;
        private long initBits = 31L;
        @Nullable
        private Address account;
        private ImmutableList.Builder<AmmInfoAuthAccount> authAccounts = ImmutableList.builder();
        @Nullable
        private TradingFee discountedFee;
        @Nullable
        private ZonedDateTime expiration;
        @Nullable
        private IssuedCurrencyAmount price;
        @Nullable
        private UnsignedInteger timeInterval;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AmmInfoAuctionSlot instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.addAllAuthAccounts(instance.authAccounts());
            this.discountedFee(instance.discountedFee());
            this.expiration(instance.expiration());
            this.price(instance.price());
            this.timeInterval(instance.timeInterval());
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAuthAccounts(AmmInfoAuthAccount element) {
            this.authAccounts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAuthAccounts(AmmInfoAuthAccount ... elements) {
            this.authAccounts.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="auth_accounts")
        @CanIgnoreReturnValue
        public final Builder authAccounts(Iterable<? extends AmmInfoAuthAccount> elements) {
            this.authAccounts = ImmutableList.builder();
            return this.addAllAuthAccounts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAuthAccounts(Iterable<? extends AmmInfoAuthAccount> elements) {
            this.authAccounts.addAll(elements);
            return this;
        }

        @JsonProperty(value="discounted_fee")
        @CanIgnoreReturnValue
        public final Builder discountedFee(TradingFee discountedFee) {
            this.discountedFee = Objects.requireNonNull(discountedFee, "discountedFee");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="expiration")
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ssZ", locale="en_US")
        @CanIgnoreReturnValue
        public final Builder expiration(ZonedDateTime expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="price")
        @CanIgnoreReturnValue
        public final Builder price(IssuedCurrencyAmount price) {
            this.price = Objects.requireNonNull(price, "price");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="time_interval")
        @CanIgnoreReturnValue
        public final Builder timeInterval(UnsignedInteger timeInterval) {
            this.timeInterval = Objects.requireNonNull(timeInterval, "timeInterval");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableAmmInfoAuctionSlot build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAmmInfoAuctionSlot(this.account, this.authAccounts.build(), this.discountedFee, this.expiration, this.price, this.timeInterval);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("discountedFee");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("expiration");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("price");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("timeInterval");
            }
            return "Cannot build AmmInfoAuctionSlot, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AmmInfoAuctionSlot", generator="Immutables")
    static final class Json
    implements AmmInfoAuctionSlot {
        @Nullable
        Address account;
        @Nullable
        List<AmmInfoAuthAccount> authAccounts = ImmutableList.of();
        @Nullable
        TradingFee discountedFee;
        @Nullable
        ZonedDateTime expiration;
        @Nullable
        IssuedCurrencyAmount price;
        @Nullable
        UnsignedInteger timeInterval;

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="auth_accounts")
        public void setAuthAccounts(List<AmmInfoAuthAccount> authAccounts) {
            this.authAccounts = authAccounts;
        }

        @JsonProperty(value="discounted_fee")
        public void setDiscountedFee(TradingFee discountedFee) {
            this.discountedFee = discountedFee;
        }

        @JsonProperty(value="expiration")
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ssZ", locale="en_US")
        public void setExpiration(ZonedDateTime expiration) {
            this.expiration = expiration;
        }

        @JsonProperty(value="price")
        public void setPrice(IssuedCurrencyAmount price) {
            this.price = price;
        }

        @JsonProperty(value="time_interval")
        public void setTimeInterval(UnsignedInteger timeInterval) {
            this.timeInterval = timeInterval;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AmmInfoAuthAccount> authAccounts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TradingFee discountedFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime expiration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IssuedCurrencyAmount price() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger timeInterval() {
            throw new UnsupportedOperationException();
        }
    }
}

