/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.amm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.amm.AmmInfo;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoAuctionSlot;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoVoteEntry;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AmmInfo", generator="Immutables")
@Immutable
public final class ImmutableAmmInfo
implements AmmInfo {
    @Nullable
    private final String status;
    private final Address account;
    private final CurrencyAmount amount;
    private final CurrencyAmount amount2;
    private final boolean assetFrozen;
    private final boolean asset2Frozen;
    @Nullable
    private final AmmInfoAuctionSlot auctionSlot;
    private final IssuedCurrencyAmount lpToken;
    private final TradingFee tradingFee;
    private final ImmutableList<AmmInfoVoteEntry> voteSlots;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAmmInfo(Builder builder) {
        this.status = builder.status;
        this.account = builder.account;
        this.amount = builder.amount;
        this.amount2 = builder.amount2;
        this.auctionSlot = builder.auctionSlot;
        this.lpToken = builder.lpToken;
        this.tradingFee = builder.tradingFee;
        this.voteSlots = builder.voteSlots.build();
        if (builder.assetFrozenIsSet()) {
            this.initShim.assetFrozen(builder.assetFrozen);
        }
        if (builder.asset2FrozenIsSet()) {
            this.initShim.asset2Frozen(builder.asset2Frozen);
        }
        this.assetFrozen = this.initShim.assetFrozen();
        this.asset2Frozen = this.initShim.asset2Frozen();
        this.initShim = null;
    }

    private ImmutableAmmInfo(@Nullable String status, Address account, CurrencyAmount amount, CurrencyAmount amount2, boolean assetFrozen, boolean asset2Frozen, @Nullable AmmInfoAuctionSlot auctionSlot, IssuedCurrencyAmount lpToken, TradingFee tradingFee, ImmutableList<AmmInfoVoteEntry> voteSlots) {
        this.status = status;
        this.account = account;
        this.amount = amount;
        this.amount2 = amount2;
        this.assetFrozen = assetFrozen;
        this.asset2Frozen = asset2Frozen;
        this.auctionSlot = auctionSlot;
        this.lpToken = lpToken;
        this.tradingFee = tradingFee;
        this.voteSlots = voteSlots;
        this.initShim = null;
    }

    private boolean assetFrozenInitialize() {
        return AmmInfo.super.assetFrozen();
    }

    private boolean asset2FrozenInitialize() {
        return AmmInfo.super.asset2Frozen();
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="amount")
    public CurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="amount2")
    public CurrencyAmount amount2() {
        return this.amount2;
    }

    @Override
    @JsonProperty(value="asset_frozen")
    public boolean assetFrozen() {
        InitShim shim = this.initShim;
        return shim != null ? shim.assetFrozen() : this.assetFrozen;
    }

    @Override
    @JsonProperty(value="asset2_frozen")
    public boolean asset2Frozen() {
        InitShim shim = this.initShim;
        return shim != null ? shim.asset2Frozen() : this.asset2Frozen;
    }

    @Override
    @JsonProperty(value="auction_slot")
    public Optional<AmmInfoAuctionSlot> auctionSlot() {
        return Optional.ofNullable(this.auctionSlot);
    }

    @Override
    @JsonProperty(value="lp_token")
    public IssuedCurrencyAmount lpToken() {
        return this.lpToken;
    }

    @Override
    @JsonProperty(value="trading_fee")
    public TradingFee tradingFee() {
        return this.tradingFee;
    }

    @JsonProperty(value="vote_slots")
    public ImmutableList<AmmInfoVoteEntry> voteSlots() {
        return this.voteSlots;
    }

    public final ImmutableAmmInfo withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableAmmInfo(newValue, this.account, this.amount, this.amount2, this.assetFrozen, this.asset2Frozen, this.auctionSlot, this.lpToken, this.tradingFee, this.voteSlots);
    }

    public final ImmutableAmmInfo withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableAmmInfo(value, this.account, this.amount, this.amount2, this.assetFrozen, this.asset2Frozen, this.auctionSlot, this.lpToken, this.tradingFee, this.voteSlots);
    }

    public final ImmutableAmmInfo withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAmmInfo(this.status, newValue, this.amount, this.amount2, this.assetFrozen, this.asset2Frozen, this.auctionSlot, this.lpToken, this.tradingFee, this.voteSlots);
    }

    public final ImmutableAmmInfo withAmount(CurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutableAmmInfo(this.status, this.account, newValue, this.amount2, this.assetFrozen, this.asset2Frozen, this.auctionSlot, this.lpToken, this.tradingFee, this.voteSlots);
    }

    public final ImmutableAmmInfo withAmount2(CurrencyAmount value) {
        if (this.amount2 == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount2");
        return new ImmutableAmmInfo(this.status, this.account, this.amount, newValue, this.assetFrozen, this.asset2Frozen, this.auctionSlot, this.lpToken, this.tradingFee, this.voteSlots);
    }

    public final ImmutableAmmInfo withAssetFrozen(boolean value) {
        if (this.assetFrozen == value) {
            return this;
        }
        return new ImmutableAmmInfo(this.status, this.account, this.amount, this.amount2, value, this.asset2Frozen, this.auctionSlot, this.lpToken, this.tradingFee, this.voteSlots);
    }

    public final ImmutableAmmInfo withAsset2Frozen(boolean value) {
        if (this.asset2Frozen == value) {
            return this;
        }
        return new ImmutableAmmInfo(this.status, this.account, this.amount, this.amount2, this.assetFrozen, value, this.auctionSlot, this.lpToken, this.tradingFee, this.voteSlots);
    }

    public final ImmutableAmmInfo withAuctionSlot(AmmInfoAuctionSlot value) {
        AmmInfoAuctionSlot newValue = Objects.requireNonNull(value, "auctionSlot");
        if (this.auctionSlot == newValue) {
            return this;
        }
        return new ImmutableAmmInfo(this.status, this.account, this.amount, this.amount2, this.assetFrozen, this.asset2Frozen, newValue, this.lpToken, this.tradingFee, this.voteSlots);
    }

    public final ImmutableAmmInfo withAuctionSlot(Optional<? extends AmmInfoAuctionSlot> optional) {
        AmmInfoAuctionSlot value = optional.orElse(null);
        if (this.auctionSlot == value) {
            return this;
        }
        return new ImmutableAmmInfo(this.status, this.account, this.amount, this.amount2, this.assetFrozen, this.asset2Frozen, value, this.lpToken, this.tradingFee, this.voteSlots);
    }

    public final ImmutableAmmInfo withLpToken(IssuedCurrencyAmount value) {
        if (this.lpToken == value) {
            return this;
        }
        IssuedCurrencyAmount newValue = Objects.requireNonNull(value, "lpToken");
        return new ImmutableAmmInfo(this.status, this.account, this.amount, this.amount2, this.assetFrozen, this.asset2Frozen, this.auctionSlot, newValue, this.tradingFee, this.voteSlots);
    }

    public final ImmutableAmmInfo withTradingFee(TradingFee value) {
        if (this.tradingFee == value) {
            return this;
        }
        TradingFee newValue = Objects.requireNonNull(value, "tradingFee");
        return new ImmutableAmmInfo(this.status, this.account, this.amount, this.amount2, this.assetFrozen, this.asset2Frozen, this.auctionSlot, this.lpToken, newValue, this.voteSlots);
    }

    public final ImmutableAmmInfo withVoteSlots(AmmInfoVoteEntry ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAmmInfo(this.status, this.account, this.amount, this.amount2, this.assetFrozen, this.asset2Frozen, this.auctionSlot, this.lpToken, this.tradingFee, (ImmutableList<AmmInfoVoteEntry>)newValue);
    }

    public final ImmutableAmmInfo withVoteSlots(Iterable<? extends AmmInfoVoteEntry> elements) {
        if (this.voteSlots == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAmmInfo(this.status, this.account, this.amount, this.amount2, this.assetFrozen, this.asset2Frozen, this.auctionSlot, this.lpToken, this.tradingFee, (ImmutableList<AmmInfoVoteEntry>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAmmInfo && this.equalTo(0, (ImmutableAmmInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableAmmInfo another) {
        return Objects.equals(this.status, another.status) && this.account.equals(another.account) && this.amount.equals(another.amount) && this.amount2.equals(another.amount2) && this.assetFrozen == another.assetFrozen && this.asset2Frozen == another.asset2Frozen && Objects.equals(this.auctionSlot, another.auctionSlot) && this.lpToken.equals(another.lpToken) && this.tradingFee.equals(another.tradingFee) && this.voteSlots.equals(another.voteSlots);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.amount2.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.assetFrozen);
        h += (h << 5) + Booleans.hashCode((boolean)this.asset2Frozen);
        h += (h << 5) + Objects.hashCode(this.auctionSlot);
        h += (h << 5) + this.lpToken.hashCode();
        h += (h << 5) + this.tradingFee.hashCode();
        h += (h << 5) + this.voteSlots.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AmmInfo").omitNullValues().add("status", (Object)this.status).add("account", (Object)this.account).add("amount", (Object)this.amount).add("amount2", (Object)this.amount2).add("assetFrozen", this.assetFrozen).add("asset2Frozen", this.asset2Frozen).add("auctionSlot", (Object)this.auctionSlot).add("lpToken", (Object)this.lpToken).add("tradingFee", (Object)this.tradingFee).add("voteSlots", this.voteSlots).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAmmInfo fromJson(Json json) {
        Builder builder = ImmutableAmmInfo.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.amount2 != null) {
            builder.amount2(json.amount2);
        }
        if (json.assetFrozenIsSet) {
            builder.assetFrozen(json.assetFrozen);
        }
        if (json.asset2FrozenIsSet) {
            builder.asset2Frozen(json.asset2Frozen);
        }
        if (json.auctionSlot != null) {
            builder.auctionSlot(json.auctionSlot);
        }
        if (json.lpToken != null) {
            builder.lpToken(json.lpToken);
        }
        if (json.tradingFee != null) {
            builder.tradingFee(json.tradingFee);
        }
        if (json.voteSlots != null) {
            builder.addAllVoteSlots(json.voteSlots);
        }
        return builder.build();
    }

    public static ImmutableAmmInfo copyOf(AmmInfo instance) {
        if (instance instanceof ImmutableAmmInfo) {
            return (ImmutableAmmInfo)instance;
        }
        return ImmutableAmmInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AmmInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_AMOUNT = 2L;
        private static final long INIT_BIT_AMOUNT2 = 4L;
        private static final long INIT_BIT_LP_TOKEN = 8L;
        private static final long INIT_BIT_TRADING_FEE = 16L;
        private static final long OPT_BIT_ASSET_FROZEN = 1L;
        private static final long OPT_BIT_ASSET2_FROZEN = 2L;
        private long initBits = 31L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private Address account;
        @Nullable
        private CurrencyAmount amount;
        @Nullable
        private CurrencyAmount amount2;
        private boolean assetFrozen;
        private boolean asset2Frozen;
        @Nullable
        private AmmInfoAuctionSlot auctionSlot;
        @Nullable
        private IssuedCurrencyAmount lpToken;
        @Nullable
        private TradingFee tradingFee;
        private ImmutableList.Builder<AmmInfoVoteEntry> voteSlots = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AmmInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof AmmInfo) {
                instance = (AmmInfo)object;
                this.amount(instance.amount());
                Optional<AmmInfoAuctionSlot> auctionSlotOptional = instance.auctionSlot();
                if (auctionSlotOptional.isPresent()) {
                    this.auctionSlot(auctionSlotOptional);
                }
                this.amount2(instance.amount2());
                this.asset2Frozen(instance.asset2Frozen());
                this.addAllVoteSlots(instance.voteSlots());
                this.lpToken(instance.lpToken());
                this.tradingFee(instance.tradingFee());
                this.assetFrozen(instance.assetFrozen());
                this.account(instance.account());
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="amount")
        @CanIgnoreReturnValue
        public final Builder amount(CurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="amount2")
        @CanIgnoreReturnValue
        public final Builder amount2(CurrencyAmount amount2) {
            this.amount2 = Objects.requireNonNull(amount2, "amount2");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="asset_frozen")
        @CanIgnoreReturnValue
        public final Builder assetFrozen(boolean assetFrozen) {
            this.assetFrozen = assetFrozen;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="asset2_frozen")
        @CanIgnoreReturnValue
        public final Builder asset2Frozen(boolean asset2Frozen) {
            this.asset2Frozen = asset2Frozen;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auctionSlot(AmmInfoAuctionSlot auctionSlot) {
            this.auctionSlot = Objects.requireNonNull(auctionSlot, "auctionSlot");
            return this;
        }

        @JsonProperty(value="auction_slot")
        @CanIgnoreReturnValue
        public final Builder auctionSlot(Optional<? extends AmmInfoAuctionSlot> auctionSlot) {
            this.auctionSlot = auctionSlot.orElse(null);
            return this;
        }

        @JsonProperty(value="lp_token")
        @CanIgnoreReturnValue
        public final Builder lpToken(IssuedCurrencyAmount lpToken) {
            this.lpToken = Objects.requireNonNull(lpToken, "lpToken");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="trading_fee")
        @CanIgnoreReturnValue
        public final Builder tradingFee(TradingFee tradingFee) {
            this.tradingFee = Objects.requireNonNull(tradingFee, "tradingFee");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVoteSlots(AmmInfoVoteEntry element) {
            this.voteSlots.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVoteSlots(AmmInfoVoteEntry ... elements) {
            this.voteSlots.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="vote_slots")
        @CanIgnoreReturnValue
        public final Builder voteSlots(Iterable<? extends AmmInfoVoteEntry> elements) {
            this.voteSlots = ImmutableList.builder();
            return this.addAllVoteSlots(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllVoteSlots(Iterable<? extends AmmInfoVoteEntry> elements) {
            this.voteSlots.addAll(elements);
            return this;
        }

        public ImmutableAmmInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAmmInfo(this);
        }

        private boolean assetFrozenIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean asset2FrozenIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("amount2");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lpToken");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("tradingFee");
            }
            return "Cannot build AmmInfo, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="AmmInfo", generator="Immutables")
    private final class InitShim {
        private byte assetFrozenBuildStage = 0;
        private boolean assetFrozen;
        private byte asset2FrozenBuildStage = 0;
        private boolean asset2Frozen;

        private InitShim() {
        }

        boolean assetFrozen() {
            if (this.assetFrozenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.assetFrozenBuildStage == 0) {
                this.assetFrozenBuildStage = (byte)-1;
                this.assetFrozen = ImmutableAmmInfo.this.assetFrozenInitialize();
                this.assetFrozenBuildStage = 1;
            }
            return this.assetFrozen;
        }

        void assetFrozen(boolean assetFrozen) {
            this.assetFrozen = assetFrozen;
            this.assetFrozenBuildStage = 1;
        }

        boolean asset2Frozen() {
            if (this.asset2FrozenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.asset2FrozenBuildStage == 0) {
                this.asset2FrozenBuildStage = (byte)-1;
                this.asset2Frozen = ImmutableAmmInfo.this.asset2FrozenInitialize();
                this.asset2FrozenBuildStage = 1;
            }
            return this.asset2Frozen;
        }

        void asset2Frozen(boolean asset2Frozen) {
            this.asset2Frozen = asset2Frozen;
            this.asset2FrozenBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.assetFrozenBuildStage == -1) {
                attributes.add("assetFrozen");
            }
            if (this.asset2FrozenBuildStage == -1) {
                attributes.add("asset2Frozen");
            }
            return "Cannot build AmmInfo, attribute initializers form cycle " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AmmInfo", generator="Immutables")
    static final class Json
    implements AmmInfo {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        Address account;
        @Nullable
        CurrencyAmount amount;
        @Nullable
        CurrencyAmount amount2;
        boolean assetFrozen;
        boolean assetFrozenIsSet;
        boolean asset2Frozen;
        boolean asset2FrozenIsSet;
        @Nullable
        Optional<AmmInfoAuctionSlot> auctionSlot = Optional.empty();
        @Nullable
        IssuedCurrencyAmount lpToken;
        @Nullable
        TradingFee tradingFee;
        @Nullable
        List<AmmInfoVoteEntry> voteSlots = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="amount")
        public void setAmount(CurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="amount2")
        public void setAmount2(CurrencyAmount amount2) {
            this.amount2 = amount2;
        }

        @JsonProperty(value="asset_frozen")
        public void setAssetFrozen(boolean assetFrozen) {
            this.assetFrozen = assetFrozen;
            this.assetFrozenIsSet = true;
        }

        @JsonProperty(value="asset2_frozen")
        public void setAsset2Frozen(boolean asset2Frozen) {
            this.asset2Frozen = asset2Frozen;
            this.asset2FrozenIsSet = true;
        }

        @JsonProperty(value="auction_slot")
        public void setAuctionSlot(Optional<AmmInfoAuctionSlot> auctionSlot) {
            this.auctionSlot = auctionSlot;
        }

        @JsonProperty(value="lp_token")
        public void setLpToken(IssuedCurrencyAmount lpToken) {
            this.lpToken = lpToken;
        }

        @JsonProperty(value="trading_fee")
        public void setTradingFee(TradingFee tradingFee) {
            this.tradingFee = tradingFee;
        }

        @JsonProperty(value="vote_slots")
        public void setVoteSlots(List<AmmInfoVoteEntry> voteSlots) {
            this.voteSlots = voteSlots;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount amount2() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean assetFrozen() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean asset2Frozen() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<AmmInfoAuctionSlot> auctionSlot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IssuedCurrencyAmount lpToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TradingFee tradingFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AmmInfoVoteEntry> voteSlots() {
            throw new UnsupportedOperationException();
        }
    }
}

