/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.amm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.amm.AmmInfo;
import org.xrpl.xrpl4j.model.client.amm.ImmutableAmmInfoResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableAmmInfoResult.class)
@JsonDeserialize(as=ImmutableAmmInfoResult.class)
@Value.Immutable
@Beta
public interface AmmInfoResult
extends XrplResult {
    public static ImmutableAmmInfoResult.Builder builder() {
        return ImmutableAmmInfoResult.builder();
    }

    @JsonProperty(value="amm")
    public AmmInfo amm();

    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex();

    @JsonIgnore
    @Value.Auxiliary
    default public LedgerIndex ledgerIndexSafe() {
        return this.ledgerIndex().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerIndex."));
    }

    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex();

    @JsonIgnore
    @Value.Auxiliary
    default public LedgerIndex ledgerCurrentIndexSafe() {
        return this.ledgerCurrentIndex().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerCurrentIndex."));
    }

    @Value.Default
    default public boolean validated() {
        return false;
    }

    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash();

    @JsonIgnore
    @Value.Auxiliary
    default public Hash256 ledgerHashSafe() {
        return this.ledgerHash().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerHash."));
    }
}

