/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.amm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoAuctionSlot;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoVoteEntry;
import org.xrpl.xrpl4j.model.client.amm.ImmutableAmmInfo;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;

@JsonSerialize(as=ImmutableAmmInfo.class)
@JsonDeserialize(as=ImmutableAmmInfo.class)
@Value.Immutable
@Beta
public interface AmmInfo
extends XrplResult {
    public static ImmutableAmmInfo.Builder builder() {
        return ImmutableAmmInfo.builder();
    }

    @JsonProperty(value="account")
    public Address account();

    @JsonProperty(value="amount")
    public CurrencyAmount amount();

    @JsonProperty(value="amount2")
    public CurrencyAmount amount2();

    @JsonProperty(value="asset_frozen")
    @Value.Default
    default public boolean assetFrozen() {
        return false;
    }

    @JsonProperty(value="asset2_frozen")
    @Value.Default
    default public boolean asset2Frozen() {
        return false;
    }

    @JsonProperty(value="auction_slot")
    public Optional<AmmInfoAuctionSlot> auctionSlot();

    @JsonProperty(value="lp_token")
    public IssuedCurrencyAmount lpToken();

    @JsonProperty(value="trading_fee")
    public TradingFee tradingFee();

    @JsonProperty(value="vote_slots")
    public List<AmmInfoVoteEntry> voteSlots();
}

