/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.accounts.ImmutablePaymentChannelResultObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@JsonSerialize(as=ImmutablePaymentChannelResultObject.class)
@JsonDeserialize(as=ImmutablePaymentChannelResultObject.class)
@Value.Immutable
public interface PaymentChannelResultObject {
    public static ImmutablePaymentChannelResultObject.Builder builder() {
        return ImmutablePaymentChannelResultObject.builder();
    }

    public Address account();

    public XrpCurrencyAmount amount();

    public XrpCurrencyAmount balance();

    @JsonProperty(value="channel_id")
    public Hash256 channelId();

    @JsonProperty(value="destination_account")
    public Address destinationAccount();

    @JsonProperty(value="settle_delay")
    public UnsignedInteger settleDelay();

    @JsonProperty(value="public_key")
    public Optional<String> publicKey();

    @JsonProperty(value="public_key_hex")
    public Optional<String> publicKeyHex();

    public Optional<UnsignedLong> expiration();

    @JsonProperty(value="cancel_after")
    public Optional<UnsignedLong> cancelAfter();

    @JsonProperty(value="source_tag")
    public Optional<UnsignedInteger> sourceTag();

    @JsonProperty(value="destination_tag")
    public Optional<UnsignedInteger> destinationTag();
}

