/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.QueueTransaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="QueueTransaction", generator="Immutables")
@Immutable
public final class ImmutableQueueTransaction
implements QueueTransaction {
    private final boolean authChange;
    private final XrpCurrencyAmount fee;
    private final XrpCurrencyAmount feeLevel;
    private final XrpCurrencyAmount maxSpendDrops;
    private final UnsignedInteger sequence;

    private ImmutableQueueTransaction(boolean authChange, XrpCurrencyAmount fee, XrpCurrencyAmount feeLevel, XrpCurrencyAmount maxSpendDrops, UnsignedInteger sequence) {
        this.authChange = authChange;
        this.fee = fee;
        this.feeLevel = feeLevel;
        this.maxSpendDrops = maxSpendDrops;
        this.sequence = sequence;
    }

    @Override
    @JsonProperty(value="auth_change")
    public boolean authChange() {
        return this.authChange;
    }

    @Override
    @JsonProperty(value="fee")
    public XrpCurrencyAmount fee() {
        return this.fee;
    }

    @Override
    @JsonProperty(value="fee_level")
    public XrpCurrencyAmount feeLevel() {
        return this.feeLevel;
    }

    @Override
    @JsonProperty(value="max_spend_drops")
    public XrpCurrencyAmount maxSpendDrops() {
        return this.maxSpendDrops;
    }

    @Override
    @JsonProperty(value="seq")
    public UnsignedInteger sequence() {
        return this.sequence;
    }

    public final ImmutableQueueTransaction withAuthChange(boolean value) {
        if (this.authChange == value) {
            return this;
        }
        return new ImmutableQueueTransaction(value, this.fee, this.feeLevel, this.maxSpendDrops, this.sequence);
    }

    public final ImmutableQueueTransaction withFee(XrpCurrencyAmount value) {
        if (this.fee == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "fee");
        return new ImmutableQueueTransaction(this.authChange, newValue, this.feeLevel, this.maxSpendDrops, this.sequence);
    }

    public final ImmutableQueueTransaction withFeeLevel(XrpCurrencyAmount value) {
        if (this.feeLevel == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "feeLevel");
        return new ImmutableQueueTransaction(this.authChange, this.fee, newValue, this.maxSpendDrops, this.sequence);
    }

    public final ImmutableQueueTransaction withMaxSpendDrops(XrpCurrencyAmount value) {
        if (this.maxSpendDrops == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "maxSpendDrops");
        return new ImmutableQueueTransaction(this.authChange, this.fee, this.feeLevel, newValue, this.sequence);
    }

    public final ImmutableQueueTransaction withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (this.sequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableQueueTransaction(this.authChange, this.fee, this.feeLevel, this.maxSpendDrops, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueueTransaction && this.equalTo(0, (ImmutableQueueTransaction)another);
    }

    private boolean equalTo(int synthetic, ImmutableQueueTransaction another) {
        return this.authChange == another.authChange && this.fee.equals(another.fee) && this.feeLevel.equals(another.feeLevel) && this.maxSpendDrops.equals(another.maxSpendDrops) && this.sequence.equals((Object)another.sequence);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.authChange);
        h += (h << 5) + this.fee.hashCode();
        h += (h << 5) + this.feeLevel.hashCode();
        h += (h << 5) + this.maxSpendDrops.hashCode();
        h += (h << 5) + this.sequence.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QueueTransaction").omitNullValues().add("authChange", this.authChange).add("fee", (Object)this.fee).add("feeLevel", (Object)this.feeLevel).add("maxSpendDrops", (Object)this.maxSpendDrops).add("sequence", (Object)this.sequence).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableQueueTransaction fromJson(Json json) {
        Builder builder = ImmutableQueueTransaction.builder();
        if (json.authChangeIsSet) {
            builder.authChange(json.authChange);
        }
        if (json.fee != null) {
            builder.fee(json.fee);
        }
        if (json.feeLevel != null) {
            builder.feeLevel(json.feeLevel);
        }
        if (json.maxSpendDrops != null) {
            builder.maxSpendDrops(json.maxSpendDrops);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        return builder.build();
    }

    public static ImmutableQueueTransaction copyOf(QueueTransaction instance) {
        if (instance instanceof ImmutableQueueTransaction) {
            return (ImmutableQueueTransaction)instance;
        }
        return ImmutableQueueTransaction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QueueTransaction", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AUTH_CHANGE = 1L;
        private static final long INIT_BIT_FEE = 2L;
        private static final long INIT_BIT_FEE_LEVEL = 4L;
        private static final long INIT_BIT_MAX_SPEND_DROPS = 8L;
        private static final long INIT_BIT_SEQUENCE = 16L;
        private long initBits = 31L;
        private boolean authChange;
        @Nullable
        private XrpCurrencyAmount fee;
        @Nullable
        private XrpCurrencyAmount feeLevel;
        @Nullable
        private XrpCurrencyAmount maxSpendDrops;
        @Nullable
        private UnsignedInteger sequence;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QueueTransaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.authChange(instance.authChange());
            this.fee(instance.fee());
            this.feeLevel(instance.feeLevel());
            this.maxSpendDrops(instance.maxSpendDrops());
            this.sequence(instance.sequence());
            return this;
        }

        @JsonProperty(value="auth_change")
        @CanIgnoreReturnValue
        public final Builder authChange(boolean authChange) {
            this.authChange = authChange;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="fee")
        @CanIgnoreReturnValue
        public final Builder fee(XrpCurrencyAmount fee) {
            this.fee = Objects.requireNonNull(fee, "fee");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="fee_level")
        @CanIgnoreReturnValue
        public final Builder feeLevel(XrpCurrencyAmount feeLevel) {
            this.feeLevel = Objects.requireNonNull(feeLevel, "feeLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="max_spend_drops")
        @CanIgnoreReturnValue
        public final Builder maxSpendDrops(XrpCurrencyAmount maxSpendDrops) {
            this.maxSpendDrops = Objects.requireNonNull(maxSpendDrops, "maxSpendDrops");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="seq")
        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableQueueTransaction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueueTransaction(this.authChange, this.fee, this.feeLevel, this.maxSpendDrops, this.sequence);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authChange");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fee");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("feeLevel");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("maxSpendDrops");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("sequence");
            }
            return "Cannot build QueueTransaction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="QueueTransaction", generator="Immutables")
    static final class Json
    implements QueueTransaction {
        boolean authChange;
        boolean authChangeIsSet;
        @Nullable
        XrpCurrencyAmount fee;
        @Nullable
        XrpCurrencyAmount feeLevel;
        @Nullable
        XrpCurrencyAmount maxSpendDrops;
        @Nullable
        UnsignedInteger sequence;

        Json() {
        }

        @JsonProperty(value="auth_change")
        public void setAuthChange(boolean authChange) {
            this.authChange = authChange;
            this.authChangeIsSet = true;
        }

        @JsonProperty(value="fee")
        public void setFee(XrpCurrencyAmount fee) {
            this.fee = fee;
        }

        @JsonProperty(value="fee_level")
        public void setFeeLevel(XrpCurrencyAmount feeLevel) {
            this.feeLevel = feeLevel;
        }

        @JsonProperty(value="max_spend_drops")
        public void setMaxSpendDrops(XrpCurrencyAmount maxSpendDrops) {
            this.maxSpendDrops = maxSpendDrops;
        }

        @JsonProperty(value="seq")
        public void setSequence(UnsignedInteger sequence) {
            this.sequence = sequence;
        }

        @Override
        public boolean authChange() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount fee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount feeLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount maxSpendDrops() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger sequence() {
            throw new UnsupportedOperationException();
        }
    }
}

