/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.OfferResultObject;
import org.xrpl.xrpl4j.model.flags.OfferCreateFlags;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OfferResultObject", generator="Immutables")
@Immutable
public final class ImmutableOfferResultObject
implements OfferResultObject {
    @Nullable
    private final String status;
    private final OfferCreateFlags flags;
    private final UnsignedInteger seq;
    private final CurrencyAmount takerGets;
    private final CurrencyAmount takerPays;
    private final String quality;
    @Nullable
    private final UnsignedInteger expiration;

    private ImmutableOfferResultObject(@Nullable String status, OfferCreateFlags flags, UnsignedInteger seq, CurrencyAmount takerGets, CurrencyAmount takerPays, String quality, @Nullable UnsignedInteger expiration) {
        this.status = status;
        this.flags = flags;
        this.seq = seq;
        this.takerGets = takerGets;
        this.takerPays = takerPays;
        this.quality = quality;
        this.expiration = expiration;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="flags")
    public OfferCreateFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="seq")
    public UnsignedInteger seq() {
        return this.seq;
    }

    @Override
    @JsonProperty(value="taker_gets")
    public CurrencyAmount takerGets() {
        return this.takerGets;
    }

    @Override
    @JsonProperty(value="taker_pays")
    public CurrencyAmount takerPays() {
        return this.takerPays;
    }

    @Override
    @JsonProperty(value="quality")
    public String quality() {
        return this.quality;
    }

    @Override
    @JsonProperty(value="expiration")
    public Optional<UnsignedInteger> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    public final ImmutableOfferResultObject withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableOfferResultObject(newValue, this.flags, this.seq, this.takerGets, this.takerPays, this.quality, this.expiration);
    }

    public final ImmutableOfferResultObject withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableOfferResultObject(value, this.flags, this.seq, this.takerGets, this.takerPays, this.quality, this.expiration);
    }

    public final ImmutableOfferResultObject withFlags(OfferCreateFlags value) {
        if (this.flags == value) {
            return this;
        }
        OfferCreateFlags newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableOfferResultObject(this.status, newValue, this.seq, this.takerGets, this.takerPays, this.quality, this.expiration);
    }

    public final ImmutableOfferResultObject withSeq(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "seq");
        if (this.seq.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOfferResultObject(this.status, this.flags, newValue, this.takerGets, this.takerPays, this.quality, this.expiration);
    }

    public final ImmutableOfferResultObject withTakerGets(CurrencyAmount value) {
        if (this.takerGets == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "takerGets");
        return new ImmutableOfferResultObject(this.status, this.flags, this.seq, newValue, this.takerPays, this.quality, this.expiration);
    }

    public final ImmutableOfferResultObject withTakerPays(CurrencyAmount value) {
        if (this.takerPays == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "takerPays");
        return new ImmutableOfferResultObject(this.status, this.flags, this.seq, this.takerGets, newValue, this.quality, this.expiration);
    }

    public final ImmutableOfferResultObject withQuality(String value) {
        String newValue = Objects.requireNonNull(value, "quality");
        if (this.quality.equals(newValue)) {
            return this;
        }
        return new ImmutableOfferResultObject(this.status, this.flags, this.seq, this.takerGets, this.takerPays, newValue, this.expiration);
    }

    public final ImmutableOfferResultObject withExpiration(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutableOfferResultObject(this.status, this.flags, this.seq, this.takerGets, this.takerPays, this.quality, newValue);
    }

    public final ImmutableOfferResultObject withExpiration(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutableOfferResultObject(this.status, this.flags, this.seq, this.takerGets, this.takerPays, this.quality, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOfferResultObject && this.equalTo(0, (ImmutableOfferResultObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableOfferResultObject another) {
        return Objects.equals(this.status, another.status) && this.flags.equals(another.flags) && this.seq.equals((Object)another.seq) && this.takerGets.equals(another.takerGets) && this.takerPays.equals(another.takerPays) && this.quality.equals(another.quality) && Objects.equals(this.expiration, another.expiration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.seq.hashCode();
        h += (h << 5) + this.takerGets.hashCode();
        h += (h << 5) + this.takerPays.hashCode();
        h += (h << 5) + this.quality.hashCode();
        h += (h << 5) + Objects.hashCode(this.expiration);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OfferResultObject").omitNullValues().add("status", (Object)this.status).add("flags", (Object)this.flags).add("seq", (Object)this.seq).add("takerGets", (Object)this.takerGets).add("takerPays", (Object)this.takerPays).add("quality", (Object)this.quality).add("expiration", (Object)this.expiration).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOfferResultObject fromJson(Json json) {
        Builder builder = ImmutableOfferResultObject.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.seq != null) {
            builder.seq(json.seq);
        }
        if (json.takerGets != null) {
            builder.takerGets(json.takerGets);
        }
        if (json.takerPays != null) {
            builder.takerPays(json.takerPays);
        }
        if (json.quality != null) {
            builder.quality(json.quality);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        return builder.build();
    }

    public static ImmutableOfferResultObject copyOf(OfferResultObject instance) {
        if (instance instanceof ImmutableOfferResultObject) {
            return (ImmutableOfferResultObject)instance;
        }
        return ImmutableOfferResultObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OfferResultObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FLAGS = 1L;
        private static final long INIT_BIT_SEQ = 2L;
        private static final long INIT_BIT_TAKER_GETS = 4L;
        private static final long INIT_BIT_TAKER_PAYS = 8L;
        private static final long INIT_BIT_QUALITY = 16L;
        private long initBits = 31L;
        @Nullable
        private String status;
        @Nullable
        private OfferCreateFlags flags;
        @Nullable
        private UnsignedInteger seq;
        @Nullable
        private CurrencyAmount takerGets;
        @Nullable
        private CurrencyAmount takerPays;
        @Nullable
        private String quality;
        @Nullable
        private UnsignedInteger expiration;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(OfferResultObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof OfferResultObject) {
                instance = (OfferResultObject)object;
                this.takerPays(instance.takerPays());
                this.flags(instance.flags());
                this.takerGets(instance.takerGets());
                Optional<UnsignedInteger> expirationOptional = instance.expiration();
                if (expirationOptional.isPresent()) {
                    this.expiration(expirationOptional);
                }
                this.seq(instance.seq());
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
                this.quality(instance.quality());
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="flags")
        @CanIgnoreReturnValue
        public final Builder flags(OfferCreateFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="seq")
        @CanIgnoreReturnValue
        public final Builder seq(UnsignedInteger seq) {
            this.seq = Objects.requireNonNull(seq, "seq");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="taker_gets")
        @CanIgnoreReturnValue
        public final Builder takerGets(CurrencyAmount takerGets) {
            this.takerGets = Objects.requireNonNull(takerGets, "takerGets");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="taker_pays")
        @CanIgnoreReturnValue
        public final Builder takerPays(CurrencyAmount takerPays) {
            this.takerPays = Objects.requireNonNull(takerPays, "takerPays");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="quality")
        @CanIgnoreReturnValue
        public final Builder quality(String quality) {
            this.quality = Objects.requireNonNull(quality, "quality");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedInteger expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedInteger> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        public ImmutableOfferResultObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOfferResultObject(this.status, this.flags, this.seq, this.takerGets, this.takerPays, this.quality, this.expiration);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("seq");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("takerGets");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("takerPays");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("quality");
            }
            return "Cannot build OfferResultObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OfferResultObject", generator="Immutables")
    static final class Json
    implements OfferResultObject {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        OfferCreateFlags flags;
        @Nullable
        UnsignedInteger seq;
        @Nullable
        CurrencyAmount takerGets;
        @Nullable
        CurrencyAmount takerPays;
        @Nullable
        String quality;
        @Nullable
        Optional<UnsignedInteger> expiration = Optional.empty();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="flags")
        public void setFlags(OfferCreateFlags flags) {
            this.flags = flags;
        }

        @JsonProperty(value="seq")
        public void setSeq(UnsignedInteger seq) {
            this.seq = seq;
        }

        @JsonProperty(value="taker_gets")
        public void setTakerGets(CurrencyAmount takerGets) {
            this.takerGets = takerGets;
        }

        @JsonProperty(value="taker_pays")
        public void setTakerPays(CurrencyAmount takerPays) {
            this.takerPays = takerPays;
        }

        @JsonProperty(value="quality")
        public void setQuality(String quality) {
            this.quality = quality;
        }

        @JsonProperty(value="expiration")
        public void setExpiration(Optional<UnsignedInteger> expiration) {
            this.expiration = expiration;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OfferCreateFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger seq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount takerGets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount takerPays() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String quality() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> expiration() {
            throw new UnsupportedOperationException();
        }
    }
}

