/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.NfTokenObject;
import org.xrpl.xrpl4j.model.flags.NfTokenFlags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;
import org.xrpl.xrpl4j.model.transactions.NfTokenUri;
import org.xrpl.xrpl4j.model.transactions.TransferFee;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NfTokenObject", generator="Immutables")
@Immutable
public final class ImmutableNfTokenObject
implements NfTokenObject {
    private final NfTokenId nfTokenId;
    @Nullable
    private final NfTokenUri uri;
    private final NfTokenFlags flags;
    private final Address issuer;
    private final UnsignedInteger taxon;
    private final UnsignedInteger nftSerial;
    @Nullable
    private final TransferFee transferFee;

    private ImmutableNfTokenObject(NfTokenId nfTokenId, @Nullable NfTokenUri uri, NfTokenFlags flags, Address issuer, UnsignedInteger taxon, UnsignedInteger nftSerial, @Nullable TransferFee transferFee) {
        this.nfTokenId = nfTokenId;
        this.uri = uri;
        this.flags = flags;
        this.issuer = issuer;
        this.taxon = taxon;
        this.nftSerial = nftSerial;
        this.transferFee = transferFee;
    }

    @Override
    @JsonProperty(value="NFTokenID")
    public NfTokenId nfTokenId() {
        return this.nfTokenId;
    }

    @Override
    @JsonProperty(value="URI")
    public Optional<NfTokenUri> uri() {
        return Optional.ofNullable(this.uri);
    }

    @Override
    @JsonProperty(value="Flags")
    public NfTokenFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Issuer")
    public Address issuer() {
        return this.issuer;
    }

    @Override
    @JsonProperty(value="NFTokenTaxon")
    public UnsignedInteger taxon() {
        return this.taxon;
    }

    @Override
    @JsonProperty(value="nft_serial")
    public UnsignedInteger nftSerial() {
        return this.nftSerial;
    }

    @Override
    @JsonProperty(value="TransferFee")
    public Optional<TransferFee> transferFee() {
        return Optional.ofNullable(this.transferFee);
    }

    public final ImmutableNfTokenObject withNfTokenId(NfTokenId value) {
        if (this.nfTokenId == value) {
            return this;
        }
        NfTokenId newValue = Objects.requireNonNull(value, "nfTokenId");
        return new ImmutableNfTokenObject(newValue, this.uri, this.flags, this.issuer, this.taxon, this.nftSerial, this.transferFee);
    }

    public final ImmutableNfTokenObject withUri(NfTokenUri value) {
        NfTokenUri newValue = Objects.requireNonNull(value, "uri");
        if (this.uri == newValue) {
            return this;
        }
        return new ImmutableNfTokenObject(this.nfTokenId, newValue, this.flags, this.issuer, this.taxon, this.nftSerial, this.transferFee);
    }

    public final ImmutableNfTokenObject withUri(Optional<? extends NfTokenUri> optional) {
        NfTokenUri value = optional.orElse(null);
        if (this.uri == value) {
            return this;
        }
        return new ImmutableNfTokenObject(this.nfTokenId, value, this.flags, this.issuer, this.taxon, this.nftSerial, this.transferFee);
    }

    public final ImmutableNfTokenObject withFlags(NfTokenFlags value) {
        if (this.flags == value) {
            return this;
        }
        NfTokenFlags newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableNfTokenObject(this.nfTokenId, this.uri, newValue, this.issuer, this.taxon, this.nftSerial, this.transferFee);
    }

    public final ImmutableNfTokenObject withIssuer(Address value) {
        if (this.issuer == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "issuer");
        return new ImmutableNfTokenObject(this.nfTokenId, this.uri, this.flags, newValue, this.taxon, this.nftSerial, this.transferFee);
    }

    public final ImmutableNfTokenObject withTaxon(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "taxon");
        if (this.taxon.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNfTokenObject(this.nfTokenId, this.uri, this.flags, this.issuer, newValue, this.nftSerial, this.transferFee);
    }

    public final ImmutableNfTokenObject withNftSerial(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "nftSerial");
        if (this.nftSerial.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNfTokenObject(this.nfTokenId, this.uri, this.flags, this.issuer, this.taxon, newValue, this.transferFee);
    }

    public final ImmutableNfTokenObject withTransferFee(TransferFee value) {
        TransferFee newValue = Objects.requireNonNull(value, "transferFee");
        if (this.transferFee == newValue) {
            return this;
        }
        return new ImmutableNfTokenObject(this.nfTokenId, this.uri, this.flags, this.issuer, this.taxon, this.nftSerial, newValue);
    }

    public final ImmutableNfTokenObject withTransferFee(Optional<? extends TransferFee> optional) {
        TransferFee value = optional.orElse(null);
        if (this.transferFee == value) {
            return this;
        }
        return new ImmutableNfTokenObject(this.nfTokenId, this.uri, this.flags, this.issuer, this.taxon, this.nftSerial, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNfTokenObject && this.equalTo(0, (ImmutableNfTokenObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableNfTokenObject another) {
        return this.nfTokenId.equals(another.nfTokenId) && Objects.equals(this.uri, another.uri) && this.flags.equals(another.flags) && this.issuer.equals(another.issuer) && this.taxon.equals((Object)another.taxon) && this.nftSerial.equals((Object)another.nftSerial) && Objects.equals(this.transferFee, another.transferFee);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nfTokenId.hashCode();
        h += (h << 5) + Objects.hashCode(this.uri);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.issuer.hashCode();
        h += (h << 5) + this.taxon.hashCode();
        h += (h << 5) + this.nftSerial.hashCode();
        h += (h << 5) + Objects.hashCode(this.transferFee);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NfTokenObject").omitNullValues().add("nfTokenId", (Object)this.nfTokenId).add("uri", (Object)this.uri).add("flags", (Object)this.flags).add("issuer", (Object)this.issuer).add("taxon", (Object)this.taxon).add("nftSerial", (Object)this.nftSerial).add("transferFee", (Object)this.transferFee).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNfTokenObject fromJson(Json json) {
        Builder builder = ImmutableNfTokenObject.builder();
        if (json.nfTokenId != null) {
            builder.nfTokenId(json.nfTokenId);
        }
        if (json.uri != null) {
            builder.uri(json.uri);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.issuer != null) {
            builder.issuer(json.issuer);
        }
        if (json.taxon != null) {
            builder.taxon(json.taxon);
        }
        if (json.nftSerial != null) {
            builder.nftSerial(json.nftSerial);
        }
        if (json.transferFee != null) {
            builder.transferFee(json.transferFee);
        }
        return builder.build();
    }

    public static ImmutableNfTokenObject copyOf(NfTokenObject instance) {
        if (instance instanceof ImmutableNfTokenObject) {
            return (ImmutableNfTokenObject)instance;
        }
        return ImmutableNfTokenObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NfTokenObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NF_TOKEN_ID = 1L;
        private static final long INIT_BIT_FLAGS = 2L;
        private static final long INIT_BIT_ISSUER = 4L;
        private static final long INIT_BIT_TAXON = 8L;
        private static final long INIT_BIT_NFT_SERIAL = 16L;
        private long initBits = 31L;
        @Nullable
        private NfTokenId nfTokenId;
        @Nullable
        private NfTokenUri uri;
        @Nullable
        private NfTokenFlags flags;
        @Nullable
        private Address issuer;
        @Nullable
        private UnsignedInteger taxon;
        @Nullable
        private UnsignedInteger nftSerial;
        @Nullable
        private TransferFee transferFee;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NfTokenObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.nfTokenId(instance.nfTokenId());
            Optional<NfTokenUri> uriOptional = instance.uri();
            if (uriOptional.isPresent()) {
                this.uri(uriOptional);
            }
            this.flags(instance.flags());
            this.issuer(instance.issuer());
            this.taxon(instance.taxon());
            this.nftSerial(instance.nftSerial());
            Optional<TransferFee> transferFeeOptional = instance.transferFee();
            if (transferFeeOptional.isPresent()) {
                this.transferFee(transferFeeOptional);
            }
            return this;
        }

        @JsonProperty(value="NFTokenID")
        @CanIgnoreReturnValue
        public final Builder nfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = Objects.requireNonNull(nfTokenId, "nfTokenId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(NfTokenUri uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            return this;
        }

        @JsonProperty(value="URI")
        @CanIgnoreReturnValue
        public final Builder uri(Optional<? extends NfTokenUri> uri) {
            this.uri = uri.orElse(null);
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(NfTokenFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Issuer")
        @CanIgnoreReturnValue
        public final Builder issuer(Address issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="NFTokenTaxon")
        @CanIgnoreReturnValue
        public final Builder taxon(UnsignedInteger taxon) {
            this.taxon = Objects.requireNonNull(taxon, "taxon");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="nft_serial")
        @CanIgnoreReturnValue
        public final Builder nftSerial(UnsignedInteger nftSerial) {
            this.nftSerial = Objects.requireNonNull(nftSerial, "nftSerial");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transferFee(TransferFee transferFee) {
            this.transferFee = Objects.requireNonNull(transferFee, "transferFee");
            return this;
        }

        @JsonProperty(value="TransferFee")
        @CanIgnoreReturnValue
        public final Builder transferFee(Optional<? extends TransferFee> transferFee) {
            this.transferFee = transferFee.orElse(null);
            return this;
        }

        public ImmutableNfTokenObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNfTokenObject(this.nfTokenId, this.uri, this.flags, this.issuer, this.taxon, this.nftSerial, this.transferFee);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nfTokenId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("issuer");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("taxon");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("nftSerial");
            }
            return "Cannot build NfTokenObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NfTokenObject", generator="Immutables")
    static final class Json
    implements NfTokenObject {
        @Nullable
        NfTokenId nfTokenId;
        @Nullable
        Optional<NfTokenUri> uri = Optional.empty();
        @Nullable
        NfTokenFlags flags;
        @Nullable
        Address issuer;
        @Nullable
        UnsignedInteger taxon;
        @Nullable
        UnsignedInteger nftSerial;
        @Nullable
        Optional<TransferFee> transferFee = Optional.empty();

        Json() {
        }

        @JsonProperty(value="NFTokenID")
        public void setNfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = nfTokenId;
        }

        @JsonProperty(value="URI")
        public void setUri(Optional<NfTokenUri> uri) {
            this.uri = uri;
        }

        @JsonProperty(value="Flags")
        public void setFlags(NfTokenFlags flags) {
            this.flags = flags;
        }

        @JsonProperty(value="Issuer")
        public void setIssuer(Address issuer) {
            this.issuer = issuer;
        }

        @JsonProperty(value="NFTokenTaxon")
        public void setTaxon(UnsignedInteger taxon) {
            this.taxon = taxon;
        }

        @JsonProperty(value="nft_serial")
        public void setNftSerial(UnsignedInteger nftSerial) {
            this.nftSerial = nftSerial;
        }

        @JsonProperty(value="TransferFee")
        public void setTransferFee(Optional<TransferFee> transferFee) {
            this.transferFee = transferFee;
        }

        @Override
        public NfTokenId nfTokenId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NfTokenUri> uri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NfTokenFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address issuer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger taxon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger nftSerial() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TransferFee> transferFee() {
            throw new UnsupportedOperationException();
        }
    }
}

