/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.GatewayBalancesAssets;
import org.xrpl.xrpl4j.model.client.accounts.GatewayBalancesHotWallets;
import org.xrpl.xrpl4j.model.client.accounts.GatewayBalancesObligations;
import org.xrpl.xrpl4j.model.client.accounts.GatewayBalancesResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GatewayBalancesResult", generator="Immutables")
@Immutable
public final class ImmutableGatewayBalancesResult
implements GatewayBalancesResult {
    @Nullable
    private final String status;
    private final Address account;
    private final GatewayBalancesAssets assets;
    private final GatewayBalancesHotWallets balances;
    private final GatewayBalancesObligations obligations;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final LedgerIndex ledgerCurrentIndex;
    private final boolean validated;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGatewayBalancesResult(Builder builder) {
        this.status = builder.status;
        this.account = builder.account;
        this.ledgerHash = builder.ledgerHash;
        this.ledgerIndex = builder.ledgerIndex;
        this.ledgerCurrentIndex = builder.ledgerCurrentIndex;
        if (builder.assets != null) {
            this.initShim.assets(builder.assets);
        }
        if (builder.balances != null) {
            this.initShim.balances(builder.balances);
        }
        if (builder.obligations != null) {
            this.initShim.obligations(builder.obligations);
        }
        if (builder.validatedIsSet()) {
            this.initShim.validated(builder.validated);
        }
        this.assets = this.initShim.assets();
        this.balances = this.initShim.balances();
        this.obligations = this.initShim.obligations();
        this.validated = this.initShim.validated();
        this.initShim = null;
    }

    private ImmutableGatewayBalancesResult(@Nullable String status, Address account, GatewayBalancesAssets assets, GatewayBalancesHotWallets balances, GatewayBalancesObligations obligations, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, @Nullable LedgerIndex ledgerCurrentIndex, boolean validated) {
        this.status = status;
        this.account = account;
        this.assets = assets;
        this.balances = balances;
        this.obligations = obligations;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
        this.validated = validated;
        this.initShim = null;
    }

    private GatewayBalancesAssets assetsInitialize() {
        return GatewayBalancesResult.super.assets();
    }

    private GatewayBalancesHotWallets balancesInitialize() {
        return GatewayBalancesResult.super.balances();
    }

    private GatewayBalancesObligations obligationsInitialize() {
        return GatewayBalancesResult.super.obligations();
    }

    private boolean validatedInitialize() {
        return GatewayBalancesResult.super.validated();
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="assets")
    public GatewayBalancesAssets assets() {
        InitShim shim = this.initShim;
        return shim != null ? shim.assets() : this.assets;
    }

    @Override
    @JsonProperty(value="balances")
    public GatewayBalancesHotWallets balances() {
        InitShim shim = this.initShim;
        return shim != null ? shim.balances() : this.balances;
    }

    @Override
    @JsonProperty(value="obligations")
    public GatewayBalancesObligations obligations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.obligations() : this.obligations;
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex() {
        return Optional.ofNullable(this.ledgerCurrentIndex);
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validated() : this.validated;
    }

    public final ImmutableGatewayBalancesResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableGatewayBalancesResult(newValue, this.account, this.assets, this.balances, this.obligations, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableGatewayBalancesResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableGatewayBalancesResult(value, this.account, this.assets, this.balances, this.obligations, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableGatewayBalancesResult withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableGatewayBalancesResult(this.status, newValue, this.assets, this.balances, this.obligations, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableGatewayBalancesResult withAssets(GatewayBalancesAssets value) {
        if (this.assets == value) {
            return this;
        }
        GatewayBalancesAssets newValue = Objects.requireNonNull(value, "assets");
        return new ImmutableGatewayBalancesResult(this.status, this.account, newValue, this.balances, this.obligations, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableGatewayBalancesResult withBalances(GatewayBalancesHotWallets value) {
        if (this.balances == value) {
            return this;
        }
        GatewayBalancesHotWallets newValue = Objects.requireNonNull(value, "balances");
        return new ImmutableGatewayBalancesResult(this.status, this.account, this.assets, newValue, this.obligations, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableGatewayBalancesResult withObligations(GatewayBalancesObligations value) {
        if (this.obligations == value) {
            return this;
        }
        GatewayBalancesObligations newValue = Objects.requireNonNull(value, "obligations");
        return new ImmutableGatewayBalancesResult(this.status, this.account, this.assets, this.balances, newValue, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableGatewayBalancesResult withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableGatewayBalancesResult(this.status, this.account, this.assets, this.balances, this.obligations, newValue, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableGatewayBalancesResult withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableGatewayBalancesResult(this.status, this.account, this.assets, this.balances, this.obligations, value, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableGatewayBalancesResult withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return new ImmutableGatewayBalancesResult(this.status, this.account, this.assets, this.balances, this.obligations, this.ledgerHash, newValue, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableGatewayBalancesResult withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableGatewayBalancesResult(this.status, this.account, this.assets, this.balances, this.obligations, this.ledgerHash, value, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableGatewayBalancesResult withLedgerCurrentIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        if (this.ledgerCurrentIndex == newValue) {
            return this;
        }
        return new ImmutableGatewayBalancesResult(this.status, this.account, this.assets, this.balances, this.obligations, this.ledgerHash, this.ledgerIndex, newValue, this.validated);
    }

    public final ImmutableGatewayBalancesResult withLedgerCurrentIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        return new ImmutableGatewayBalancesResult(this.status, this.account, this.assets, this.balances, this.obligations, this.ledgerHash, this.ledgerIndex, value, this.validated);
    }

    public final ImmutableGatewayBalancesResult withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableGatewayBalancesResult(this.status, this.account, this.assets, this.balances, this.obligations, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGatewayBalancesResult && this.equalTo(0, (ImmutableGatewayBalancesResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableGatewayBalancesResult another) {
        return Objects.equals(this.status, another.status) && this.account.equals(another.account) && this.assets.equals(another.assets) && this.balances.equals(another.balances) && this.obligations.equals(another.obligations) && Objects.equals(this.ledgerHash, another.ledgerHash) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && Objects.equals(this.ledgerCurrentIndex, another.ledgerCurrentIndex) && this.validated == another.validated;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.assets.hashCode();
        h += (h << 5) + this.balances.hashCode();
        h += (h << 5) + this.obligations.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerCurrentIndex);
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GatewayBalancesResult").omitNullValues().add("status", (Object)this.status).add("account", (Object)this.account).add("assets", (Object)this.assets).add("balances", (Object)this.balances).add("obligations", (Object)this.obligations).add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).add("validated", this.validated).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGatewayBalancesResult fromJson(Json json) {
        Builder builder = ImmutableGatewayBalancesResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.assets != null) {
            builder.assets(json.assets);
        }
        if (json.balances != null) {
            builder.balances(json.balances);
        }
        if (json.obligations != null) {
            builder.obligations(json.obligations);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        return builder.build();
    }

    public static ImmutableGatewayBalancesResult copyOf(GatewayBalancesResult instance) {
        if (instance instanceof ImmutableGatewayBalancesResult) {
            return (ImmutableGatewayBalancesResult)instance;
        }
        return ImmutableGatewayBalancesResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GatewayBalancesResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private Address account;
        @Nullable
        private GatewayBalancesAssets assets;
        @Nullable
        private GatewayBalancesHotWallets balances;
        @Nullable
        private GatewayBalancesObligations obligations;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;
        private boolean validated;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(GatewayBalancesResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof GatewayBalancesResult) {
                instance = (GatewayBalancesResult)object;
                this.balances(instance.balances());
                Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
                if (ledgerHashOptional.isPresent()) {
                    this.ledgerHash(ledgerHashOptional);
                }
                this.assets(instance.assets());
                this.validated(instance.validated());
                Optional<LedgerIndex> ledgerIndexOptional = instance.ledgerIndex();
                if (ledgerIndexOptional.isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                this.obligations(instance.obligations());
                this.account(instance.account());
                Optional<LedgerIndex> ledgerCurrentIndexOptional = instance.ledgerCurrentIndex();
                if (ledgerCurrentIndexOptional.isPresent()) {
                    this.ledgerCurrentIndex(ledgerCurrentIndexOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="assets")
        @CanIgnoreReturnValue
        public final Builder assets(GatewayBalancesAssets assets) {
            this.assets = Objects.requireNonNull(assets, "assets");
            return this;
        }

        @JsonProperty(value="balances")
        @CanIgnoreReturnValue
        public final Builder balances(GatewayBalancesHotWallets balances) {
            this.balances = Objects.requireNonNull(balances, "balances");
            return this;
        }

        @JsonProperty(value="obligations")
        @CanIgnoreReturnValue
        public final Builder obligations(GatewayBalancesObligations obligations) {
            this.obligations = Objects.requireNonNull(obligations, "obligations");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(Optional<? extends LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex.orElse(null);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableGatewayBalancesResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGatewayBalancesResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build GatewayBalancesResult, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GatewayBalancesResult", generator="Immutables")
    private final class InitShim {
        private byte assetsBuildStage = 0;
        private GatewayBalancesAssets assets;
        private byte balancesBuildStage = 0;
        private GatewayBalancesHotWallets balances;
        private byte obligationsBuildStage = 0;
        private GatewayBalancesObligations obligations;
        private byte validatedBuildStage = 0;
        private boolean validated;

        private InitShim() {
        }

        GatewayBalancesAssets assets() {
            if (this.assetsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.assetsBuildStage == 0) {
                this.assetsBuildStage = (byte)-1;
                this.assets = Objects.requireNonNull(ImmutableGatewayBalancesResult.this.assetsInitialize(), "assets");
                this.assetsBuildStage = 1;
            }
            return this.assets;
        }

        void assets(GatewayBalancesAssets assets) {
            this.assets = assets;
            this.assetsBuildStage = 1;
        }

        GatewayBalancesHotWallets balances() {
            if (this.balancesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.balancesBuildStage == 0) {
                this.balancesBuildStage = (byte)-1;
                this.balances = Objects.requireNonNull(ImmutableGatewayBalancesResult.this.balancesInitialize(), "balances");
                this.balancesBuildStage = 1;
            }
            return this.balances;
        }

        void balances(GatewayBalancesHotWallets balances) {
            this.balances = balances;
            this.balancesBuildStage = 1;
        }

        GatewayBalancesObligations obligations() {
            if (this.obligationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.obligationsBuildStage == 0) {
                this.obligationsBuildStage = (byte)-1;
                this.obligations = Objects.requireNonNull(ImmutableGatewayBalancesResult.this.obligationsInitialize(), "obligations");
                this.obligationsBuildStage = 1;
            }
            return this.obligations;
        }

        void obligations(GatewayBalancesObligations obligations) {
            this.obligations = obligations;
            this.obligationsBuildStage = 1;
        }

        boolean validated() {
            if (this.validatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validatedBuildStage == 0) {
                this.validatedBuildStage = (byte)-1;
                this.validated = ImmutableGatewayBalancesResult.this.validatedInitialize();
                this.validatedBuildStage = 1;
            }
            return this.validated;
        }

        void validated(boolean validated) {
            this.validated = validated;
            this.validatedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.assetsBuildStage == -1) {
                attributes.add("assets");
            }
            if (this.balancesBuildStage == -1) {
                attributes.add("balances");
            }
            if (this.obligationsBuildStage == -1) {
                attributes.add("obligations");
            }
            if (this.validatedBuildStage == -1) {
                attributes.add("validated");
            }
            return "Cannot build GatewayBalancesResult, attribute initializers form cycle " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GatewayBalancesResult", generator="Immutables")
    static final class Json
    implements GatewayBalancesResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        Address account;
        @Nullable
        GatewayBalancesAssets assets;
        @Nullable
        GatewayBalancesHotWallets balances;
        @Nullable
        GatewayBalancesObligations obligations;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerCurrentIndex = Optional.empty();
        boolean validated;
        boolean validatedIsSet;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="assets")
        public void setAssets(GatewayBalancesAssets assets) {
            this.assets = assets;
        }

        @JsonProperty(value="balances")
        public void setBalances(GatewayBalancesHotWallets balances) {
            this.balances = balances;
        }

        @JsonProperty(value="obligations")
        public void setObligations(GatewayBalancesObligations obligations) {
            this.obligations = obligations;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(Optional<LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GatewayBalancesAssets assets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GatewayBalancesHotWallets balances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GatewayBalancesObligations obligations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }
    }
}

