/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.GatewayBalancesRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GatewayBalancesRequestParams", generator="Immutables")
@Immutable
public final class ImmutableGatewayBalancesRequestParams
implements GatewayBalancesRequestParams {
    private final Address account;
    private final ImmutableSet<Address> hotWallets;
    @Nullable
    private final LedgerSpecifier ledgerSpecifier;
    private final transient boolean strict;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGatewayBalancesRequestParams(Builder builder) {
        this.account = builder.account;
        this.ledgerSpecifier = builder.ledgerSpecifier;
        if (builder.hotWalletsIsSet()) {
            this.initShim.hotWallets((ImmutableSet<Address>)builder.hotWallets.build());
        }
        this.hotWallets = this.initShim.hotWallets();
        this.strict = this.initShim.strict();
        this.initShim = null;
    }

    private ImmutableGatewayBalancesRequestParams(Address account, ImmutableSet<Address> hotWallets, @Nullable LedgerSpecifier ledgerSpecifier) {
        this.account = account;
        this.initShim.hotWallets(hotWallets);
        this.ledgerSpecifier = ledgerSpecifier;
        this.hotWallets = this.initShim.hotWallets();
        this.strict = this.initShim.strict();
        this.initShim = null;
    }

    private Set<Address> hotWalletsInitialize() {
        return GatewayBalancesRequestParams.super.hotWallets();
    }

    private boolean strictInitialize() {
        return GatewayBalancesRequestParams.super.strict();
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @JsonProperty(value="hotwallet")
    public ImmutableSet<Address> hotWallets() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hotWallets() : this.hotWallets;
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    @Nullable
    public LedgerSpecifier ledgerSpecifier() {
        return this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="strict")
    public boolean strict() {
        InitShim shim = this.initShim;
        return shim != null ? shim.strict() : this.strict;
    }

    public final ImmutableGatewayBalancesRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableGatewayBalancesRequestParams(newValue, this.hotWallets, this.ledgerSpecifier);
    }

    public final ImmutableGatewayBalancesRequestParams withHotWallets(Address ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableGatewayBalancesRequestParams(this.account, (ImmutableSet<Address>)newValue, this.ledgerSpecifier);
    }

    public final ImmutableGatewayBalancesRequestParams withHotWallets(Iterable<? extends Address> elements) {
        if (this.hotWallets == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableGatewayBalancesRequestParams(this.account, (ImmutableSet<Address>)newValue, this.ledgerSpecifier);
    }

    public final ImmutableGatewayBalancesRequestParams withLedgerSpecifier(@Nullable LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        return new ImmutableGatewayBalancesRequestParams(this.account, this.hotWallets, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGatewayBalancesRequestParams && this.equalTo(0, (ImmutableGatewayBalancesRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableGatewayBalancesRequestParams another) {
        return this.account.equals(another.account) && this.hotWallets.equals(another.hotWallets) && Objects.equals(this.ledgerSpecifier, another.ledgerSpecifier) && this.strict == another.strict;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.hotWallets.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerSpecifier);
        h += (h << 5) + Booleans.hashCode((boolean)this.strict);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GatewayBalancesRequestParams").omitNullValues().add("account", (Object)this.account).add("hotWallets", this.hotWallets).add("ledgerSpecifier", (Object)this.ledgerSpecifier).add("strict", this.strict).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGatewayBalancesRequestParams fromJson(Json json) {
        Builder builder = ImmutableGatewayBalancesRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.hotWalletsIsSet) {
            builder.addAllHotWallets(json.hotWallets);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        return builder.build();
    }

    public static ImmutableGatewayBalancesRequestParams copyOf(GatewayBalancesRequestParams instance) {
        if (instance instanceof ImmutableGatewayBalancesRequestParams) {
            return (ImmutableGatewayBalancesRequestParams)instance;
        }
        return ImmutableGatewayBalancesRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GatewayBalancesRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long OPT_BIT_HOT_WALLETS = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private Address account;
        private ImmutableSet.Builder<Address> hotWallets = ImmutableSet.builder();
        @Nullable
        private LedgerSpecifier ledgerSpecifier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GatewayBalancesRequestParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.addAllHotWallets(instance.hotWallets());
            LedgerSpecifier ledgerSpecifierValue = instance.ledgerSpecifier();
            if (ledgerSpecifierValue != null) {
                this.ledgerSpecifier(ledgerSpecifierValue);
            }
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHotWallets(Address element) {
            this.hotWallets.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHotWallets(Address ... elements) {
            this.hotWallets.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="hotwallet")
        @CanIgnoreReturnValue
        public final Builder hotWallets(Iterable<? extends Address> elements) {
            this.hotWallets = ImmutableSet.builder();
            return this.addAllHotWallets(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllHotWallets(Iterable<? extends Address> elements) {
            this.hotWallets.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(@Nullable LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
            return this;
        }

        public ImmutableGatewayBalancesRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGatewayBalancesRequestParams(this);
        }

        private boolean hotWalletsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build GatewayBalancesRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GatewayBalancesRequestParams", generator="Immutables")
    private final class InitShim {
        private byte hotWalletsBuildStage = 0;
        private ImmutableSet<Address> hotWallets;
        private byte strictBuildStage = 0;
        private boolean strict;

        private InitShim() {
        }

        ImmutableSet<Address> hotWallets() {
            if (this.hotWalletsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hotWalletsBuildStage == 0) {
                this.hotWalletsBuildStage = (byte)-1;
                this.hotWallets = ImmutableSet.copyOf((Collection)ImmutableGatewayBalancesRequestParams.this.hotWalletsInitialize());
                this.hotWalletsBuildStage = 1;
            }
            return this.hotWallets;
        }

        void hotWallets(ImmutableSet<Address> hotWallets) {
            this.hotWallets = hotWallets;
            this.hotWalletsBuildStage = 1;
        }

        boolean strict() {
            if (this.strictBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.strictBuildStage == 0) {
                this.strictBuildStage = (byte)-1;
                this.strict = ImmutableGatewayBalancesRequestParams.this.strictInitialize();
                this.strictBuildStage = 1;
            }
            return this.strict;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.hotWalletsBuildStage == -1) {
                attributes.add("hotWallets");
            }
            if (this.strictBuildStage == -1) {
                attributes.add("strict");
            }
            return "Cannot build GatewayBalancesRequestParams, attribute initializers form cycle " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GatewayBalancesRequestParams", generator="Immutables")
    static final class Json
    implements GatewayBalancesRequestParams {
        @Nullable
        Address account;
        @Nullable
        Set<Address> hotWallets = ImmutableSet.of();
        boolean hotWalletsIsSet;
        @Nullable
        LedgerSpecifier ledgerSpecifier;

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="hotwallet")
        public void setHotWallets(Set<Address> hotWallets) {
            this.hotWallets = hotWallets;
            this.hotWalletsIsSet = null != hotWallets;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(@Nullable LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Address> hotWallets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean strict() {
            throw new UnsupportedOperationException();
        }
    }
}

