/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountObjectsRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Marker;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountObjectsRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAccountObjectsRequestParams
implements AccountObjectsRequestParams {
    private final Address account;
    @Nullable
    private final AccountObjectsRequestParams.AccountObjectType type;
    private final boolean deletionBlockersOnly;
    private final LedgerSpecifier ledgerSpecifier;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;

    private ImmutableAccountObjectsRequestParams(Builder builder) {
        this.account = builder.account;
        this.type = builder.type;
        this.ledgerSpecifier = builder.ledgerSpecifier;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.deletionBlockersOnly = builder.deletionBlockersOnlyIsSet() ? builder.deletionBlockersOnly : AccountObjectsRequestParams.super.deletionBlockersOnly();
    }

    private ImmutableAccountObjectsRequestParams(Address account, @Nullable AccountObjectsRequestParams.AccountObjectType type, boolean deletionBlockersOnly, LedgerSpecifier ledgerSpecifier, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.account = account;
        this.type = type;
        this.deletionBlockersOnly = deletionBlockersOnly;
        this.ledgerSpecifier = ledgerSpecifier;
        this.limit = limit;
        this.marker = marker;
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="type")
    public Optional<AccountObjectsRequestParams.AccountObjectType> type() {
        return Optional.ofNullable(this.type);
    }

    @Override
    @JsonProperty(value="deletion_blockers_only")
    public boolean deletionBlockersOnly() {
        return this.deletionBlockersOnly;
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        return this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountObjectsRequestParams(newValue, this.type, this.deletionBlockersOnly, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withType(AccountObjectsRequestParams.AccountObjectType value) {
        AccountObjectsRequestParams.AccountObjectType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, newValue, this.deletionBlockersOnly, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withType(Optional<? extends AccountObjectsRequestParams.AccountObjectType> optional) {
        AccountObjectsRequestParams.AccountObjectType value = optional.orElse(null);
        if (this.type == value) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, value, this.deletionBlockersOnly, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withDeletionBlockersOnly(boolean value) {
        if (this.deletionBlockersOnly == value) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, value, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, newValue, this.limit, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, this.ledgerSpecifier, newValue, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, this.ledgerSpecifier, value, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, this.ledgerSpecifier, this.limit, newValue);
    }

    public final ImmutableAccountObjectsRequestParams withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, this.ledgerSpecifier, this.limit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountObjectsRequestParams && this.equalTo(0, (ImmutableAccountObjectsRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccountObjectsRequestParams another) {
        return this.account.equals(another.account) && Objects.equals((Object)this.type, (Object)another.type) && this.deletionBlockersOnly == another.deletionBlockersOnly && this.ledgerSpecifier.equals(another.ledgerSpecifier) && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Booleans.hashCode((boolean)this.deletionBlockersOnly);
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountObjectsRequestParams").omitNullValues().add("account", (Object)this.account).add("type", (Object)this.type).add("deletionBlockersOnly", this.deletionBlockersOnly).add("ledgerSpecifier", (Object)this.ledgerSpecifier).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountObjectsRequestParams fromJson(Json json) {
        Builder builder = ImmutableAccountObjectsRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.deletionBlockersOnlyIsSet) {
            builder.deletionBlockersOnly(json.deletionBlockersOnly);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    public static ImmutableAccountObjectsRequestParams copyOf(AccountObjectsRequestParams instance) {
        if (instance instanceof ImmutableAccountObjectsRequestParams) {
            return (ImmutableAccountObjectsRequestParams)instance;
        }
        return ImmutableAccountObjectsRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountObjectsRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_LEDGER_SPECIFIER = 2L;
        private static final long OPT_BIT_DELETION_BLOCKERS_ONLY = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private Address account;
        @Nullable
        private AccountObjectsRequestParams.AccountObjectType type;
        private boolean deletionBlockersOnly;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountObjectsRequestParams instance) {
            Optional<Marker> markerOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<AccountObjectsRequestParams.AccountObjectType> typeOptional = instance.type();
            if (typeOptional.isPresent()) {
                this.type(typeOptional);
            }
            this.deletionBlockersOnly(instance.deletionBlockersOnly());
            this.ledgerSpecifier(instance.ledgerSpecifier());
            Optional<UnsignedInteger> limitOptional = instance.limit();
            if (limitOptional.isPresent()) {
                this.limit(limitOptional);
            }
            if ((markerOptional = instance.marker()).isPresent()) {
                this.marker(markerOptional);
            }
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(AccountObjectsRequestParams.AccountObjectType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(Optional<? extends AccountObjectsRequestParams.AccountObjectType> type) {
            this.type = type.orElse(null);
            return this;
        }

        @JsonProperty(value="deletion_blockers_only")
        @CanIgnoreReturnValue
        public final Builder deletionBlockersOnly(boolean deletionBlockersOnly) {
            this.deletionBlockersOnly = deletionBlockersOnly;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableAccountObjectsRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountObjectsRequestParams(this);
        }

        private boolean deletionBlockersOnlyIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ledgerSpecifier");
            }
            return "Cannot build AccountObjectsRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountObjectsRequestParams", generator="Immutables")
    static final class Json
    implements AccountObjectsRequestParams {
        @Nullable
        Address account;
        @Nullable
        Optional<AccountObjectsRequestParams.AccountObjectType> type = Optional.empty();
        boolean deletionBlockersOnly;
        boolean deletionBlockersOnlyIsSet;
        @Nullable
        LedgerSpecifier ledgerSpecifier;
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="type")
        public void setType(Optional<AccountObjectsRequestParams.AccountObjectType> type) {
            this.type = type;
        }

        @JsonProperty(value="deletion_blockers_only")
        public void setDeletionBlockersOnly(boolean deletionBlockersOnly) {
            this.deletionBlockersOnly = deletionBlockersOnly;
            this.deletionBlockersOnlyIsSet = true;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<AccountObjectsRequestParams.AccountObjectType> type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean deletionBlockersOnly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }
}

