/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountNftsResult;
import org.xrpl.xrpl4j.model.client.accounts.NfTokenObject;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountNftsResult", generator="Immutables")
@Immutable
public final class ImmutableAccountNftsResult
implements AccountNftsResult {
    @Nullable
    private final String status;
    private final Address account;
    private final ImmutableList<NfTokenObject> accountNfts;
    @Nullable
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final LedgerIndex ledgerCurrentIndex;
    @Nullable
    private final Hash256 ledgerHash;
    private final boolean validated;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;

    private ImmutableAccountNftsResult(Builder builder) {
        this.status = builder.status;
        this.account = builder.account;
        this.accountNfts = builder.accountNfts.build();
        this.ledgerIndex = builder.ledgerIndex;
        this.ledgerCurrentIndex = builder.ledgerCurrentIndex;
        this.ledgerHash = builder.ledgerHash;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.validated = builder.validatedIsSet() ? builder.validated : AccountNftsResult.super.validated();
    }

    private ImmutableAccountNftsResult(@Nullable String status, Address account, ImmutableList<NfTokenObject> accountNfts, @Nullable LedgerIndex ledgerIndex, @Nullable LedgerIndex ledgerCurrentIndex, @Nullable Hash256 ledgerHash, boolean validated, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.status = status;
        this.account = account;
        this.accountNfts = accountNfts;
        this.ledgerIndex = ledgerIndex;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
        this.ledgerHash = ledgerHash;
        this.validated = validated;
        this.limit = limit;
        this.marker = marker;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @JsonProperty(value="account_nfts")
    public ImmutableList<NfTokenObject> accountNfts() {
        return this.accountNfts;
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex() {
        return Optional.ofNullable(this.ledgerCurrentIndex);
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        return this.validated;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableAccountNftsResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableAccountNftsResult(newValue, this.account, this.accountNfts, this.ledgerIndex, this.ledgerCurrentIndex, this.ledgerHash, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableAccountNftsResult(value, this.account, this.accountNfts, this.ledgerIndex, this.ledgerCurrentIndex, this.ledgerHash, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountNftsResult(this.status, newValue, this.accountNfts, this.ledgerIndex, this.ledgerCurrentIndex, this.ledgerHash, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withAccountNfts(NfTokenObject ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAccountNftsResult(this.status, this.account, (ImmutableList<NfTokenObject>)newValue, this.ledgerIndex, this.ledgerCurrentIndex, this.ledgerHash, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withAccountNfts(Iterable<? extends NfTokenObject> elements) {
        if (this.accountNfts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAccountNftsResult(this.status, this.account, (ImmutableList<NfTokenObject>)newValue, this.ledgerIndex, this.ledgerCurrentIndex, this.ledgerHash, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, newValue, this.ledgerCurrentIndex, this.ledgerHash, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, value, this.ledgerCurrentIndex, this.ledgerHash, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withLedgerCurrentIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        if (this.ledgerCurrentIndex == newValue) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, this.ledgerIndex, newValue, this.ledgerHash, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withLedgerCurrentIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, this.ledgerIndex, value, this.ledgerHash, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, this.ledgerIndex, this.ledgerCurrentIndex, newValue, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, this.ledgerIndex, this.ledgerCurrentIndex, value, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, this.ledgerIndex, this.ledgerCurrentIndex, this.ledgerHash, value, this.limit, this.marker);
    }

    public final ImmutableAccountNftsResult withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, this.ledgerIndex, this.ledgerCurrentIndex, this.ledgerHash, this.validated, newValue, this.marker);
    }

    public final ImmutableAccountNftsResult withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, this.ledgerIndex, this.ledgerCurrentIndex, this.ledgerHash, this.validated, value, this.marker);
    }

    public final ImmutableAccountNftsResult withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, this.ledgerIndex, this.ledgerCurrentIndex, this.ledgerHash, this.validated, this.limit, newValue);
    }

    public final ImmutableAccountNftsResult withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableAccountNftsResult(this.status, this.account, this.accountNfts, this.ledgerIndex, this.ledgerCurrentIndex, this.ledgerHash, this.validated, this.limit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountNftsResult && this.equalTo(0, (ImmutableAccountNftsResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccountNftsResult another) {
        return Objects.equals(this.status, another.status) && this.account.equals(another.account) && this.accountNfts.equals(another.accountNfts) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && Objects.equals(this.ledgerCurrentIndex, another.ledgerCurrentIndex) && Objects.equals(this.ledgerHash, another.ledgerHash) && this.validated == another.validated && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.accountNfts.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerCurrentIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountNftsResult").omitNullValues().add("status", (Object)this.status).add("account", (Object)this.account).add("accountNfts", this.accountNfts).add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).add("ledgerHash", (Object)this.ledgerHash).add("validated", this.validated).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountNftsResult fromJson(Json json) {
        Builder builder = ImmutableAccountNftsResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.accountNfts != null) {
            builder.addAllAccountNfts(json.accountNfts);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    public static ImmutableAccountNftsResult copyOf(AccountNftsResult instance) {
        if (instance instanceof ImmutableAccountNftsResult) {
            return (ImmutableAccountNftsResult)instance;
        }
        return ImmutableAccountNftsResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountNftsResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private Address account;
        private ImmutableList.Builder<NfTokenObject> accountNfts = ImmutableList.builder();
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;
        @Nullable
        private Hash256 ledgerHash;
        private boolean validated;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountNftsResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof AccountNftsResult) {
                Optional<UnsignedInteger> limitOptional;
                Optional<Marker> markerOptional;
                instance = (AccountNftsResult)object;
                Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
                if (ledgerHashOptional.isPresent()) {
                    this.ledgerHash(ledgerHashOptional);
                }
                this.validated(instance.validated());
                Optional<LedgerIndex> ledgerIndexOptional = instance.ledgerIndex();
                if (ledgerIndexOptional.isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                if ((markerOptional = instance.marker()).isPresent()) {
                    this.marker(markerOptional);
                }
                if ((limitOptional = instance.limit()).isPresent()) {
                    this.limit(limitOptional);
                }
                this.addAllAccountNfts(instance.accountNfts());
                this.account(instance.account());
                Optional<LedgerIndex> ledgerCurrentIndexOptional = instance.ledgerCurrentIndex();
                if (ledgerCurrentIndexOptional.isPresent()) {
                    this.ledgerCurrentIndex(ledgerCurrentIndexOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAccountNfts(NfTokenObject element) {
            this.accountNfts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAccountNfts(NfTokenObject ... elements) {
            this.accountNfts.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="account_nfts")
        @CanIgnoreReturnValue
        public final Builder accountNfts(Iterable<? extends NfTokenObject> elements) {
            this.accountNfts = ImmutableList.builder();
            return this.addAllAccountNfts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAccountNfts(Iterable<? extends NfTokenObject> elements) {
            this.accountNfts.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(Optional<? extends LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableAccountNftsResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountNftsResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build AccountNftsResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountNftsResult", generator="Immutables")
    static final class Json
    implements AccountNftsResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        Address account;
        @Nullable
        List<NfTokenObject> accountNfts = ImmutableList.of();
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerCurrentIndex = Optional.empty();
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        boolean validated;
        boolean validatedIsSet;
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="account_nfts")
        public void setAccountNfts(List<NfTokenObject> accountNfts) {
            this.accountNfts = accountNfts;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(Optional<LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<NfTokenObject> accountNfts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }
}

