/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountNftsRequestParams;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Marker;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountNftsRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAccountNftsRequestParams
implements AccountNftsRequestParams {
    private final Address account;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;

    private ImmutableAccountNftsRequestParams(Address account, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.account = account;
        this.limit = limit;
        this.marker = marker;
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableAccountNftsRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountNftsRequestParams(newValue, this.limit, this.marker);
    }

    public final ImmutableAccountNftsRequestParams withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableAccountNftsRequestParams(this.account, newValue, this.marker);
    }

    public final ImmutableAccountNftsRequestParams withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableAccountNftsRequestParams(this.account, value, this.marker);
    }

    public final ImmutableAccountNftsRequestParams withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableAccountNftsRequestParams(this.account, this.limit, newValue);
    }

    public final ImmutableAccountNftsRequestParams withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableAccountNftsRequestParams(this.account, this.limit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountNftsRequestParams && this.equalTo(0, (ImmutableAccountNftsRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccountNftsRequestParams another) {
        return this.account.equals(another.account) && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountNftsRequestParams").omitNullValues().add("account", (Object)this.account).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountNftsRequestParams fromJson(Json json) {
        Builder builder = ImmutableAccountNftsRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    public static ImmutableAccountNftsRequestParams copyOf(AccountNftsRequestParams instance) {
        if (instance instanceof ImmutableAccountNftsRequestParams) {
            return (ImmutableAccountNftsRequestParams)instance;
        }
        return ImmutableAccountNftsRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountNftsRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private long initBits = 1L;
        @Nullable
        private Address account;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountNftsRequestParams instance) {
            Optional<Marker> markerOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<UnsignedInteger> limitOptional = instance.limit();
            if (limitOptional.isPresent()) {
                this.limit(limitOptional);
            }
            if ((markerOptional = instance.marker()).isPresent()) {
                this.marker(markerOptional);
            }
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableAccountNftsRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountNftsRequestParams(this.account, this.limit, this.marker);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build AccountNftsRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountNftsRequestParams", generator="Immutables")
    static final class Json
    implements AccountNftsRequestParams {
        @Nullable
        Address account;
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }
}

