/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountInfoResult;
import org.xrpl.xrpl4j.model.client.accounts.QueueData;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.ledger.AccountRootObject;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountInfoResult", generator="Immutables")
@Immutable
public final class ImmutableAccountInfoResult
implements AccountInfoResult {
    @Nullable
    private final String status;
    private final AccountRootObject accountData;
    @Nullable
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final LedgerIndex ledgerCurrentIndex;
    @Nullable
    private final QueueData queueData;
    private final boolean validated;

    private ImmutableAccountInfoResult(Builder builder) {
        this.status = builder.status;
        this.accountData = builder.accountData;
        this.ledgerIndex = builder.ledgerIndex;
        this.ledgerCurrentIndex = builder.ledgerCurrentIndex;
        this.queueData = builder.queueData;
        this.validated = builder.validatedIsSet() ? builder.validated : AccountInfoResult.super.validated();
    }

    private ImmutableAccountInfoResult(@Nullable String status, AccountRootObject accountData, @Nullable LedgerIndex ledgerIndex, @Nullable LedgerIndex ledgerCurrentIndex, @Nullable QueueData queueData, boolean validated) {
        this.status = status;
        this.accountData = accountData;
        this.ledgerIndex = ledgerIndex;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
        this.queueData = queueData;
        this.validated = validated;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="account_data")
    public AccountRootObject accountData() {
        return this.accountData;
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex() {
        return Optional.ofNullable(this.ledgerCurrentIndex);
    }

    @Override
    @JsonProperty(value="queue_data")
    public Optional<QueueData> queueData() {
        return Optional.ofNullable(this.queueData);
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        return this.validated;
    }

    public final ImmutableAccountInfoResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableAccountInfoResult(newValue, this.accountData, this.ledgerIndex, this.ledgerCurrentIndex, this.queueData, this.validated);
    }

    public final ImmutableAccountInfoResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableAccountInfoResult(value, this.accountData, this.ledgerIndex, this.ledgerCurrentIndex, this.queueData, this.validated);
    }

    public final ImmutableAccountInfoResult withAccountData(AccountRootObject value) {
        if (this.accountData == value) {
            return this;
        }
        AccountRootObject newValue = Objects.requireNonNull(value, "accountData");
        return new ImmutableAccountInfoResult(this.status, newValue, this.ledgerIndex, this.ledgerCurrentIndex, this.queueData, this.validated);
    }

    public final ImmutableAccountInfoResult withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return new ImmutableAccountInfoResult(this.status, this.accountData, newValue, this.ledgerCurrentIndex, this.queueData, this.validated);
    }

    public final ImmutableAccountInfoResult withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableAccountInfoResult(this.status, this.accountData, value, this.ledgerCurrentIndex, this.queueData, this.validated);
    }

    public final ImmutableAccountInfoResult withLedgerCurrentIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        if (this.ledgerCurrentIndex == newValue) {
            return this;
        }
        return new ImmutableAccountInfoResult(this.status, this.accountData, this.ledgerIndex, newValue, this.queueData, this.validated);
    }

    public final ImmutableAccountInfoResult withLedgerCurrentIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        return new ImmutableAccountInfoResult(this.status, this.accountData, this.ledgerIndex, value, this.queueData, this.validated);
    }

    public final ImmutableAccountInfoResult withQueueData(QueueData value) {
        QueueData newValue = Objects.requireNonNull(value, "queueData");
        if (this.queueData == newValue) {
            return this;
        }
        return new ImmutableAccountInfoResult(this.status, this.accountData, this.ledgerIndex, this.ledgerCurrentIndex, newValue, this.validated);
    }

    public final ImmutableAccountInfoResult withQueueData(Optional<? extends QueueData> optional) {
        QueueData value = optional.orElse(null);
        if (this.queueData == value) {
            return this;
        }
        return new ImmutableAccountInfoResult(this.status, this.accountData, this.ledgerIndex, this.ledgerCurrentIndex, value, this.validated);
    }

    public final ImmutableAccountInfoResult withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableAccountInfoResult(this.status, this.accountData, this.ledgerIndex, this.ledgerCurrentIndex, this.queueData, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountInfoResult && this.equalTo(0, (ImmutableAccountInfoResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccountInfoResult another) {
        return Objects.equals(this.status, another.status) && this.accountData.equals(another.accountData) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && Objects.equals(this.ledgerCurrentIndex, another.ledgerCurrentIndex) && Objects.equals(this.queueData, another.queueData) && this.validated == another.validated;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.accountData.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerCurrentIndex);
        h += (h << 5) + Objects.hashCode(this.queueData);
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountInfoResult").omitNullValues().add("status", (Object)this.status).add("accountData", (Object)this.accountData).add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).add("queueData", (Object)this.queueData).add("validated", this.validated).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountInfoResult fromJson(Json json) {
        Builder builder = ImmutableAccountInfoResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.accountData != null) {
            builder.accountData(json.accountData);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        if (json.queueData != null) {
            builder.queueData(json.queueData);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        return builder.build();
    }

    public static ImmutableAccountInfoResult copyOf(AccountInfoResult instance) {
        if (instance instanceof ImmutableAccountInfoResult) {
            return (ImmutableAccountInfoResult)instance;
        }
        return ImmutableAccountInfoResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountInfoResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT_DATA = 1L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private AccountRootObject accountData;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;
        @Nullable
        private QueueData queueData;
        private boolean validated;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountInfoResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof AccountInfoResult) {
                instance = (AccountInfoResult)object;
                Optional<QueueData> queueDataOptional = instance.queueData();
                if (queueDataOptional.isPresent()) {
                    this.queueData(queueDataOptional);
                }
                this.validated(instance.validated());
                Optional<LedgerIndex> ledgerIndexOptional = instance.ledgerIndex();
                if (ledgerIndexOptional.isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                this.accountData(instance.accountData());
                Optional<LedgerIndex> ledgerCurrentIndexOptional = instance.ledgerCurrentIndex();
                if (ledgerCurrentIndexOptional.isPresent()) {
                    this.ledgerCurrentIndex(ledgerCurrentIndexOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="account_data")
        @CanIgnoreReturnValue
        public final Builder accountData(AccountRootObject accountData) {
            this.accountData = Objects.requireNonNull(accountData, "accountData");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(Optional<? extends LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queueData(QueueData queueData) {
            this.queueData = Objects.requireNonNull(queueData, "queueData");
            return this;
        }

        @JsonProperty(value="queue_data")
        @CanIgnoreReturnValue
        public final Builder queueData(Optional<? extends QueueData> queueData) {
            this.queueData = queueData.orElse(null);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableAccountInfoResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountInfoResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accountData");
            }
            return "Cannot build AccountInfoResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountInfoResult", generator="Immutables")
    static final class Json
    implements AccountInfoResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        AccountRootObject accountData;
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerCurrentIndex = Optional.empty();
        @Nullable
        Optional<QueueData> queueData = Optional.empty();
        boolean validated;
        boolean validatedIsSet;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="account_data")
        public void setAccountData(AccountRootObject accountData) {
            this.accountData = accountData;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(Optional<LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @JsonProperty(value="queue_data")
        public void setQueueData(Optional<QueueData> queueData) {
            this.queueData = queueData;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AccountRootObject accountData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<QueueData> queueData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }
    }
}

