/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountCurrenciesResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountCurrenciesResult", generator="Immutables")
@Immutable
public final class ImmutableAccountCurrenciesResult
implements AccountCurrenciesResult {
    @Nullable
    private final String status;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final LedgerIndex ledgerCurrentIndex;
    private final boolean validated;
    private final ImmutableList<String> receiveCurrencies;
    private final ImmutableList<String> sendCurrencies;

    private ImmutableAccountCurrenciesResult(@Nullable String status, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, @Nullable LedgerIndex ledgerCurrentIndex, boolean validated, ImmutableList<String> receiveCurrencies, ImmutableList<String> sendCurrencies) {
        this.status = status;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
        this.validated = validated;
        this.receiveCurrencies = receiveCurrencies;
        this.sendCurrencies = sendCurrencies;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex() {
        return Optional.ofNullable(this.ledgerCurrentIndex);
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        return this.validated;
    }

    @JsonProperty(value="receive_currencies")
    public ImmutableList<String> receiveCurrencies() {
        return this.receiveCurrencies;
    }

    @JsonProperty(value="send_currencies")
    public ImmutableList<String> sendCurrencies() {
        return this.sendCurrencies;
    }

    public final ImmutableAccountCurrenciesResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableAccountCurrenciesResult(newValue, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.receiveCurrencies, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableAccountCurrenciesResult(value, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.receiveCurrencies, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableAccountCurrenciesResult(this.status, newValue, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.receiveCurrencies, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableAccountCurrenciesResult(this.status, value, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.receiveCurrencies, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return new ImmutableAccountCurrenciesResult(this.status, this.ledgerHash, newValue, this.ledgerCurrentIndex, this.validated, this.receiveCurrencies, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableAccountCurrenciesResult(this.status, this.ledgerHash, value, this.ledgerCurrentIndex, this.validated, this.receiveCurrencies, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withLedgerCurrentIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        if (this.ledgerCurrentIndex == newValue) {
            return this;
        }
        return new ImmutableAccountCurrenciesResult(this.status, this.ledgerHash, this.ledgerIndex, newValue, this.validated, this.receiveCurrencies, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withLedgerCurrentIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        return new ImmutableAccountCurrenciesResult(this.status, this.ledgerHash, this.ledgerIndex, value, this.validated, this.receiveCurrencies, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableAccountCurrenciesResult(this.status, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, value, this.receiveCurrencies, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withReceiveCurrencies(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAccountCurrenciesResult(this.status, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, (ImmutableList<String>)newValue, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withReceiveCurrencies(Iterable<String> elements) {
        if (this.receiveCurrencies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAccountCurrenciesResult(this.status, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, (ImmutableList<String>)newValue, this.sendCurrencies);
    }

    public final ImmutableAccountCurrenciesResult withSendCurrencies(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAccountCurrenciesResult(this.status, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.receiveCurrencies, (ImmutableList<String>)newValue);
    }

    public final ImmutableAccountCurrenciesResult withSendCurrencies(Iterable<String> elements) {
        if (this.sendCurrencies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAccountCurrenciesResult(this.status, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.receiveCurrencies, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountCurrenciesResult && this.equalTo(0, (ImmutableAccountCurrenciesResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccountCurrenciesResult another) {
        return Objects.equals(this.status, another.status) && Objects.equals(this.ledgerHash, another.ledgerHash) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && Objects.equals(this.ledgerCurrentIndex, another.ledgerCurrentIndex) && this.validated == another.validated && this.receiveCurrencies.equals(another.receiveCurrencies) && this.sendCurrencies.equals(another.sendCurrencies);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerCurrentIndex);
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        h += (h << 5) + this.receiveCurrencies.hashCode();
        h += (h << 5) + this.sendCurrencies.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountCurrenciesResult").omitNullValues().add("status", (Object)this.status).add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).add("validated", this.validated).add("receiveCurrencies", this.receiveCurrencies).add("sendCurrencies", this.sendCurrencies).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountCurrenciesResult fromJson(Json json) {
        Builder builder = ImmutableAccountCurrenciesResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        if (json.receiveCurrencies != null) {
            builder.addAllReceiveCurrencies(json.receiveCurrencies);
        }
        if (json.sendCurrencies != null) {
            builder.addAllSendCurrencies(json.sendCurrencies);
        }
        return builder.build();
    }

    public static ImmutableAccountCurrenciesResult copyOf(AccountCurrenciesResult instance) {
        if (instance instanceof ImmutableAccountCurrenciesResult) {
            return (ImmutableAccountCurrenciesResult)instance;
        }
        return ImmutableAccountCurrenciesResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountCurrenciesResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALIDATED = 1L;
        private long initBits = 1L;
        @Nullable
        private String status;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;
        private boolean validated;
        private ImmutableList.Builder<String> receiveCurrencies = ImmutableList.builder();
        private ImmutableList.Builder<String> sendCurrencies = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountCurrenciesResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof AccountCurrenciesResult) {
                instance = (AccountCurrenciesResult)object;
                Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
                if (ledgerHashOptional.isPresent()) {
                    this.ledgerHash(ledgerHashOptional);
                }
                this.validated(instance.validated());
                Optional<LedgerIndex> ledgerIndexOptional = instance.ledgerIndex();
                if (ledgerIndexOptional.isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                this.addAllSendCurrencies(instance.sendCurrencies());
                this.addAllReceiveCurrencies(instance.receiveCurrencies());
                Optional<LedgerIndex> ledgerCurrentIndexOptional = instance.ledgerCurrentIndex();
                if (ledgerCurrentIndexOptional.isPresent()) {
                    this.ledgerCurrentIndex(ledgerCurrentIndexOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(Optional<? extends LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex.orElse(null);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder validated(boolean validated) {
            this.validated = validated;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReceiveCurrencies(String element) {
            this.receiveCurrencies.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReceiveCurrencies(String ... elements) {
            this.receiveCurrencies.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="receive_currencies")
        @CanIgnoreReturnValue
        public final Builder receiveCurrencies(Iterable<String> elements) {
            this.receiveCurrencies = ImmutableList.builder();
            return this.addAllReceiveCurrencies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllReceiveCurrencies(Iterable<String> elements) {
            this.receiveCurrencies.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSendCurrencies(String element) {
            this.sendCurrencies.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSendCurrencies(String ... elements) {
            this.sendCurrencies.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="send_currencies")
        @CanIgnoreReturnValue
        public final Builder sendCurrencies(Iterable<String> elements) {
            this.sendCurrencies = ImmutableList.builder();
            return this.addAllSendCurrencies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSendCurrencies(Iterable<String> elements) {
            this.sendCurrencies.addAll(elements);
            return this;
        }

        public ImmutableAccountCurrenciesResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountCurrenciesResult(this.status, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.receiveCurrencies.build(), this.sendCurrencies.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("validated");
            }
            return "Cannot build AccountCurrenciesResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountCurrenciesResult", generator="Immutables")
    static final class Json
    implements AccountCurrenciesResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerCurrentIndex = Optional.empty();
        boolean validated;
        boolean validatedIsSet;
        @Nullable
        List<String> receiveCurrencies = ImmutableList.of();
        @Nullable
        List<String> sendCurrencies = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(Optional<LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @JsonProperty(value="receive_currencies")
        public void setReceiveCurrencies(List<String> receiveCurrencies) {
            this.receiveCurrencies = receiveCurrencies;
        }

        @JsonProperty(value="send_currencies")
        public void setSendCurrencies(List<String> sendCurrencies) {
            this.sendCurrencies = sendCurrencies;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> receiveCurrencies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> sendCurrencies() {
            throw new UnsupportedOperationException();
        }
    }
}

