/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountCurrenciesRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountCurrenciesRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAccountCurrenciesRequestParams
implements AccountCurrenciesRequestParams {
    private final Address account;
    private final LedgerSpecifier ledgerSpecifier;
    private final transient boolean strict;

    private ImmutableAccountCurrenciesRequestParams(Address account, LedgerSpecifier ledgerSpecifier) {
        this.account = account;
        this.ledgerSpecifier = ledgerSpecifier;
        this.strict = AccountCurrenciesRequestParams.super.strict();
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        return this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="strict")
    public boolean strict() {
        return this.strict;
    }

    public final ImmutableAccountCurrenciesRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountCurrenciesRequestParams(newValue, this.ledgerSpecifier);
    }

    public final ImmutableAccountCurrenciesRequestParams withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableAccountCurrenciesRequestParams(this.account, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountCurrenciesRequestParams && this.equalTo(0, (ImmutableAccountCurrenciesRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccountCurrenciesRequestParams another) {
        return this.account.equals(another.account) && this.ledgerSpecifier.equals(another.ledgerSpecifier) && this.strict == another.strict;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.strict);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountCurrenciesRequestParams").omitNullValues().add("account", (Object)this.account).add("ledgerSpecifier", (Object)this.ledgerSpecifier).add("strict", this.strict).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountCurrenciesRequestParams fromJson(Json json) {
        Builder builder = ImmutableAccountCurrenciesRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        return builder.build();
    }

    public static ImmutableAccountCurrenciesRequestParams copyOf(AccountCurrenciesRequestParams instance) {
        if (instance instanceof ImmutableAccountCurrenciesRequestParams) {
            return (ImmutableAccountCurrenciesRequestParams)instance;
        }
        return ImmutableAccountCurrenciesRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountCurrenciesRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_LEDGER_SPECIFIER = 2L;
        private long initBits = 3L;
        @Nullable
        private Address account;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountCurrenciesRequestParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.ledgerSpecifier(instance.ledgerSpecifier());
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAccountCurrenciesRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountCurrenciesRequestParams(this.account, this.ledgerSpecifier);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ledgerSpecifier");
            }
            return "Cannot build AccountCurrenciesRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountCurrenciesRequestParams", generator="Immutables")
    static final class Json
    implements AccountCurrenciesRequestParams {
        @Nullable
        Address account;
        @Nullable
        LedgerSpecifier ledgerSpecifier;

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean strict() {
            throw new UnsupportedOperationException();
        }
    }
}

