/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.GatewayBalancesAssets;
import org.xrpl.xrpl4j.model.client.accounts.GatewayBalancesHotWallets;
import org.xrpl.xrpl4j.model.client.accounts.GatewayBalancesObligations;
import org.xrpl.xrpl4j.model.client.accounts.ImmutableGatewayBalancesResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableGatewayBalancesResult.class)
@JsonDeserialize(as=ImmutableGatewayBalancesResult.class)
@Value.Immutable
public interface GatewayBalancesResult
extends XrplResult {
    public static ImmutableGatewayBalancesResult.Builder builder() {
        return ImmutableGatewayBalancesResult.builder();
    }

    public Address account();

    @Value.Default
    default public GatewayBalancesAssets assets() {
        return GatewayBalancesAssets.builder().build();
    }

    @Value.Default
    default public GatewayBalancesHotWallets balances() {
        return GatewayBalancesHotWallets.builder().build();
    }

    @Value.Default
    default public GatewayBalancesObligations obligations() {
        return GatewayBalancesObligations.builder().build();
    }

    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash();

    @JsonIgnore
    @Value.Auxiliary
    default public Hash256 ledgerHashSafe() {
        return this.ledgerHash().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerHash."));
    }

    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex();

    @JsonIgnore
    @Value.Auxiliary
    default public LedgerIndex ledgerIndexSafe() {
        return this.ledgerIndex().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerIndex."));
    }

    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex();

    @JsonIgnore
    @Value.Auxiliary
    default public LedgerIndex ledgerCurrentIndexSafe() {
        return this.ledgerCurrentIndex().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerCurrentIndex."));
    }

    @Value.Default
    default public boolean validated() {
        return false;
    }
}

