/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.ImmutableAccountTransactionsRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndexBound;
import org.xrpl.xrpl4j.model.client.common.LedgerIndexShortcut;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.jackson.modules.AccountTransactionsRequestParamsDeserializer;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Marker;

@JsonSerialize(as=ImmutableAccountTransactionsRequestParams.class)
@JsonDeserialize(as=ImmutableAccountTransactionsRequestParams.class, using=AccountTransactionsRequestParamsDeserializer.class)
@Value.Immutable
public interface AccountTransactionsRequestParams
extends XrplRequestParams {
    public static ImmutableAccountTransactionsRequestParams.Builder unboundedBuilder() {
        return ImmutableAccountTransactionsRequestParams.builder();
    }

    public static ImmutableAccountTransactionsRequestParams.Builder builder(LedgerSpecifier ledgerSpecifier) {
        return ImmutableAccountTransactionsRequestParams.builder().ledgerSpecifier(ledgerSpecifier);
    }

    public static ImmutableAccountTransactionsRequestParams.Builder builder(LedgerIndexBound ledgerIndexMinimum, LedgerIndexBound ledgerIndexMaximum) {
        Objects.requireNonNull(ledgerIndexMinimum);
        Objects.requireNonNull(ledgerIndexMaximum);
        return ImmutableAccountTransactionsRequestParams.builder().ledgerIndexMinimum(ledgerIndexMinimum).ledgerIndexMaximum(ledgerIndexMaximum);
    }

    public Address account();

    @JsonProperty(value="ledger_index_min")
    @Nullable
    @Value.Default
    default public LedgerIndexBound ledgerIndexMinimum() {
        return LedgerIndexBound.unbounded();
    }

    @JsonProperty(value="ledger_index_max")
    @Nullable
    @Value.Default
    default public LedgerIndexBound ledgerIndexMaximum() {
        return LedgerIndexBound.unbounded();
    }

    @JsonUnwrapped
    public Optional<LedgerSpecifier> ledgerSpecifier();

    @Value.Derived
    default public boolean binary() {
        return false;
    }

    @Value.Default
    default public boolean forward() {
        return false;
    }

    public Optional<UnsignedInteger> limit();

    public Optional<Marker> marker();

    @Value.Check
    default public void validateSpecifierNotCurrentOrClosed() {
        this.ledgerSpecifier().ifPresent(ledgerSpecifier -> ledgerSpecifier.handle(ledgerHash -> {}, ledgerIndex -> {}, ledgerIndexShortcut -> Preconditions.checkArgument((boolean)ledgerIndexShortcut.equals(LedgerIndexShortcut.VALIDATED), (Object)"Invalid LedgerIndexShortcut. The account_tx API method only accepts 'validated' when specifying a shortcut.")));
    }

    @Value.Check
    default public AccountTransactionsRequestParams emptyBoundedParametersIfSpecifierPresent() {
        if (this.ledgerSpecifier().isPresent() && (this.ledgerIndexMinimum() != null || this.ledgerIndexMaximum() != null)) {
            return ImmutableAccountTransactionsRequestParams.builder().from(this).ledgerIndexMinimum(null).ledgerIndexMaximum(null).build();
        }
        return this;
    }
}

