/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.ImmutableAccountObjectsRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Marker;

@JsonSerialize(as=ImmutableAccountObjectsRequestParams.class)
@JsonDeserialize(as=ImmutableAccountObjectsRequestParams.class)
@Value.Immutable
public interface AccountObjectsRequestParams
extends XrplRequestParams {
    public static ImmutableAccountObjectsRequestParams.Builder builder() {
        return ImmutableAccountObjectsRequestParams.builder();
    }

    public static AccountObjectsRequestParams of(Address classicAddress) {
        return AccountObjectsRequestParams.builder().account(classicAddress).ledgerSpecifier(LedgerSpecifier.CURRENT).build();
    }

    public Address account();

    public Optional<AccountObjectType> type();

    @JsonProperty(value="deletion_blockers_only")
    @Value.Default
    default public boolean deletionBlockersOnly() {
        return false;
    }

    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier();

    public Optional<UnsignedInteger> limit();

    public Optional<Marker> marker();

    public static enum AccountObjectType {
        CHECK("check"),
        DESPOSIT_PRE_AUTH("deposit_preauth"),
        ESCROW("escrow"),
        OFFER("offer"),
        PAYMENT_CHANNEL("payment_channel"),
        SIGNER_LIST("signer_list"),
        TICKET("ticket"),
        STATE("state");

        private final String value;

        private AccountObjectType(String value) {
            this.value = value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }
    }
}

