/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.ImmutableAccountCurrenciesResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableAccountCurrenciesResult.class)
@JsonDeserialize(as=ImmutableAccountCurrenciesResult.class)
@Value.Immutable
public interface AccountCurrenciesResult
extends XrplResult {
    public static ImmutableAccountCurrenciesResult.Builder builder() {
        return ImmutableAccountCurrenciesResult.builder();
    }

    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash();

    @JsonIgnore
    @Value.Auxiliary
    default public Hash256 ledgerHashSafe() {
        return this.ledgerHash().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerHash."));
    }

    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex();

    @JsonIgnore
    @Value.Auxiliary
    default public LedgerIndex ledgerIndexSafe() {
        return this.ledgerIndex().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerIndex."));
    }

    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex();

    @JsonIgnore
    @Value.Auxiliary
    default public LedgerIndex ledgerCurrentIndexSafe() {
        return this.ledgerCurrentIndex().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerCurrentIndex."));
    }

    public boolean validated();

    @JsonProperty(value="receive_currencies")
    public List<String> receiveCurrencies();

    @JsonProperty(value="send_currencies")
    public List<String> sendCurrencies();
}

