/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.ImmutableAccountChannelsResult;
import org.xrpl.xrpl4j.model.client.accounts.PaymentChannelResultObject;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;

@JsonSerialize(as=ImmutableAccountChannelsResult.class)
@JsonDeserialize(as=ImmutableAccountChannelsResult.class)
@Value.Immutable
public interface AccountChannelsResult
extends XrplResult {
    public static ImmutableAccountChannelsResult.Builder builder() {
        return ImmutableAccountChannelsResult.builder();
    }

    public Address account();

    public List<PaymentChannelResultObject> channels();

    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash();

    @JsonIgnore
    @Value.Auxiliary
    default public Hash256 ledgerHashSafe() {
        return this.ledgerHash().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerHash."));
    }

    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex();

    @JsonIgnore
    @Value.Auxiliary
    default public LedgerIndex ledgerIndexSafe() {
        return this.ledgerIndex().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerIndex."));
    }

    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex();

    @JsonIgnore
    @Value.Auxiliary
    default public LedgerIndex ledgerCurrentIndexSafe() {
        return this.ledgerCurrentIndex().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerCurrentIndex."));
    }

    @Value.Default
    default public boolean validated() {
        return false;
    }

    public Optional<UnsignedInteger> limit();

    public Optional<Marker> marker();
}

