/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.Finality;
import org.xrpl.xrpl4j.model.client.FinalityStatus;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Finality", generator="Immutables")
@Immutable
public final class ImmutableFinality
implements Finality {
    private final FinalityStatus finalityStatus;
    @Nullable
    private final String resultCode;

    private ImmutableFinality(FinalityStatus finalityStatus, @Nullable String resultCode) {
        this.finalityStatus = finalityStatus;
        this.resultCode = resultCode;
    }

    @Override
    @JsonProperty(value="finalityStatus")
    public FinalityStatus finalityStatus() {
        return this.finalityStatus;
    }

    @Override
    @JsonProperty(value="resultCode")
    public Optional<String> resultCode() {
        return Optional.ofNullable(this.resultCode);
    }

    public final ImmutableFinality withFinalityStatus(FinalityStatus value) {
        FinalityStatus newValue = Objects.requireNonNull(value, "finalityStatus");
        if (this.finalityStatus == newValue) {
            return this;
        }
        return new ImmutableFinality(newValue, this.resultCode);
    }

    public final ImmutableFinality withResultCode(String value) {
        String newValue = Objects.requireNonNull(value, "resultCode");
        if (Objects.equals(this.resultCode, newValue)) {
            return this;
        }
        return new ImmutableFinality(this.finalityStatus, newValue);
    }

    public final ImmutableFinality withResultCode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.resultCode, value)) {
            return this;
        }
        return new ImmutableFinality(this.finalityStatus, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFinality && this.equalTo(0, (ImmutableFinality)another);
    }

    private boolean equalTo(int synthetic, ImmutableFinality another) {
        return this.finalityStatus.equals((Object)another.finalityStatus) && Objects.equals(this.resultCode, another.resultCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.finalityStatus.hashCode();
        h += (h << 5) + Objects.hashCode(this.resultCode);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Finality").omitNullValues().add("finalityStatus", (Object)this.finalityStatus).add("resultCode", (Object)this.resultCode).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFinality fromJson(Json json) {
        Builder builder = ImmutableFinality.builder();
        if (json.finalityStatus != null) {
            builder.finalityStatus(json.finalityStatus);
        }
        if (json.resultCode != null) {
            builder.resultCode(json.resultCode);
        }
        return builder.build();
    }

    public static ImmutableFinality copyOf(Finality instance) {
        if (instance instanceof ImmutableFinality) {
            return (ImmutableFinality)instance;
        }
        return ImmutableFinality.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Finality", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FINALITY_STATUS = 1L;
        private long initBits = 1L;
        @Nullable
        private FinalityStatus finalityStatus;
        @Nullable
        private String resultCode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Finality instance) {
            Objects.requireNonNull(instance, "instance");
            this.finalityStatus(instance.finalityStatus());
            Optional<String> resultCodeOptional = instance.resultCode();
            if (resultCodeOptional.isPresent()) {
                this.resultCode(resultCodeOptional);
            }
            return this;
        }

        @JsonProperty(value="finalityStatus")
        @CanIgnoreReturnValue
        public final Builder finalityStatus(FinalityStatus finalityStatus) {
            this.finalityStatus = Objects.requireNonNull(finalityStatus, "finalityStatus");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder resultCode(String resultCode) {
            this.resultCode = Objects.requireNonNull(resultCode, "resultCode");
            return this;
        }

        @JsonProperty(value="resultCode")
        @CanIgnoreReturnValue
        public final Builder resultCode(Optional<String> resultCode) {
            this.resultCode = resultCode.orElse(null);
            return this;
        }

        public ImmutableFinality build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFinality(this.finalityStatus, this.resultCode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("finalityStatus");
            }
            return "Cannot build Finality, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Finality", generator="Immutables")
    static final class Json
    implements Finality {
        @Nullable
        FinalityStatus finalityStatus;
        @Nullable
        Optional<String> resultCode = Optional.empty();

        Json() {
        }

        @JsonProperty(value="finalityStatus")
        public void setFinalityStatus(FinalityStatus finalityStatus) {
            this.finalityStatus = finalityStatus;
        }

        @JsonProperty(value="resultCode")
        public void setResultCode(Optional<String> resultCode) {
            this.resultCode = resultCode;
        }

        @Override
        public FinalityStatus finalityStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> resultCode() {
            throw new UnsupportedOperationException();
        }
    }
}

