/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing.bc;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Objects;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;

public interface Secp256k1 {
    @Deprecated
    public static final X9ECParameters EC_PARAMETERS = SECNamedCurves.getByName((String)"secp256k1");
    @Deprecated
    public static final ECDomainParameters EC_DOMAIN_PARAMETERS = new ECDomainParameters(EC_PARAMETERS.getCurve(), EC_PARAMETERS.getG(), EC_PARAMETERS.getN(), EC_PARAMETERS.getH());
    public static final UnsignedByte SECP256K1_PREFIX = UnsignedByte.of(0);

    public static UnsignedByteArray toUnsignedByteArray(BigInteger amount, int minFinalByteLength) {
        Objects.requireNonNull(amount);
        Preconditions.checkArgument((amount.signum() >= 0 ? 1 : 0) != 0, (Object)"amount must not be negative");
        Preconditions.checkArgument((minFinalByteLength >= 0 ? 1 : 0) != 0, (Object)"minFinalByteLength must not be negative");
        return Secp256k1.withZeroPrefixPadding(amount.toByteArray(), minFinalByteLength);
    }

    public static UnsignedByteArray withZeroPrefixPadding(UnsignedByteArray bytes, int minFinalByteLength) {
        Preconditions.checkArgument((minFinalByteLength >= 0 ? 1 : 0) != 0, (Object)"minFinalByteLength must not be negative");
        return Secp256k1.withZeroPrefixPadding(bytes.toByteArray(), minFinalByteLength);
    }

    public static UnsignedByteArray withZeroPrefixPadding(byte[] bytes, int minFinalByteLength) {
        Preconditions.checkArgument((minFinalByteLength >= 0 ? 1 : 0) != 0, (Object)"minFinalByteLength must not be negative");
        if (bytes.length > minFinalByteLength) {
            minFinalByteLength = bytes.length;
        }
        int numPadBytes = minFinalByteLength - bytes.length;
        byte[] resultBytes = new byte[minFinalByteLength];
        System.arraycopy(bytes, 0, resultBytes, numPadBytes, bytes.length);
        return UnsignedByteArray.of(resultBytes);
    }
}

