/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing.bc;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.signing.bc.EcDsaSignature;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EcDsaSignature", generator="Immutables")
@Immutable
public final class ImmutableEcDsaSignature
implements EcDsaSignature {
    private final BigInteger r;
    private final BigInteger s;
    private final transient UnsignedByteArray der;

    private ImmutableEcDsaSignature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
        this.der = Objects.requireNonNull(EcDsaSignature.super.der(), "der");
    }

    @Override
    public BigInteger r() {
        return this.r;
    }

    @Override
    public BigInteger s() {
        return this.s;
    }

    @Override
    public UnsignedByteArray der() {
        return this.der;
    }

    public final ImmutableEcDsaSignature withR(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "r");
        if (this.r.equals(newValue)) {
            return this;
        }
        return ImmutableEcDsaSignature.validate(new ImmutableEcDsaSignature(newValue, this.s));
    }

    public final ImmutableEcDsaSignature withS(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "s");
        if (this.s.equals(newValue)) {
            return this;
        }
        return ImmutableEcDsaSignature.validate(new ImmutableEcDsaSignature(this.r, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEcDsaSignature && this.equalTo(0, (ImmutableEcDsaSignature)another);
    }

    private boolean equalTo(int synthetic, ImmutableEcDsaSignature another) {
        return this.r.equals(another.r) && this.s.equals(another.s) && this.der.equals(another.der);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.r.hashCode();
        h += (h << 5) + this.s.hashCode();
        h += (h << 5) + this.der.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EcDsaSignature").omitNullValues().add("r", (Object)this.r).add("s", (Object)this.s).add("der", (Object)this.der).toString();
    }

    private static ImmutableEcDsaSignature validate(ImmutableEcDsaSignature instance) {
        instance.isStrictlyCanonical();
        return instance;
    }

    public static ImmutableEcDsaSignature copyOf(EcDsaSignature instance) {
        if (instance instanceof ImmutableEcDsaSignature) {
            return (ImmutableEcDsaSignature)instance;
        }
        return ImmutableEcDsaSignature.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EcDsaSignature", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_R = 1L;
        private static final long INIT_BIT_S = 2L;
        private long initBits = 3L;
        @Nullable
        private BigInteger r;
        @Nullable
        private BigInteger s;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EcDsaSignature instance) {
            Objects.requireNonNull(instance, "instance");
            this.r(instance.r());
            this.s(instance.s());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder r(BigInteger r) {
            this.r = Objects.requireNonNull(r, "r");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder s(BigInteger s) {
            this.s = Objects.requireNonNull(s, "s");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEcDsaSignature build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableEcDsaSignature.validate(new ImmutableEcDsaSignature(this.r, this.s));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("r");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("s");
            }
            return "Cannot build EcDsaSignature, some of required attributes are not set " + attributes;
        }
    }
}

