/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing.bc;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.DLSequence;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.crypto.keys.bc.BcKeyUtils;
import org.xrpl.xrpl4j.crypto.signing.bc.ImmutableEcDsaSignature;

@Value.Immutable
public interface EcDsaSignature {
    public static ImmutableEcDsaSignature.Builder builder() {
        return ImmutableEcDsaSignature.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EcDsaSignature fromDer(byte[] bytes) {
        ASN1Integer s;
        ASN1Integer r;
        ASN1InputStream decoder = new ASN1InputStream(bytes);
        DLSequence seq = (DLSequence)decoder.readObject();
        try {
            r = (ASN1Integer)seq.getObjectAt(0);
            s = (ASN1Integer)seq.getObjectAt(1);
        }
        catch (ClassCastException e) {
            EcDsaSignature ecDsaSignature;
            try {
                ecDsaSignature = null;
            }
            catch (Throwable throwable) {
                try {
                    decoder.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            decoder.close();
            return ecDsaSignature;
        }
        decoder.close();
        return EcDsaSignature.builder().r(r.getPositiveValue()).s(s.getPositiveValue()).build();
    }

    public BigInteger r();

    public BigInteger s();

    @Value.Derived
    default public UnsignedByteArray der() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(72);
        try {
            DERSequenceGenerator seq = new DERSequenceGenerator((OutputStream)bos);
            seq.addObject((ASN1Primitive)new ASN1Integer(this.r()));
            seq.addObject((ASN1Primitive)new ASN1Integer(this.s()));
            seq.close();
            return UnsignedByteArray.of(bos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Value.Check
    default public void isStrictlyCanonical() {
        int sigLen = this.der().length();
        Preconditions.checkArgument((sigLen >= 8 && sigLen <= 72 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.der().get(0).asInt() == 48 && this.der().get(1).asInt() == sigLen - 2 ? 1 : 0) != 0);
        int rPos = 4;
        int rLen = this.der().get(rPos - 1).asInt();
        Preconditions.checkArgument((rLen >= 1 && rLen <= 33 && rLen + 7 <= sigLen ? 1 : 0) != 0, (Object)"r is the wrong length.");
        int sPos = rLen + 6;
        int sLen = this.der().get(sPos - 1).asInt();
        Preconditions.checkArgument((sLen >= 1 && sLen <= 33 && rLen + sLen + 6 == sigLen ? 1 : 0) != 0, (Object)"s is the wrong length.");
        Preconditions.checkArgument((this.der().get(rPos - 2).asInt() == 2 && this.der().get(sPos - 2).asInt() == 2 ? 1 : 0) != 0, (Object)"r or s have the wrong type.");
        Preconditions.checkArgument(((this.der().get(rPos).asInt() & 0x80) == 0 ? 1 : 0) != 0, (Object)"r cannot be negative.");
        Preconditions.checkArgument((this.der().get(rPos).asInt() != 0 || rLen != 1 ? 1 : 0) != 0, (Object)"r cannot be 0.");
        Preconditions.checkArgument((this.der().get(rPos).asInt() != 0 || (this.der().get(rPos + 1).asInt() & 0x80) != 0 ? 1 : 0) != 0, (Object)"r cannot be padded.");
        Preconditions.checkArgument(((this.der().get(sPos).asInt() & 0x80) == 0 ? 1 : 0) != 0, (Object)"s cannot be negative.");
        Preconditions.checkArgument((this.der().get(sPos).asInt() != 0 || sLen != 1 ? 1 : 0) != 0, (Object)"s cannot be 0.");
        Preconditions.checkArgument((this.der().get(sPos).asInt() != 0 || (this.der().get(sPos + 1).asInt() & 0x80) != 0 ? 1 : 0) != 0, (Object)"s cannot be padded");
        byte[] rBytes = new byte[rLen];
        byte[] sBytes = new byte[sLen];
        System.arraycopy(this.der().toByteArray(), rPos, rBytes, 0, rLen);
        System.arraycopy(this.der().toByteArray(), sPos, sBytes, 0, sLen);
        BigInteger r = new BigInteger(1, rBytes);
        BigInteger s = new BigInteger(1, sBytes);
        BigInteger order = BcKeyUtils.PARAMS.getN();
        Preconditions.checkArgument((r.compareTo(order) <= -1 && s.compareTo(order) <= -1 ? 1 : 0) != 0, (Object)"r or s greater than modulus");
        Preconditions.checkArgument((order.subtract(s).compareTo(s) > -1 ? 1 : 0) != 0);
    }
}

