/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.crypto.signing.bc;

import java.math.BigInteger;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.XrplBinaryCodec;
import org.xrpl.xrpl4j.crypto.HashingUtils;
import org.xrpl.xrpl4j.crypto.keys.PrivateKey;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.crypto.keys.bc.BcKeyUtils;
import org.xrpl.xrpl4j.crypto.signing.AbstractSignatureService;
import org.xrpl.xrpl4j.crypto.signing.Signature;
import org.xrpl.xrpl4j.crypto.signing.SignatureService;
import org.xrpl.xrpl4j.crypto.signing.SignatureUtils;
import org.xrpl.xrpl4j.crypto.signing.bc.EcDsaSignature;
import org.xrpl.xrpl4j.crypto.signing.bc.ImmutableEcDsaSignature;
import org.xrpl.xrpl4j.model.jackson.ObjectMapperFactory;

public class BcSignatureService
extends AbstractSignatureService<PrivateKey>
implements SignatureService<PrivateKey> {
    private final Ed25519Signer ed25519Signer;
    private final ECDSASigner ecdsaSigner;

    public BcSignatureService() {
        this(new SignatureUtils(ObjectMapperFactory.create(), XrplBinaryCodec.getInstance()), new Ed25519Signer(), new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest())));
    }

    public BcSignatureService(SignatureUtils signatureUtils, Ed25519Signer ed25519Signer, ECDSASigner ecdsaSigner) {
        super(signatureUtils);
        this.ed25519Signer = Objects.requireNonNull(ed25519Signer);
        this.ecdsaSigner = Objects.requireNonNull(ecdsaSigner);
    }

    @Override
    protected synchronized Signature edDsaSign(PrivateKey privateKey, UnsignedByteArray signableTransactionBytes) {
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(signableTransactionBytes);
        Ed25519PrivateKeyParameters privateKeyParameters = BcKeyUtils.toEd25519PrivateKeyParams(privateKey);
        byte[] signableBytes = signableTransactionBytes.toByteArray();
        this.ed25519Signer.reset();
        this.ed25519Signer.init(true, (CipherParameters)privateKeyParameters);
        this.ed25519Signer.update(signableBytes, 0, signableBytes.length);
        UnsignedByteArray sigBytes = UnsignedByteArray.of(this.ed25519Signer.generateSignature());
        return Signature.builder().value(sigBytes).build();
    }

    @Override
    protected synchronized Signature ecDsaSign(PrivateKey privateKey, UnsignedByteArray transactionBytes) {
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(transactionBytes);
        UnsignedByteArray messageHash = HashingUtils.sha512Half(transactionBytes);
        ECPrivateKeyParameters ecPrivateKeyParams = BcKeyUtils.toEcPrivateKeyParams(privateKey);
        this.ecdsaSigner.init(true, (CipherParameters)ecPrivateKeyParams);
        BigInteger[] signatures = this.ecdsaSigner.generateSignature(messageHash.toByteArray());
        BigInteger r = signatures[0];
        BigInteger s = signatures[1];
        BigInteger otherS = BcKeyUtils.PARAMS.getN().subtract(s);
        if (s.compareTo(otherS) > 0) {
            s = otherS;
        }
        ImmutableEcDsaSignature sig = EcDsaSignature.builder().r(r).s(s).build();
        UnsignedByteArray sigBytes = sig.der();
        return Signature.builder().value(sigBytes).build();
    }

    @Override
    protected synchronized boolean edDsaVerify(PublicKey publicKey, UnsignedByteArray transactionBytes, Signature signature) {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(transactionBytes);
        Objects.requireNonNull(signature);
        Ed25519PublicKeyParameters bcPublicKey = BcKeyUtils.toEd25519PublicKeyParameters(publicKey);
        this.ed25519Signer.reset();
        this.ed25519Signer.init(false, (CipherParameters)bcPublicKey);
        this.ed25519Signer.update(transactionBytes.toByteArray(), 0, transactionBytes.length());
        return this.ed25519Signer.verifySignature(signature.value().toByteArray());
    }

    @Override
    protected synchronized boolean ecDsaVerify(PublicKey publicKey, UnsignedByteArray transactionBytes, Signature signature) {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(transactionBytes);
        Objects.requireNonNull(signature);
        ECPublicKeyParameters bcPublicKey = BcKeyUtils.toEcPublicKeyParameters(publicKey);
        UnsignedByteArray messageHash = HashingUtils.sha512Half(transactionBytes);
        EcDsaSignature sig = EcDsaSignature.fromDer(signature.value().toByteArray());
        if (sig == null) {
            return false;
        }
        this.ecdsaSigner.init(false, (CipherParameters)bcPublicKey);
        return this.ecdsaSigner.verifySignature(messageHash.toByteArray(), sig.r(), sig.s());
    }

    @Override
    public PublicKey derivePublicKey(PrivateKey privateKey) {
        Objects.requireNonNull(privateKey);
        return BcKeyUtils.toPublicKey(privateKey);
    }
}

